#include "stdafx.h"
#include "resource.h"
#include "FlatButton.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static BOOL TransStretchBlt( CDC *pDCdest, int nXDest, int nYDest,	int nWDest,	int nHDest,
    CDC *pDCsrc, int nXSrc,  int nYSrc, int nWSrc, int nHSrc, 
	COLORREF cr, BOOL dis=0, COLORREF clrdis=0);

//---------------------------------------------------------
// C F l a t B u t  t o n
//
CFlatButton::CFlatButton()
{
	m_bMouseOver=0;

	m_bStretch=0;

	m_clrTransparent=0;
	m_bTransparent=0;
	
	m_clrBackground=0;
	m_bBackground=0;

	m_bMakeBMP=1;

	m_bChecked=0;
}

//---------------------------------------------------------
// ~ C F l a t B  u t t o n 
//
CFlatButton::~CFlatButton()
{
	m_bmp.DeleteObject();

}


BEGIN_MESSAGE_MAP(CFlatButton, CButton)
	//{{AFX_MSG_MAP(CFlatButton)
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_PALETTECHANGED()
	ON_WM_SYSCOLORCHANGE()
	ON_WM_ENABLE()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//---------------------------------------------------------
// O n M o u s e M o v e 
//
void CFlatButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	if (GetCapture() != this)
	{
		if(GetParentOwner() == GetForegroundWindow())
		{
			SetCapture();
			m_bMouseOver=1;
			InvalidateRect(NULL,0);
		}
	}
	else 
	{
		CRect rect;
		GetClientRect(&rect);
		if (!rect.PtInRect(point)) 
		{
			SetState(0);
			m_bMouseOver=0;
			ReleaseCapture();
			InvalidateRect(NULL,0);
		}
	}
}


//---------------------------------------------------------
// O n L B u t t o n D o w n 
//
void CFlatButton::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CButton::OnLButtonDown(nFlags, point);
	SetState(1);
	InvalidateRect(NULL,0);
}

//---------------------------------------------------------
// O n L B u t t o n U p 
//
void CFlatButton::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CButton::OnLButtonUp(nFlags, point);
	SetState(0);
	InvalidateRect(NULL,0);
}


//---------------------------------------------------------
// O n L B u t t o n D b l C l k
//
void CFlatButton::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CButton::OnLButtonDblClk(nFlags, point);
	SetState(1);
	InvalidateRect(NULL,0);
}

//---------------------------------------------------------
// O n P a i n t 
//
void CFlatButton::OnPaint() 
{
	if(m_bMakeBMP) 
	{
		MakeBMP();
		m_bMakeBMP=0;
	}

	UINT state=GetState();
	BOOL enabled=IsWindowEnabled();

	CPaintDC dc(this); 
	CRect rc;
	GetClientRect(rc);
	CDC memdc;
	if(memdc.CreateCompatibleDC(&dc)==0) return;
	CBitmap bmp, *obmp;
	bmp.CreateCompatibleBitmap(&dc,rc.Width(),rc.Height());
	obmp=(CBitmap *) memdc.SelectObject(&bmp);


	CDC mem2;
	mem2.CreateCompatibleDC(&dc);
	CBitmap *oob;
	if(enabled)
		oob=(CBitmap*)mem2.SelectObject(&m_bmp);
	else
		oob=(CBitmap*)mem2.SelectObject(&m_disbmp);

	BITMAP b;
	m_bmp.GetBitmap(&b);

	// depressed
	if((state&4 && m_bMouseOver) || m_bChecked)
	{
		memdc.BitBlt(1,1, rc.Width()-1,rc.Height()-1,&mem2, 0,0,SRCCOPY);
		memdc.DrawEdge( &rc, BDR_SUNKENOUTER, BF_RECT );
	}
	// up or flat
	else
	{
		memdc.BitBlt(0, 0, rc.Width(),rc.Height(),&mem2, 0,0,SRCCOPY);
		if(m_bMouseOver) memdc.DrawEdge( &rc, BDR_RAISEDINNER, BF_RECT );
	}

	mem2.SelectObject(oob);
	
	dc.BitBlt(0, 0, rc.Width(),rc.Height(),&memdc, 0,0,SRCCOPY);
	memdc.SelectObject(obmp);
	bmp.DeleteObject();

}


void CFlatButton::OnPaletteChanged(CWnd* pFocusWnd) 
{
	CButton::OnPaletteChanged(pFocusWnd);
	m_bMakeBMP=1;
	
}

void CFlatButton::OnSysColorChange() 
{
	CButton::OnSysColorChange();
	m_bMakeBMP=1;
	
}

BOOL CFlatButton::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	BOOL r;
	r=CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
	return r;
}

void CFlatButton::OnEnable(BOOL bEnable) 
{
	CButton::OnEnable(bEnable);
	m_bMakeBMP=1;
}

void CFlatButton::SetCheck(int c)
{
	m_bChecked=(BOOL)c;
	InvalidateRect(NULL);
}
int CFlatButton::GetCheck()
{
	return (int)m_bChecked;
}

void CFlatButton::MakeBMP()
{
	m_bmp.DeleteObject();
	m_disbmp.DeleteObject();
	UINT state=GetState();
	BOOL enabled=IsWindowEnabled();

	CDC* pdc = GetDC(); 
	CDC memdc;
	if(memdc.CreateCompatibleDC(pdc)==0) return;
	
	CRect rc;
	GetClientRect(rc);

	rc.bottom+=1;
	rc.right+=1;

	CBitmap bmp, *obmp;
	m_bmp.CreateCompatibleBitmap(pdc,rc.Width(),rc.Height());
	m_disbmp.CreateCompatibleBitmap(pdc,rc.Width(),rc.Height());
	obmp=(CBitmap *) memdc.SelectObject(&m_bmp);
	
	if(m_bBackground)
	{
		if(state&1) //grayed
			memdc.FillSolidRect(rc,m_clrBackground);
		else
			memdc.FillSolidRect(rc,m_clrBackground);
	}
	else // pick up what's uner it
	{

//		memdc.BitBlt(0, 0, rc.Width(), rc.Height(),pdc,0,0,SRCCOPY);
		if(state&1) //grayed
			memdc.FillSolidRect(rc,GetSysColor(COLOR_BTNFACE));
		else
			memdc.FillSolidRect(rc,GetSysColor(COLOR_BTNFACE));
	}

	
	CString str;
	GetWindowText(str);

	HBITMAP hbm=GetBitmap( );
	if(hbm!=NULL)
	{
		CRect R;
		R=rc;
		R.left+=1;
		R.right-=2;
		R.top+=1;
		R.bottom-=2;

		CBitmap *bm=CBitmap::FromHandle(hbm);
		BITMAP b;
		bm->GetBitmap(&b);
	
		CDC mem2;
		mem2.CreateCompatibleDC(pdc);
	
		CBitmap *oob=mem2.SelectObject(bm);
		CPoint pt(1,1);
		if(m_bStretch)
		{
			if(m_bTransparent)
				TransStretchBlt(&memdc,pt.x,pt.y, R.Width(),R.Height(),&mem2, 0,0,b.bmWidth,b.bmHeight,m_clrTransparent);
			else
				memdc.StretchBlt(pt.x,pt.y, R.Width(),R.Height(),&mem2, 0,0,b.bmWidth,b.bmHeight,SRCCOPY);
		}
		else
		{
			CSize sz;
			sz.cx=R.Width();
			sz.cy=R.Height();
			// center it if it is too small
			if(b.bmWidth<sz.cx)
			{
				pt.x+=(sz.cx-b.bmWidth)/2;
				sz.cx=b.bmWidth;
			}
			if(b.bmHeight<sz.cy)
			{
				pt.y+=(sz.cy-b.bmHeight)/2;
				sz.cy=b.bmHeight;
			}
			
			if(m_bTransparent)
				TransStretchBlt(&memdc,pt.x, pt.y, sz.cx, sz.cy,
					&mem2, 0,0,sz.cx,sz.cy, m_clrTransparent);
			else
				memdc.BitBlt(pt.x, pt.y, sz.cx,sz.cy,&mem2, 0,0,SRCCOPY);
			//memdc.DrawState( pt, sz, hbm, DSS_NORMAL);
		}
		mem2.SelectObject(oob);
	}
	else
	{
		CWnd *p=GetParent();
		CFont*pfont=p->GetFont();

		CFont *of=memdc.SelectObject(pfont);
		CRect rc2=rc;
//		if(state&4){rc2.left+=1; rc2.top+=1;rc2.right+=1; rc2.bottom+=1;};
		memdc.DrawText(str,&rc2,DT_CENTER|DT_VCENTER|DT_SINGLELINE);
		memdc.SelectObject(of);
	}

///////////////// dis state
	memdc.SelectObject(&m_disbmp);
	
	if(m_bBackground)
	{
		if(state&1) //grayed
			memdc.FillSolidRect(rc,m_clrBackground);
		else
			memdc.FillSolidRect(rc,m_clrBackground);
	}
	else // pick up what's uner it
	{

//		memdc.BitBlt(0, 0, rc.Width(), rc.Height(),pdc,0,0,SRCCOPY);
		if(state&1) //grayed
			memdc.FillSolidRect(rc,GetSysColor(COLOR_BTNFACE));
		else
			memdc.FillSolidRect(rc,GetSysColor(COLOR_BTNFACE));
	}

	GetWindowText(str);

	hbm=GetBitmap( );
	if(hbm!=NULL)
	{
		CRect R;
		R=rc;
		R.left+=1;
		R.right-=2;
		R.top+=1;
		R.bottom-=2;

		CBitmap *bm=CBitmap::FromHandle(hbm);
		BITMAP b;
		bm->GetBitmap(&b);
	
		CDC mem2;
		mem2.CreateCompatibleDC(pdc);
	
		CBitmap *oob=mem2.SelectObject(bm);
		CPoint pt(1,1);
		if(m_bStretch)
		{
			if(m_bTransparent)
			{

				if(m_bBackground)
					TransStretchBlt(&memdc,pt.x,pt.y, R.Width(),R.Height(),&mem2, 0,0,b.bmWidth,b.bmHeight,m_clrTransparent,1,m_clrBackground);
				else
					TransStretchBlt(&memdc,pt.x,pt.y, R.Width(),R.Height(),&mem2, 0,0,b.bmWidth,b.bmHeight,m_clrTransparent,1,GetSysColor(COLOR_BTNFACE));
			}
			else
				memdc.StretchBlt(pt.x,pt.y, R.Width(),R.Height(),&mem2, 0,0,b.bmWidth,b.bmHeight,SRCCOPY);
		}
		else
		{
			CSize sz;
			sz.cx=R.Width();
			sz.cy=R.Height();
			// center it if it is too small
			if(b.bmWidth<sz.cx)
			{
				pt.x+=(sz.cx-b.bmWidth)/2;
				sz.cx=b.bmWidth;
			}
			if(b.bmHeight<sz.cy)
			{
				pt.y+=(sz.cy-b.bmHeight)/2;
				sz.cy=b.bmHeight;
			}
			
			if(m_bTransparent)
				if(m_bBackground)
				TransStretchBlt(&memdc,pt.x, pt.y, sz.cx, sz.cy,
					&mem2, 0,0,sz.cx,sz.cy, m_clrTransparent,1,m_clrBackground);
				else
				TransStretchBlt(&memdc,pt.x, pt.y, sz.cx, sz.cy,
					&mem2, 0,0,sz.cx,sz.cy, m_clrTransparent,1,GetSysColor(COLOR_BTNFACE));
			else
				memdc.BitBlt(pt.x, pt.y, sz.cx,sz.cy,&mem2, 0,0,SRCCOPY);
			//memdc.DrawState( pt, sz, hbm, DSS_NORMAL);
		}
		mem2.SelectObject(oob);
	}
	else
	{
		CWnd *p=GetParent();
		CFont*pfont=p->GetFont();

		CFont *of=memdc.SelectObject(pfont);
		CRect rc2=rc;
//		if(state&4){rc2.left+=1; rc2.top+=1;rc2.right+=1; rc2.bottom+=1;};
		memdc.DrawText(str,&rc2,DT_CENTER|DT_VCENTER|DT_SINGLELINE);
		memdc.SelectObject(of);
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	memdc.SelectObject(obmp);

}

//---------------------------------------------------------
// T r a n s S t r e t c h  B l t 
//
// an ass slow way to do it.. but it works
BOOL TransStretchBlt( CDC *pDCdest, int nXDest, int nYDest,	int nWDest,	int nHDest,
    CDC *pDCsrc, int nXSrc,  int nYSrc, int nWSrc, int nHSrc, 
	COLORREF cr, BOOL dis, COLORREF clrdis )
{

	COLORREF c;
	int i,j;

	CDC MemDC, MemDC2;
	MemDC.CreateCompatibleDC(pDCdest);
	MemDC2.CreateCompatibleDC(pDCdest);
	
	CBitmap bmp, bmp2, *old, *old2;
	bmp.CreateCompatibleBitmap(pDCdest,nWDest,nHDest);
	bmp2.CreateCompatibleBitmap(pDCdest,nWDest,nHDest);
	
	if(old=MemDC.SelectObject(&bmp))
	{
		// copy background
		MemDC.BitBlt(0, 0, nWDest,nHDest,pDCdest, nXDest, nYDest, SRCCOPY);

		int R,G,B;
		int Rd,Gd,Bd;
		Rd=GetRValue(clrdis);
		Gd=GetGValue(clrdis);
		Bd=GetBValue(clrdis);

		if(old2=MemDC2.SelectObject(&bmp2))
		{
			MemDC2.StretchBlt(0, 0, nWDest,nHDest,pDCsrc, nXSrc, nYSrc, nWSrc, nHSrc, SRCCOPY);

			if(dis)
			{
			for(j=0; j<nHDest; j++)
			{
				for(i=0; i<nWDest; i++)
				{
					c=MemDC2.GetPixel(i, j);
					if(c!=cr) 
					{
						R=(BYTE)((2*Rd+GetRValue(c))/3);
						G=(BYTE)((2*Gd+GetGValue(c))/3);
						B=(BYTE)((2*Bd+GetBValue(c))/3);
						MemDC.SetPixelV(i,j,RGB(R,G,B));
					}
				}
			}
			}
			else
			{
			for(j=0; j<nHDest; j++)
			{
				for(i=0; i<nWDest; i++)
				{
					c=MemDC2.GetPixel(i, j);
					if(c!=cr) MemDC.SetPixelV(i,j,c);
				}
			}
			}
			MemDC2.SelectObject(old2);
		}
		pDCdest->BitBlt(nXDest, nYDest,nWDest,nHDest,&MemDC,0, 0,SRCCOPY);
		MemDC.SelectObject(old);
	}

	bmp.DeleteObject();
	bmp2.DeleteObject();
	return 1;
}

void CFlatButton::OnKillFocus(CWnd* pNewWnd) 
{
	CButton::OnKillFocus(pNewWnd);
	m_bMouseOver=0;
	InvalidateRect(NULL);
	
}
