// CameraView.cpp : implementation of the CCameraView class
//  
#include "stdafx.h"
#include "MedDLe.h"
#include "MedDLeGFX\MedDLeGFX.h"
#include "MedDLeGFX\MedDLeMath.h"
#include "MedDLeEdit.h"		// Our added graphics routines

#include "CameraView.h"
#include"normals.h" // defines vertex_normal[];
#include "MedDLeIO.h"
#include "MedDLeGif.h"
#include "ChildFrm.h"
#include "Anim.h"

void BG_WriteBMP(FILE *out, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h);
void BG_ReadBMP(FILE *in, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h);
void write_gif(char *name, unsigned char *pic, unsigned w, unsigned h);

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////
// bg_3d things
float win_width=3.2f;
float win_height=2.4f;
float focus=4;

//BYTE MedDLeCMap[256*64];

/////////////////////////////////////////////////////////////////////////////
// CCameraView

IMPLEMENT_DYNCREATE(CCameraView, CView)

BEGIN_MESSAGE_MAP(CCameraView, CView)
	//{{AFX_MSG_MAP(CCameraView)
	ON_WM_KEYDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_R_3DV_RESET, OnR3dvReset)
	ON_COMMAND(ID_NOTEXT, OnNotext)
	ON_UPDATE_COMMAND_UI(ID_NOTEXT, OnUpdateNotext)
	ON_COMMAND(ID_FRONTBACK, OnFrontback)
	ON_UPDATE_COMMAND_UI(ID_FRONTBACK, OnUpdateFrontback)
	ON_COMMAND(ID_VERTEX, OnVertex)
	ON_UPDATE_COMMAND_UI(ID_VERTEX, OnUpdateVertex)
	ON_COMMAND(ID_WIREFRAME, OnWireframe)
	ON_UPDATE_COMMAND_UI(ID_WIREFRAME, OnUpdateWireframe)
	ON_COMMAND(ID_FLATSHADE, OnFlatshade)
	ON_UPDATE_COMMAND_UI(ID_FLATSHADE, OnUpdateFlatshade)
	ON_COMMAND(ID_GOUROURD, OnGourourd)
	ON_UPDATE_COMMAND_UI(ID_GOUROURD, OnUpdateGourourd)
	ON_COMMAND(ID_TEXTURED, OnTextured)
	ON_UPDATE_COMMAND_UI(ID_TEXTURED, OnUpdateTextured)
	ON_COMMAND(ID_LIGHTSHADE, OnLightshade)
	ON_UPDATE_COMMAND_UI(ID_LIGHTSHADE, OnUpdateLightshade)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_3DCAPTURE, On3dcapture)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCameraView construction/destruction

CCameraView::CCameraView() : CView()
{
	// TODO: add construction code here
	MovingEye=FALSE; 
	RotatingLight=FALSE; 
	RotatingEye=FALSE;
	LeftStart=FALSE;
	RightStart=FALSE;
	LeftClean=FALSE;
	RightClean=FALSE;
	sensitivity = .85;

}

CCameraView::~CCameraView()
{
}

void CCameraView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	m_World = 1.f;


//	m_Proj = ProjectionMatrix(0.01f, 2000000.0f, (float)(60*PI/180)); // 60 degree FOV
	CMedDLeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CMedDLeFrame *mf=pDoc->m_MedDLeObject.m_curFrame;
	if (mf == NULL  || pDoc->m_MedDLeObject.m_Frames.GetSize()==0)
	{
		m_View = ViewMatrix(
		CMedDLePoint3D(100,0,0), 
		CMedDLePoint3D(0,0,0), 
		CMedDLePoint3D(0,0,1), 0);
	}
	else
	{
//		mf->GetMinMax();
//		float h=fabs(mf->max.x[3]);

		m_View = ViewMatrix(
		CMedDLePoint3D(100,0,0), 
		CMedDLePoint3D(0,0,0), 
		CMedDLePoint3D(0,0,1), 0);

	}

	



	RightStart=0;	
	ResetView();	

}

/////////////////////////////////////////////////////////////////////////////
// CCameraView drawing

void CCameraView::OnDraw(CDC* pDC)
{

	CView::OnDraw(pDC);
	CMedDLeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CMedDLeFrame *mf=pDoc->m_MedDLeObject.m_curFrame;
	if (mf == NULL  || pDoc->m_MedDLeObject.m_Frames.GetSize()==0) 
	{
	    CRect rc;    
		GetClientRect(&rc);
		int resx, resy; 
		resx=rc.right+1;
		resy=rc.bottom+1;
		// upper limit on res of rendering
		if(resx>1023) resx=1024;
		if(resy>1023) resy=1024;
		rc.right=resx-1;
		rc.bottom=resy-1;
	
		MedDLeBeginDraw(pDC, rc, 0);
		resx=MedDLeCDCResX;
		resy=MedDLeCDCResY;
	
		MedDLeEndDraw();
		return;
	}

	int		i,j,k,l;
	float	faceintensity;		// intensity of flat shaded face
	int		nFacePts[12];		// vertex corners (screen coords)
	DWORD		vindex;				// vertex index
	DWORD		findex;				// face index
	CMedDLePoint3D	pt[3];		
	CMedDLePoint3D	facenormal;		
	DWORD faces;
	
	faces = pDoc->m_MedDLeObject.m_BaseFrame->f.GetSize();

	
	// get size of windows
    CRect rc;    
	GetClientRect(&rc);
	int resx, resy; 
	resx=rc.right+1;
	resy=rc.bottom+1;
	// upper limit on res of rendering
	if(resx>1023) resx=1024;
	if(resy>1023) resy=1024;
	rc.right=resx-1;
	rc.bottom=resy-1;
	
	MedDLeBeginDraw(pDC, rc, 0);
	resx=MedDLeCDCResX;
	resy=MedDLeCDCResY;
	// Scaling matrix, scales the points to the screen
	Scaling=1.f;
	Scaling(0,0)=-focus*(double)(resy-1)/win_height;    //scale x
	Scaling(0,2)=(resx/2);
	Scaling(1,2)=(resy/2);
	Scaling(1,1)=-focus*(double)(resy-1)/win_width;    // scale y


	// put all points in camera coordinates
	for(k=0; k < pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); k++)
	{
		
		// the vertext into working coordinates
	    mf->v[k].wx[0] =
			 m_View.m[0][0]*mf->v[k].x[0]
			+m_View.m[0][1]*mf->v[k].x[1]
			+m_View.m[0][2]*mf->v[k].x[2]
			+m_View.m[0][3];
	    mf->v[k].wx[1] =
			 m_View.m[1][0]*mf->v[k].x[0]
			+m_View.m[1][1]*mf->v[k].x[1]
			+m_View.m[1][2]*mf->v[k].x[2]
			+m_View.m[1][3];
	    mf->v[k].wx[2] =
			 m_View.m[2][0]*mf->v[k].x[0]
			+m_View.m[2][1]*mf->v[k].x[1]
			+m_View.m[2][2]*mf->v[k].x[2]
			+m_View.m[2][3];

		// now the vertex normals...
	    mf->v[k].n.wx[0] =
			 m_View.m[0][0]*mf->v[k].n.x[0]
			+m_View.m[0][1]*mf->v[k].n.x[1]
			+m_View.m[0][2]*mf->v[k].n.x[2]
			+m_View.m[0][3];
	    mf->v[k].n.wx[1] =
			 m_View.m[1][0]*mf->v[k].n.x[0]
			+m_View.m[1][1]*mf->v[k].n.x[1]
			+m_View.m[1][2]*mf->v[k].n.x[2]
			+m_View.m[1][3];
	    mf->v[k].n.wx[2] =
			 m_View.m[2][0]*mf->v[k].n.x[0]
			+m_View.m[2][1]*mf->v[k].n.x[1]
			+m_View.m[2][2]*mf->v[k].n.x[2]
			+m_View.m[2][3];

	}
	
	// do some sorting...
	// grow index array if needed
	GrowFor(faces);

	// go through all the triangles and put in list to sort
	for(k=0; k <faces; k++)
	{
		pIndexArray[k]=k;
	
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[0];
		pZArray[k]=mf->v[vindex].wx[2];
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[1];
		if(mf->v[vindex].wx[2] > pZArray[k]) pZArray[k]=mf->v[vindex].wx[2];
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[2];
		if(mf->v[vindex].wx[2] > pZArray[k]) pZArray[k]=mf->v[vindex].wx[2];
	}

	MedDLeSort(pZArray, pIndexArray, 0, faces-1);

	// draw floor grid
	// DrawGrid(resy);

	// go through all the triangles and draw em
	for(k=0; k <faces; k++)
	{
		findex=pIndexArray[k];
		// get the 3 vertices for this face (in camera's coordinates)
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[0];
		pt[0].x[0]=mf->v[vindex].wx[0];
		pt[0].x[1]=mf->v[vindex].wx[1];
		pt[0].x[2]=mf->v[vindex].wx[2];
		
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[1];
		pt[1].x[0]=mf->v[vindex].wx[0];
		pt[1].x[1]=mf->v[vindex].wx[1];
		pt[1].x[2]=mf->v[vindex].wx[2];

		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[2];
		pt[2].x[0]=mf->v[vindex].wx[0];
		pt[2].x[1]=mf->v[vindex].wx[1];
		pt[2].x[2]=mf->v[vindex].wx[2];

		// get face normal
		facenormal=CrossProduct(pt[0] - pt[1], pt[2] - pt[1]);
		facenormal=Normalize(facenormal);
		
		// to screen coords (i cut out some fat, p=Scale*pt)
		pt[0].wx[2] = pt[0].x[2];
		pt[1].wx[2] = pt[1].x[2];
		pt[2].wx[2] = pt[2].x[2];

		// if in front of camera
		if((pt[0].wx[2]!=0.f)&&(pt[0].wx[2]>0.f) &&
			(pt[1].wx[2]!=0.f)&&(pt[1].wx[2]>0.f) &&
			(pt[2].wx[2]!=0.f)&&(pt[2].wx[2]>0.f) &&
			facenormal.x[2]<0)
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
			pt[2].wx[0] = Scaling.m[0][0]*pt[2].x[0] + Scaling.m[0][2]*pt[2].x[2];
			pt[2].wx[1] = Scaling.m[1][1]*pt[2].x[1] + Scaling.m[1][2]*pt[2].x[2];
	
			nFacePts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
			nFacePts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
			nFacePts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
			nFacePts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
			nFacePts[4]=(int)(pt[2].wx[0]/pt[2].wx[2]);
			nFacePts[5]=resy-(int)(pt[2].wx[1]/pt[2].wx[2]);

			nFacePts[6]=nFacePts[0];
			nFacePts[7]=nFacePts[1];


			int color;
			
			color=MedDLeCMap[pDoc->m_MedDLeObject.m_BaseFrame->f[findex].color + 256*(int)(64+facenormal.x[2]*64.f)];
			G_ambient_polygon(nFacePts,3,color);
			G_line(&nFacePts[0],&nFacePts[2],0);
			G_line(&nFacePts[4],&nFacePts[2],0);
			G_line(&nFacePts[4],&nFacePts[0],0);
		}


	}


	
	MedDLeEndDraw();

}


void CCameraView::DrawGrid(int resy)
{
	//CMedDLeFrame *mf=pDoc->m_MedDLeObject.m_curFrame;
	CMedDLePoint3D	pt[3];		

	int i,j,k;
	int npts[4];
	for(k=0; k <= 10; k++)
	{
		for(i=0; i<3; i++)
		{

	    pt[0].x[i] =
			 m_View.m[i][0]*(-100.f+k*20)
			+m_View.m[i][1]*-100.f
			+m_View.m[i][3];

		pt[1].x[i] =
			 m_View.m[i][0]*(-100.f+k*20)
			+m_View.m[i][1]*100.f
			+m_View.m[i][3];

		}

		pt[0].wx[2]=pt[0].x[2];
		pt[1].wx[2]=pt[1].x[2];
		// if in front of camera
		if((pt[0].x[2]!=0.f) && (pt[1].x[2]!=0.f))
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
		
			npts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
			npts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
			npts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
			npts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
			G_line(&npts[0],&npts[2],6);
		}

	}
	for(k=0; k <= 10; k++)
	{
		for(i=0; i<3; i++)
		{

	    pt[0].x[i] =
			 m_View.m[i][0]*-100.f
			+m_View.m[i][1]*(-100.f+k*20)
			+m_View.m[i][3];

		pt[1].x[i] =
			 m_View.m[i][0]*100.f
			+m_View.m[i][1]*(-100.f+k*20)
			+m_View.m[i][3];

		}

		pt[0].wx[2]=fabs(pt[0].x[2]);
		pt[1].wx[2]=fabs(pt[1].x[2]);
		// if in front of camera
		if((pt[0].x[2]!=0.f) && (pt[1].x[2]!=0.f))
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
		
			npts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
			npts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
			npts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
			npts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
			G_line(&npts[0],&npts[2],6);
		}

	}

}


/////////////////////////////////////////////////////////////////////////////
// CCameraView diagnostics

#ifdef _DEBUG
void CCameraView::AssertValid() const
{
	CView::AssertValid();
}

void CCameraView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMedDLeDoc* CCameraView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMedDLeDoc)));
	return (CMedDLeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCameraView message handlers


// sorting routine from  some book. Not the fastest, but it works.
/*void sort(float v[], int vi[], int left, int right)
{
	int i, last;

	if(left>=right) return;
	swap(v,vi,left,(left+right)/2);
	last=left;
	for(i=left+1; i<=right; i++)
		if(v[i]>v[left])
			swap(v,vi,++last,i);
	swap(v,vi,left,last);
	sort(v,vi,left,last-1);
	sort(v,vi,last+1,right);

}

void swap(float v[], int vi[], int i, int j)
{
	float temp;
	int itemp;

	temp = v[i];
	v[i]=v[j];
	v[j]=temp;
	itemp=vi[i];
	vi[i]=vi[j];
	vi[j]=itemp;
}

*/
void CCameraView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	CMedDLeDoc* pDoc = GetDocument();
/*	if (nChar=='T') {
		BG_Matrix Rz;
		int dz;
		dz=8;
		Rz=BG_CalcRz((byte)dz);
		pDoc->sit.dir_matrix=BG_MatrixMult(&Rz,&pDoc->sit.dir_matrix);
		InvalidateRect(NULL,0);
	} 
	else 
		pDoc->HandleCommonKeys(nChar, nRepCnt, nFlags, -1);
*/
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CCameraView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc= GetDocument();

	if (GetCapture() != this) return;

	if (LeftStart) 
	{
		if (RotatingEye)
		{
			float dx,dy;
			dx=(float)(OldPoint.x-point.x)/70.;
			dy=-(float)(OldPoint.y-point.y)/70.;
		    float x=m_View(0,3);
			float y=m_View(1,3);
			float z=m_View(2,3);

			m_View= MatrixMultiply(Translate(-x,-y,-z),m_View);
			m_View = MatrixMultiply(RotateX(dy),m_View);
			m_View=MatrixMultiply(Translate(x,y,z),m_View);
			m_View = MatrixMultiply(m_View,RotateZ(dx)); 

			OldPoint=point;
			InvalidateRect(NULL,0);
		} 
		else if (RotatingLight)
		{
	//		pDoc->light_ray=oldlight;
	//		BG_Matrix Rx;
	//		BG_Matrix Ry;
			int dx,dy;
			dx=(ClickPoint.x-point.x);
			dy=(ClickPoint.y-point.y);
	//		Rx=BG_CalcRx((byte)dx);
	//		Ry=BG_CalcRy((byte)dy);
	//		pDoc->light_ray=BG_MatrixVector3(&Rx,&pDoc->light_ray);
	//		pDoc->light_ray=BG_MatrixVector3(&Ry,&pDoc->light_ray);
			OldPoint=point;
			InvalidateRect(NULL,0);
		}
	}
	else if (RightStart)
	{
		if (NoMotion == 0) 
		{
			if (abs(point.x-OldPoint.x) > 2) NoMotion = 1;
			if (abs(point.y-OldPoint.y) > 2) NoMotion = 1;
		} 
		else if (MovingEye)
		{
   			float dx,dy;
			dx=(float)(OldPoint.x-point.x);
			dy=(float)(OldPoint.y-point.y);

			if (nFlags&MK_LBUTTON)
			m_View=MatrixMultiply(Translate(dx,0,dy),m_View);
			else	
			m_View=MatrixMultiply(Translate(dx,dy,0),m_View);

			OldPoint=point;
			InvalidateRect(NULL,0);
		}
	}
	
}

void CCameraView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc= GetDocument();
	if ((!RightStart) && !(nFlags&MK_RBUTTON)){
		HasShift=FALSE;
		if (nFlags&MK_SHIFT) HasShift=TRUE;
		HasCtrl=FALSE;
		if (nFlags&MK_CONTROL) HasCtrl=TRUE;
/*		if (HasShift) {
			RenderHit(point);
			int i, cnt;
			cnt=pDoc->HitIndex.GetSize();
			if(cnt==0) return;

			int j=cnt-1;
			int PClicked;
			PClicked=pDoc->Tris[pDoc->HitIndex.GetAt(j)].vindex[0];
			int trin=pDoc->HitIndex.GetAt(j);
			int objn=pDoc->Verts[PClicked].object;
			int grpn=pDoc->Verts[PClicked].group;
			if (pDoc->EditMode == SM_VERT){
				if((pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags&O_SELECTED)
				&&(pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags&O_SELECTED)
				&&(pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags&O_SELECTED))
				{
					pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags &=~O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags &=~O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags &=~O_SELECTED;
				}
				else
				{
					pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags |= O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags |= O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags |= O_SELECTED;
				}
			} else if (pDoc->EditMode == SM_TRI){ 
				if (pDoc->Tris[trin].Vflags & O_SELECTED) pDoc->Tris[trin].Vflags &=~O_SELECTED;
				else pDoc->Tris[trin].Vflags |= O_SELECTED;
			} else if (pDoc->EditMode == SM_GROUP){
				if (pDoc->Objects[objn].Groups[grpn]->flags & O_SELECTED) pDoc->Objects[objn].Groups[grpn]->flags &=~O_SELECTED;
				else pDoc->Objects[objn].Groups[grpn]->flags |= O_SELECTED;
			} else if (pDoc->EditMode == SM_OBJECT){
				if (pDoc->Objects[objn].flags & O_SELECTED) pDoc->Objects[objn].flags &=~O_SELECTED;
				else pDoc->Objects[objn].flags |= O_SELECTED;
			}
			pDoc->ColorSort();
			pDoc->UpdateAllViews(NULL);
		}
		else {
		*///	oldsit=pDoc->sit;
			RotatingEye=TRUE;
			LeftStart=TRUE;
			LeftClean=FALSE;
			RightClean=FALSE;
			SetCapture();
			NoMotion=0;
			ClickPoint=point;
			OldPoint=point;
	}
}

void CCameraView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if (LeftStart){
		LeftStart=FALSE;
		if (!(nFlags&MK_RBUTTON) && (GetCapture()==this)) ReleaseCapture();
		else if (nFlags&MK_RBUTTON) RightClean=TRUE;
		RotatingEye=FALSE;
		RotatingLight=FALSE;
	}
	if (LeftClean==TRUE) if (GetCapture()==this) ReleaseCapture();
	LeftClean=FALSE;
}

void CCameraView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc=GetDocument();
	if ((!LeftStart) && !(nFlags&MK_LBUTTON)){
		MovingEye=TRUE;
		RightStart=TRUE;
		LeftClean=FALSE;
		RightClean=FALSE;
		SetCapture();
		NoMotion=0;
		OldPoint=point;
	} else{
		ClickPoint=point;
//		oldlight=pDoc->light_ray;
		RotatingEye=FALSE;
		RotatingLight=TRUE;
	}
	
}

void CCameraView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc=GetDocument();
	if (RightStart){
		RightStart=FALSE;
		if (!(nFlags&MK_LBUTTON) && (GetCapture()==this)){
			ReleaseCapture();
//			if (NoMotion==0){
//				CMenu menu;
//				if (menu.LoadMenu(IDR_POPUPS)){
//					CMenu* pPopup = menu.GetSubMenu(0);
//					ASSERT(pPopup != NULL);
//					ClientToScreen(&point);
//					pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, AfxGetMainWnd());
//				}
//			}
		} else if (nFlags&MK_LBUTTON) LeftClean=TRUE;
		MovingEye=FALSE;
	} else{
		RotatingEye=TRUE;
//		oldsit=pDoc->sit;
		ClickPoint=point;
		RotatingLight=FALSE;
	}
	if (RightClean==TRUE) if (GetCapture()==this) ReleaseCapture();
	RightClean=FALSE;
}

void CCameraView::ResetView(void) 
{
	CMedDLeDoc* pDoc = GetDocument();
}

BOOL CCameraView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void CCameraView::OnR3dvReset() 
{
	ResetView();
	InvalidateRect(NULL);
}

void CCameraView::OnNotext() 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pDoc->fill_mode = 0;
	InvalidateRect(NULL);
}

void CCameraView::OnUpdateNotext(CCmdUI* pCmdUI) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	pCmdUI->SetCheck(pDoc->fill_mode == 0);
}

void CCameraView::OnFrontback() 
{
/*	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	if (pDoc->Gflags&S_HAS_SKIN) {
		if (pDoc->Rflags&R_FB) pDoc->Rflags &= ~R_FB;
		else pDoc->Rflags |= R_FB;
		InvalidateRect(NULL);
	}
	*/
}

void CCameraView::OnUpdateFrontback(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Gflags&S_HAS_SKIN) pCmdUI->SetCheck(pDoc->Rflags&R_FB);
//	else pCmdUI->Enable(FALSE);
}

void CCameraView::OnVertex() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Rflags&R_VERT) pDoc->Rflags &= ~R_VERT;
//	else pDoc->Rflags |= R_VERT;
//	InvalidateRect(NULL);
}

void CCameraView::OnUpdateVertex(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pCmdUI->SetCheck(pDoc->Rflags&R_VERT);
}

void CCameraView::OnWireframe() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Rflags&R_WIRE) pDoc->Rflags &= ~R_WIRE;
//	else pDoc->Rflags |= R_WIRE;
//	InvalidateRect(NULL);
}

void CCameraView::OnUpdateWireframe(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pCmdUI->SetCheck(pDoc->Rflags&R_WIRE);
}

void CCameraView::OnFlatshade() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pDoc->fill_mode = 1;
//	InvalidateRect(NULL);
}

void CCameraView::OnUpdateFlatshade(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	pCmdUI->SetCheck(pDoc->fill_mode == 1);
}

void CCameraView::OnGourourd() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pDoc->fill_mode = 2;
//	InvalidateRect(NULL);
}

void CCameraView::OnUpdateGourourd(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	pCmdUI->SetCheck(pDoc->fill_mode == 2);
}

void CCameraView::OnTextured() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Gflags&S_HAS_SKIN) {
//		pDoc->fill_mode = 3;
//		InvalidateRect(NULL);
//	}
}

void CCameraView::OnUpdateTextured(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	if (pDoc->Gflags&S_HAS_SKIN) pCmdUI->SetCheck(pDoc->fill_mode == 3);
//	else pCmdUI->Enable(FALSE);
}

void CCameraView::OnLightshade() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Gflags&S_HAS_SKIN) {
//		pDoc->fill_mode = 4;
//		InvalidateRect(NULL);
//	}
}

void CCameraView::OnUpdateLightshade(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	if (pDoc->Gflags&S_HAS_SKIN) pCmdUI->SetCheck(pDoc->fill_mode == 4);
//	else pCmdUI->Enable(FALSE);
}

void CCameraView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
//	CMenu menu;
//	if (menu.LoadMenu(IDR_POPUPS)){
//		CMenu* pPopup = menu.GetSubMenu(0);
//		ASSERT(pPopup != NULL);
//		ClientToScreen(&point);
//		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, AfxGetMainWnd());
//	}
}

void CCameraView::On3dcapture() 
{
/*	CString Filter("Gif87 (*.gif)|*.gif|");
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	

	Filter+="Windows Bitmap (*.bmp)|*.bmp||";
	
	CFileDialog fileDlg(FALSE, NULL,NULL,OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,Filter);
	if(fileDlg.DoModal()==IDOK)
	{
		CString name=fileDlg.GetPathName();
		char *filename;
		char *ptr;
		char *useext;

		if (fileDlg.m_ofn.nFilterIndex==1) useext="gif";
		else useext="bmp";
		int l=name.GetLength();
		l--;

		if (fileDlg.GetFileExt().IsEmpty()){ 
			if (name[l]!='.') name+='.';
			name+=useext;
		}
		
		name.MakeLower();
		filename = name.GetBuffer(1);

		CDC *tempDC=GetDC();
		OnDraw(tempDC);
		ReleaseDC(tempDC);

		CRect rc;
		GetClientRect(&rc);
		int TResX, TResY;
		for (TResX = (rc.right+1); TResX%4 != 0; TResX++);
		TResY = rc.bottom+1;

		unsigned char *pic;

		pic=new unsigned char[TResX*TResY];
		for (int d=0; d<TResY; d++){
			for (int e=0; e<TResX; e++){
				pic[(((TResY-1)-d)*TResX)+e]=RAMScreen[(d*TResX)+e];
			}
		}

		if (fileDlg.m_ofn.nFilterIndex==1){
			int	i,j, Error, NumFiles, ExtCode;
			GifRecordType RecordType;
			GifByteType *Extension;
			GifRowType *ImageBuffer;
			GifFileType *GifFileOut = NULL;
			ColorMapObject CM;
			CM.Colors=new GifColorType[256];

			write_gif(filename, pic, TResX, TResY);

			delete [] CM.Colors;
		}
		else {
			FILE *out;
			int i,j;
			out=fopen(filename,"wb");
			BG_WriteBMP(out, MedDLePalette, pic, TResX, TResY);
			fclose(out);
		}

		delete pic;
	}
*/}

void CCameraView::RenderHit(CPoint point)
{
/*	CMedDLeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->HitIndex.RemoveAll();
	// get size of windows
    CRect rc;    
	GetClientRect(&rc);
	// this is the width, height (resolution)
	int resx, resy; 
	resx=rc.right+1;
	resy=rc.bottom+1;
	// upper limit on res of rendering
	if(resx>1023) resx=1024;
	if(resy>1023) resy=1024;

	point.y=resy-point.y;
	// make it a multiple of for to make it dib blit correctly..
	// don't ask how I know..
	int i,k,l;
	BG_3pt pt1, pt2, vect1, vect2; 
	BG_3pt vn[162];             // for vector normals
	BG_ScreenCoor pt[4];
	
	int fill_mode=4;
	int draw_pts=0, draw_lines=0;
	
	BG_Matrix scaling;
	//BG_Matrix Rx,Ry,Rz;
	BG_Matrix E_TM,O_TM,TM;
	
	fill_mode=pDoc->fill_mode;
	if (pDoc->Rflags&R_VERT) draw_pts=1;
	if (pDoc->Rflags&R_WIRE) draw_lines=1;
	
	BG_Init3dWindow(resx, resy);

	Frame *mf;
	mf=pDoc->cur.frameptr;
	if (mf != NULL)
	{
	
		// Scaling matrix, scales the points to the screen
		BG_IdentityMatrix( &scaling );
		scaling.m[0][0]=focus*(double)(resy-1)/win_height;    //scale x
		scaling.m[0][1]=(resx/2);
		scaling.m[2][1]=(resy/2);
		scaling.m[2][2]=-focus*(double)(resy-1)/win_width;    // scale y


		// Now apply any movement to the view
		// the MD vector is the movement direction
		// MD.x=rightward, MD.y=forward, MD.z=upward
		pDoc->MD=BG_VectorMatrix3(&pDoc->MD,&pDoc->eyeball.dir_matrix);

		pDoc->eyeball.pos.x+=pDoc->MD.x;
		pDoc->eyeball.pos.y+=pDoc->MD.y;
		pDoc->eyeball.pos.z+=pDoc->MD.z;
		pDoc->MD.x=0;
		pDoc->MD.y=0;
		pDoc->MD.z=0;
		pDoc->eyeball.ix=(unsigned)pDoc->eyeball.pos.x;
		pDoc->eyeball.iy=(unsigned)pDoc->eyeball.pos.y;
		pDoc->eyeball.pos_matrix.m[0][3]=-pDoc->eyeball.pos.x;
		pDoc->eyeball.pos_matrix.m[1][3]=-pDoc->eyeball.pos.y;
		pDoc->eyeball.pos_matrix.m[2][3]=-pDoc->eyeball.pos.z;

		// eye transformation matrix
		E_TM=BG_MatrixMult(&pDoc->eyeball.dir_matrix,&pDoc->eyeball.pos_matrix);

	
		// object's transformation matrix
		O_TM=BG_MatrixMult(&pDoc->sit.pos_matrix,&pDoc->sit.dir_matrix);
		// overall transformation matrix
		TM=BG_MatrixMult(&E_TM,&O_TM);
		i=0;
		BG_3pt ptlist;
		// put all points in eyeballs coordinates
		for(k=0; k < pDoc->num.vertices; k++){
			ptlist.x=mf->fv[k].v[0];
			ptlist.y=mf->fv[k].v[1];
			ptlist.z=mf->fv[k].v[2];
 			eye_ptlist[k]=BG_MatrixVector4(&TM,&ptlist);
		}

		for(k=0; k <pDoc->num.triangles ; k++)
		{
			BG_3pt p3[3];

			xlist[k]=1e23;
			for(l=0; l < 3; l++)
			{
				if(eye_ptlist[pDoc->Tris[k].vindex[l]].y < xlist[k]) xlist[k]=eye_ptlist[pDoc->Tris[k].vindex[l]].y;
			}
			xindexlist[k]=k;
		}
		sort(xlist,xindexlist,0,pDoc->num.triangles-1);
		//do all sides
		int draw_poly;
		double u,v,z;
		int num_screen_pts, num_screen_sides=0;

		for(k=0; k <pDoc->num.triangles ; k++)
		{
			//double a,b;
			if (!(pDoc->Tris[xindexlist[k]].Vflags&O_VHIDDEN))
			{
				num_screen_pts=0;
	
				// if in front of eyeball...
				draw_poly=1;
				// do each point on each side
				for(l=0; l < 3; l++)
				{
					u=0;
					v=0;
					int jj=pDoc->Tris[xindexlist[k]].vindex[l];
					pt1.x=eye_ptlist[jj].x;
					pt1.y=eye_ptlist[jj].y;
					pt1.z=eye_ptlist[jj].z;
					pt1=BG_MatrixVector4(&scaling,&pt1);
					num_screen_sides++;
					// front and back plane clipping
					if((pt1.y>0))
					{
						// put points in 2d screen coords
						u=pt1.x/pt1.y;
						v=pt1.z/pt1.y;
						// put data in 3dgpl style for rendering
							
						//if(fill_mode==0) ii++;
						mdlpts.x[l*2]=(int)u;
						mdlpts.x[l*2+1]=resy-(int)v;

					}
					else draw_poly=0;
					num_screen_pts++;
				} // poly points 

					
				//pDoc->Tris[xindexlist[k]].flags
				//CPoint pt=point;
				if(draw_poly==1)
				{
					mdlpts.x[6]=mdlpts.x[0];
					mdlpts.x[7]=mdlpts.x[1];
				if(G_hit_polygon(mdlpts.x,3,point))
				{
					pDoc->HitIndex.Add(xindexlist[k]);
				}
				}
			}
		}// end all tris
	}	// end if not null frame
*/
}

