// Anim.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "Anim.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define win_width 3.20
#define win_height 2.40
#define focus 2.00


/////////////////////////////////////////////////////////////////////////////
// CAnim dialog


CAnim::CAnim(CWnd* pParent /*=NULL*/)
	: CDialog(CAnim::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnim)
	m_AnimName = _T("");
	m_SpeedText = _T("");
	//}}AFX_DATA_INIT
	speed=15;
}


void CAnim::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnim)
	DDX_Control(pDX, IDC_PLAYAREA, m_ViewArea);
	DDX_Control(pDX, IDC_SLIDER_ANIMSPEED, m_FPS);
	DDX_Control(pDX, IDC_BUTTON_PREANIM, m_PreAnim);
	DDX_Control(pDX, IDC_BUTTON_NEXTANIM, m_NextAnim);
	DDX_Control(pDX, IDC_BUTTON_APLAY, m_PlayAnim);
	DDX_Control(pDX, IDC_BUTTON_AFORWARD, m_ForwardFrame);
	DDX_Control(pDX, IDC_BUTTON_ABACK, m_BackFrame);
	DDX_Text(pDX, IDC_CURANIM, m_AnimName);
	DDX_Text(pDX, IDC_PLAYSPEED, m_SpeedText);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAnim, CDialog)
	//{{AFX_MSG_MAP(CAnim)
	ON_BN_CLICKED(IDC_BUTTON_ABACK, OnButtonAback)
	ON_BN_CLICKED(IDC_BUTTON_AFORWARD, OnButtonAforward)
	ON_BN_CLICKED(IDC_BUTTON_APLAY, OnButtonAplay)
	ON_BN_CLICKED(IDC_BUTTON_NEXTANIM, OnButtonNextanim)
	ON_BN_CLICKED(IDC_BUTTON_PREANIM, OnButtonPreanim)
	ON_WM_HSCROLL()
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnim message handlers

void CAnim::OnButtonAback() 
{
/*	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {return;}
	pDoc=theApp.m_pActiveDoc;
	
	if(pDoc->cur.frame==-2) pDoc->cur.frame=pDoc->Frames.GetSize();
	pDoc->cur.frame--;
	if(pDoc->cur.frame>=0) pDoc->cur.frameptr=pDoc->Frames[pDoc->cur.frame];
	else if(pDoc->cur.frame==-1) pDoc->cur.frameptr=pDoc->Base;
	else if(pDoc->cur.frame==-2) pDoc->cur.frameptr=pDoc->MapGen;
	pDoc->UpdateAllViews(NULL);
	*/
}

void CAnim::OnButtonAforward() 
{
/*	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {return;}
	pDoc=theApp.m_pActiveDoc;
	
	pDoc->cur.frame++;
	if(pDoc->cur.frame==pDoc->Frames.GetSize()) pDoc->cur.frame=-2;

	if(pDoc->cur.frame>=0) pDoc->cur.frameptr=pDoc->Frames[pDoc->cur.frame];
	else if(pDoc->cur.frame==-1) pDoc->cur.frameptr=pDoc->Base;
	else if(pDoc->cur.frame==-2) pDoc->cur.frameptr=pDoc->MapGen;
	pDoc->UpdateAllViews(NULL);
*/	
}

void CAnim::OnButtonAplay() 
{
/*	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {return;}
	pDoc=theApp.m_pActiveDoc;
	if(pDoc->AnimationPlaying) 
	{
		pDoc->AnimationPlaying=0;	
		KillTimer(1);
		m_PlayAnim.SetIcon(Iplay);
	}
	else 
	{
		pDoc->AnimationPlaying=1;
		float a;
		a=1000./(float)speed;
		SetTimer(1,(int)a,NULL);
		m_PlayAnim.SetIcon(Ipause);
}
*/}

void CAnim::OnButtonNextanim() 
{
//	CMedDLeDoc *pDoc;
//	if(theApp.m_pActiveDoc==NULL) {return;}
//	pDoc=theApp.m_pActiveDoc;
//	pDoc->cur.animation++;
//	if(pDoc->cur.animation>=pDoc->Animations.GetSize()) pDoc->cur.animation=0;

//	m_AnimName = pDoc->Animations[pDoc->cur.animation].name;
//	UpdateData(0);		
}

void CAnim::OnButtonPreanim() 
{
/*	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {return;}
	pDoc=theApp.m_pActiveDoc;
	if(pDoc->cur.animation==0) pDoc->cur.animation=pDoc->Animations.GetSize();
	pDoc->cur.animation--;
	m_AnimName = pDoc->Animations[pDoc->cur.animation].name;
	UpdateData(0);		
*/	
}

void CAnim::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
/*	speed=m_FPS.GetPos();
	char str[24];
	
	sprintf(str,"FPS: %d",speed);
	m_SpeedText = str;
	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc!=NULL) {
	pDoc=theApp.m_pActiveDoc;

	if(pDoc->AnimationPlaying)
	{
		KillTimer(1);
		float a;
		a=1000./(float)speed;
		SetTimer(1,(int)a,NULL);
		SetTimer(1,a,NULL);
	}
	}

	UpdateData(0);
		
*/	//CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CAnim::OnClose() 
{
	DestroyWindow();
}

void CAnim::PostNcDestroy() 
{
	theApp.AnimDlgOn=0;
	delete this;
	theApp.m_pAnimDlg=NULL;

}

void CAnim::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
/*	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {return;}
	pDoc=theApp.m_pActiveDoc;
	
	static int cnt=0;
	#include "normals.h" // defines vertex_normal[];
	BG_Polygon mdlpts;
	BG_3pt eye_ptlist[5000];

	CDC *pdc=m_ViewArea.GetDC();
	HDRAWDIB hDrawDib;
	
	CRect rc;
	POINT sz;
	m_ViewArea.GetClientRect(&rc);

	int TResX;
	for (TResX = (rc.right+1); TResX%4 != 0; TResX++);
	if ((rc.bottom+1)*TResX > ResX*ResY) {
		delete RAMScreen;
		ResX = TResX;
		ResY = rc.bottom+1;
		RAMScreen = new BYTE[ResX*ResY];
	}

	// this is the width, height (resolution)
	int resx, resy; 
	resx=rc.right+1;
	resy=rc.bottom+1;
	// upper limit on res of rendering
	if(resx>1023) resx=1024;
	if(resy>1023) resy=1024;

	// make it a multiple of for to make it dib blit correctly..
	// don't ask how I know..
	while(resx%4!=0) resx++;
	
	//////////////////////////////////////////////////
	////////////////////////////////////
	//////////// 3d (bg) stuff
	int i,k,l;
	BG_3pt pt1, pt2, vect1, vect2; 
	BG_3pt vn[162];             // for vector normals
	BG_ScreenCoor pt[4];
	
	int fill_mode=4;
	int draw_pts=0, draw_lines=0;
	
	BG_Matrix scaling;
	//BG_Matrix Rx,Ry,Rz;
	BG_Matrix E_TM,O_TM,TM;
	
	fill_mode=pDoc->fill_mode;
	if (pDoc->Rflags&R_VERT) draw_pts=1;
	if (pDoc->Rflags&R_WIRE) draw_lines=1;
	
	BG_Init3dWindow(resx, resy);
	G_buffer=RAMScreen;
#ifdef _USEZBUFFER
//	AfxMessageBox("Zbuffclear");
	memset(zbuffer,0xff,4*BG_ScreenWidth*BG_ScreenHeight);
#endif
	G_clear(pDoc->back_color);

	Frame *mf;
	//mf=pDoc->cur.frameptr;
	if(pDoc->AnimationPlaying)
	{
		if(pDoc->cur.frame>=0)
		{
			mf=pDoc->Frames[pDoc->Animations[pDoc->cur.animation].firstframe+cnt];
			cnt++;
			if(cnt>=pDoc->Animations[pDoc->cur.animation].frames) cnt=0;
		}
		else
		{
			mf=pDoc->cur.frameptr;
		}
	}
	else
	{
		mf=pDoc->cur.frameptr;
	}
	if (mf != NULL){
		// Rotation Matrices, get them lined up
		//Rx=BG_CalcRx(0);
		//Ry=BG_CalcRy(0);
		//Rz=BG_CalcRz(0);

		// Scaling matrix, scales the points to the screen
		BG_IdentityMatrix( &scaling );
		scaling.m[0][0]=focus*(double)(resy-1)/win_height;    //scale x
		scaling.m[0][1]=(resx/2);
		scaling.m[2][1]=(resy/2);
		scaling.m[2][2]=-focus*(double)(resy-1)/win_width;    // scale y


		// Now apply any movement to the view
		// the MD vector is the movement direction
		// MD.x=rightward, MD.y=forward, MD.z=upward
		pDoc->MD=BG_VectorMatrix3(&pDoc->MD,&pDoc->eyeball.dir_matrix);

		pDoc->eyeball.pos.x+=pDoc->MD.x;
		pDoc->eyeball.pos.y+=pDoc->MD.y;
		pDoc->eyeball.pos.z+=pDoc->MD.z;
		pDoc->MD.x=0;
		pDoc->MD.y=0;
		pDoc->MD.z=0;
		// check to see if you moved too far... optional
		//if(pDoc->eyeball.pos.x>=(double)map_max_x) pDoc->eyeball.pos.x=map_max_x-1;
		//if(pDoc->eyeball.pos.x<0.0) pDoc->eyeball.pos.x=0;
		//if(pDoc->eyeball.pos.y>=(double)map_max_y) pDoc->eyeball.pos.y=map_max_y-1;
		//if(pDoc->eyeball.pos.y<0.0) pDoc->eyeball.pos.y=0;
		pDoc->eyeball.ix=(unsigned)pDoc->eyeball.pos.x;
		pDoc->eyeball.iy=(unsigned)pDoc->eyeball.pos.y;
		pDoc->eyeball.pos_matrix.m[0][3]=-pDoc->eyeball.pos.x;
		pDoc->eyeball.pos_matrix.m[1][3]=-pDoc->eyeball.pos.y;
		pDoc->eyeball.pos_matrix.m[2][3]=-pDoc->eyeball.pos.z;

		// eye transformation matrix
		E_TM=BG_MatrixMult(&pDoc->eyeball.dir_matrix,&pDoc->eyeball.pos_matrix);

		// the light ray
		BG_3pt LR;     
		LR=BG_MatrixVector4(&pDoc->eyeball.dir_matrix,&pDoc->light_ray);
		BG_Normalize(&LR);


		//***************************************************************************
		//***************************************************************************
		// draw objects !!!!!!!!!!!!!!!!!!!!!!!!
		//***************************************************************************
		//***************************************************************************

		// object's transformation matrix
		O_TM=BG_MatrixMult(&pDoc->sit.pos_matrix,&pDoc->sit.dir_matrix);
		// overall transformation matrix
		TM=BG_MatrixMult(&E_TM,&O_TM);
		i=0;
		BG_3pt ptlist;
		// put all points in eyeballs coordinates
		for(k=0; k < pDoc->num.vertices; k++){
			ptlist.x=mf->fv[k].v[0];
			ptlist.y=mf->fv[k].v[1];
			ptlist.z=mf->fv[k].v[2];
 			eye_ptlist[k]=BG_MatrixVector4(&TM,&ptlist);
			//if(pDoc->Verts[k].flags & O_VSELECTED) SelPointList[k]=1;
			//else SelPointList[k]=0;
		}

		// put all vertex normals in eye's coords
		for(k=0; k < 162; k++) vn[k]=BG_MatrixVector3(&TM,&vertex_normal[k]);
		// find farthest point of each poly from eye.
		// also calc normals
		BG_3pt *side_normal=new BG_3pt [pDoc->num.triangles];

		for(k=0; k <pDoc->num.triangles ; k++){
			BG_3pt p3[3];

			xlist[k]=-1e23;
			for(l=0; l < 3; l++){
#ifndef _USEZBUFFER
				if(eye_ptlist[pDoc->Tris[k].vindex[l]].y > xlist[k]) xlist[k]=eye_ptlist[pDoc->Tris[k].vindex[l]].y;
#endif
				p3[l].x=mf->fv[pDoc->Tris[k].vindex[l]].v[0];
				p3[l].y=mf->fv[pDoc->Tris[k].vindex[l]].v[1];
				p3[l].z=mf->fv[pDoc->Tris[k].vindex[l]].v[2];
			}
			xindexlist[k]=k;
			vect1=BG_SubtractPts(&p3[1],&p3[0]);
			vect2=BG_SubtractPts(&p3[2],&p3[1]);
			side_normal[k]=BG_CrossProduct(&vect2,&vect1);
			BG_Normalize(&side_normal[k]);
		}
		// now sort polys by furthest point (or closest?)
#ifndef _USEZBUFFER
		sort(xlist,xindexlist,0,pDoc->num.triangles-1);
#endif


		//do all sides
		int draw_poly;
		double u,v;
		int num_screen_pts, num_screen_sides=0;

		double a,b;
		int ii;
		ii=fill_mode+1;
		if(fill_mode==0) ii++;
		for(k=0; k <pDoc->Tris.GetSize(); k++){
			num_screen_pts=0;
			// find normals for culling
			pt1=eye_ptlist[pDoc->Tris[xindexlist[k]].vindex[0]];
			vect1=BG_MatrixVector3(&TM,&side_normal[xindexlist[k]]);

			// dot normal with a vector which points from the eye to the side
			a = BG_DotProduct(&vect1,&pt1);

			// if in front of eyeball...
			// facing towards you
			if(( a < 0.0 )||(pDoc->fill_mode==0)){
				// see how much normal is pointing towards light for flat shading
				if((b= BG_DotProduct(&vect1,&LR)+1.) >2.) b=2.0;
				if((b < 0.)||(pDoc->fill_mode==0)) b=0.;
				draw_poly=1;

				// do each point on each side
				for(l=0; l < 3; l++){
					u=0;
					v=0;
					int jj=pDoc->Tris[xindexlist[k]].vindex[l];
					pt1.x=eye_ptlist[jj].x;
					pt1.y=eye_ptlist[jj].y;
					pt1.z=eye_ptlist[jj].z;
					pt1=BG_MatrixVector4(&scaling,&pt1);
					num_screen_sides++;
					// front and back plane clipping
					if((pt1.y>0)){
						// put points in 2d screen coords
						u=pt1.x/pt1.y;
						v=pt1.z/pt1.y;
						// put data in 3dgpl style for rendering
							
#ifdef _USEZBUFFER
						z=eye_ptlist[jj].x*eye_ptlist[jj].x+eye_ptlist[jj].y*eye_ptlist[jj].y+eye_ptlist[jj].z*eye_ptlist[jj].z;
						z=sqrt(z)/10.;
						if(fill_mode==4) ii++;
#endif

							
						mdlpts.x[l*ii]=(int)u;
						mdlpts.x[l*ii+1]=resy-(int)v;

						if(fill_mode==2){
							//see how much normal is pointed towards lighgt
							
							b= 1.-BG_DotProduct(&vn[mf->fv[pDoc->Tris[xindexlist[k]].vindex[l]].vnormal],&LR);
							b=b*.5;
							if(b < 0) b=0;
							// scale intesity from 0 to 15 (different from colormap)
							mdlpts.x[l*3+2]=(int)(15.*b);//15-(int)(.5*b*15.0);
							if((pDoc->Rflags&R_FB) &&(pDoc->Gflags&S_IS_MDL)){
								if(pDoc->Tris[xindexlist[k]].flags==0) mdlpts.x[l*3+2]+=32;
								else mdlpts.x[l*3+2]+=64;
							}
						}
						else if(fill_mode==3){
							// get coords of texture
							if((pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].Mflags & S_ONSEEM)
							 &&
							(!(pDoc->Tris[xindexlist[k]].flags & S_FRONT))){
								mdlpts.x[l*4+2]=pDoc->SkinW/2+pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*4+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							}
							else{
								mdlpts.x[l*4+2]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*4+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							}
						}
						else if(fill_mode==4){
							// get coords of texture
#ifdef _USEZBUFFER
							if((pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].Mflags & S_ONSEEM)
							 &&
							(!(pDoc->Tris[xindexlist[k]].flags & S_FRONT))){
								mdlpts.x[l*6+2]=pDoc->SkinW/2+pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*6+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							} else{
								mdlpts.x[l*6+2]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*6+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							}
							
							//see how much normal is pointed towards lighgt
							b= 1.-BG_DotProduct(&vn[mf->fv[pDoc->Tris[xindexlist[k]].vindex[l]].vnormal],&LR);
							b=b*.5;
							if(b < 0) b=0;
							// scale intesity
							b=b*pDoc->light_intensity;
							if(b<pDoc->ambient_intensity) b=pDoc->ambient_intensity;
							mdlpts.x[l*6+4]=(int)(63-b);//15-(int)(.5*b*15.0);
							if(mdlpts.x[l*6+4]>63)mdlpts.x[l*5+4]=63;
							else if(mdlpts.x[l*6+4]<0)mdlpts.x[l*5+4]=0;
							mdlpts.x[l*6+5]=(DWORD)z;
#else

							if((pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].Mflags & S_ONSEEM)
							 &&
							(!(pDoc->Tris[xindexlist[k]].flags & S_FRONT))){
								mdlpts.x[l*5+2]=pDoc->SkinW/2+pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*5+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							} else{
								mdlpts.x[l*5+2]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].x;
								mdlpts.x[l*5+3]=pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[l]].y;
							}
							
							//see how much normal is pointed towards lighgt
							b= 1.-BG_DotProduct(&vn[mf->fv[pDoc->Tris[xindexlist[k]].vindex[l]].vnormal],&LR);
							b=b*.5;
							if(b < 0) b=0;
							// scale intesity
							b=b*pDoc->light_intensity;
							if(b<pDoc->ambient_intensity) b=pDoc->ambient_intensity;
							mdlpts.x[l*5+4]=(int)(63-b);//15-(int)(.5*b*15.0);
							if(mdlpts.x[l*5+4]>63)mdlpts.x[l*5+4]=63;
							else if(mdlpts.x[l*5+4]<0)mdlpts.x[l*5+4]=0;

#endif

						}
					} else{
						draw_poly=0;
						num_screen_sides--;
						break;
					}
					num_screen_pts++;
				}

				///////// render the poly
				// now call the rendering functs
				if(draw_poly){
					mdlpts.x[3*ii]=mdlpts.x[0];
					mdlpts.x[3*ii+1]=mdlpts.x[1];
					
					if (!(pDoc->Tris[xindexlist[k]].Vflags&O_VHIDDEN)){
						if(fill_mode==1){
							int c=(int)(15.0*(1.-.5*b));
 							if((pDoc->Rflags&R_FB) &&(pDoc->Gflags&S_IS_MDL)){
								if(pDoc->Tris[xindexlist[k]].flags==0) c+=32;
								else c+=64;
							}
							G_ambient_polygon(mdlpts.x,3,c);
						}else if(fill_mode==2){
							// must set wrap around point
							 mdlpts.x[3*ii+2]=mdlpts.x[2];
							 G_shaded_polygon(mdlpts.x,3);
						} else if(fill_mode==3){
							// must set wrap around point
							mdlpts.x[3*ii+2]=mdlpts.x[2];
							mdlpts.x[3*ii+3]=mdlpts.x[3];
							BYTE *bitmap;
							Skin *ms=pDoc->Skins.GetAt(pDoc->cur.skin);
							bitmap=ms->bitmap;
										  
							if((pDoc->Rflags&R_FB) &&(pDoc->Gflags&S_IS_MDL))
								G_textured_polygon(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
							else
								G_textured_polygon(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
						} else if(fill_mode==4){
							// must set wrap around point
							BYTE *bitmap;
							Skin *ms=pDoc->Skins.GetAt(pDoc->cur.skin);
							bitmap=ms->bitmap;
							mdlpts.x[3*ii+2]=mdlpts.x[2];
							mdlpts.x[3*ii+3]=mdlpts.x[3];
							mdlpts.x[3*ii+4]=mdlpts.x[4];
#ifdef _USEZBUFFER		
							mdlpts.x[3*ii+5]=mdlpts.x[5];
							if((pDoc->Rflags&R_FB) &&(pDoc->Gflags&S_IS_MDL))
								Gz_gtex_poly(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
							else 
								Gz_gtex_poly(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
#else 
							if((pDoc->Rflags&R_FB) &&(pDoc->Gflags&S_IS_MDL))
								G_gtex_poly(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
							else 
								G_gtex_poly(mdlpts.x,3,bitmap,pDoc->SkinW, pDoc->tcolor, pDoc->bcolor);
#endif

						}
						if (pDoc->Tris[xindexlist[k]].Vflags&O_VSELECTED){
							int mp1[2];
							int center[2];
							int vrts[3][2];
							int *tvrt[3];
							int color=251;
							tvrt[0]=mdlpts.x;
							tvrt[1]=mdlpts.x+ii;
							tvrt[2]=mdlpts.x+2*ii;
							vrts[0][0]=((tvrt[0][0]-tvrt[1][0])/2)+tvrt[1][0];
							vrts[0][1]=((tvrt[0][1]-tvrt[1][1])/2)+tvrt[1][1];
							vrts[1][0]=((tvrt[1][0]-tvrt[2][0])/2)+tvrt[2][0];
							vrts[1][1]=((tvrt[1][1]-tvrt[2][1])/2)+tvrt[2][1];
							vrts[2][0]=((tvrt[2][0]-tvrt[0][0])/2)+tvrt[0][0];
							vrts[2][1]=((tvrt[2][1]-tvrt[0][1])/2)+tvrt[0][1];
							mp1[0]=((vrts[0][0]-vrts[1][0])/2)+vrts[1][0];
							center[0]=((vrts[2][0]-mp1[0])*.4f)+mp1[0];
							mp1[1]=((vrts[0][1]-vrts[1][1])/2)+vrts[1][1];
							center[1]=((vrts[2][1]-mp1[1])*.4f)+mp1[1];
							vrts[0][0]=((center[0]-tvrt[0][0])/1.25)+tvrt[0][0];
							vrts[0][1]=((center[1]-tvrt[0][1])/1.25)+tvrt[0][1];
							vrts[1][0]=((center[0]-tvrt[1][0])/1.25)+tvrt[1][0];
							vrts[1][1]=((center[1]-tvrt[1][1])/1.25)+tvrt[1][1];
							vrts[2][0]=((center[0]-tvrt[2][0])/1.25)+tvrt[2][0];
							vrts[2][1]=((center[1]-tvrt[2][1])/1.25)+tvrt[2][1];
							if (a>0.0) color=208;
							G_line((int *)&center, &vrts[0][0], color);
							G_line((int *)&center, &vrts[1][0], color);
							G_line((int *)&center, &vrts[2][0], color);
						}
						if(draw_lines){
							G_line(mdlpts.x,mdlpts.x+ii,pDoc->Tris[xindexlist[k]].color[0]);
							G_line(mdlpts.x+ii,mdlpts.x+2*ii,pDoc->Tris[xindexlist[k]].color[1]);
							G_line(mdlpts.x+2*ii,mdlpts.x,pDoc->Tris[xindexlist[k]].color[2]);
						}
						if(draw_pts){

							if(!(pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[0]].flags & O_VHIDDEN))
							{
							if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[0]].flags & O_DRAW_BLUE) G_bigdot(mdlpts.x,208);
							else if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[0]].flags & O_VSELECTED) G_bigdot(mdlpts.x,251);
							else G_smalldot(mdlpts.x,0);
							
							if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[1]].flags & O_DRAW_BLUE) G_bigdot(mdlpts.x+ii,208);
							else if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[1]].flags & O_VSELECTED) G_bigdot(mdlpts.x+ii,251);
							else G_smalldot(mdlpts.x+ii,0);
							
							if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[2]].flags & O_DRAW_BLUE) G_bigdot(mdlpts.x+2*ii,208);
							else if (pDoc->Verts[pDoc->Tris[xindexlist[k]].vindex[2]].flags & O_VSELECTED) G_bigdot(mdlpts.x+2*ii,251);
							else G_smalldot(mdlpts.x+2*ii,0);
							
							l=254;
							G_dot(mdlpts.x,l);
							G_dot(mdlpts.x+ii,l);
							G_dot(mdlpts.x+2*ii,l);
							}
						}
					}
				}
			}
		}	
		delete [] side_normal;
	}

	hDrawDib=DrawDibOpen();
	BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo;
	bm->bmiHeader.biWidth=resx;
	bm->bmiHeader.biHeight=resy;  // negative makes it a top down bmp
	bm->bmiHeader.biSizeImage=resx*resy;
	DrawDibRealize(hDrawDib,pdc->GetSafeHdc(),TRUE);
	DrawDibDraw(hDrawDib, pdc->GetSafeHdc(),
		1,1,  //x,y
		rc.right-2, rc.bottom-2, //w,h
		(BITMAPINFOHEADER *)MedDLeDIBInfo,//mdi,
		G_buffer,
		0,0, //source x,y
		resx, resy,//source w,h
		DDF_BACKGROUNDPAL
	);




	DrawDibClose(hDrawDib);

	m_ViewArea.ReleaseDC(pdc);
	//cnt++;
	//char str[24];
	//sprintf(str,"%d",cnt);
	//pdc->TextOut(0,0,str);
*/			
}

void CAnim::OnTimer(UINT nIDEvent) 
{
	CRect rc;	
	m_ViewArea.GetClientRect(&rc);
	InvalidateRect(&rc,0);
		
	//CDialog::OnTimer(nIDEvent);
}

BOOL CAnim::OnInitDialog() 
{
	CDialog::OnInitDialog();
/*	Iplay=AfxGetApp()->LoadIcon(IDI_PLAY);
	Ipause=AfxGetApp()->LoadIcon(IDI_PAUSE);
		
	m_PlayAnim.SetIcon(Iplay);

	CMedDLeDoc *pDoc;
	if(theApp.m_pActiveDoc==NULL) {TRUE;}
	pDoc=theApp.m_pActiveDoc;
	if(pDoc->Animations.GetSize()<1)
		m_AnimName = _T("Animation");
	else
		m_AnimName = pDoc->Animations[pDoc->cur.animation].name;

	char str[24];
	m_FPS.SetRange(1,45);
	m_FPS.SetPos(speed);
	sprintf(str,"FPS: %d",speed);
	m_SpeedText = str;
*/	
	UpdateData(0);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
