// PaletteDlg.cpp : implementation file
// 

#include "stdafx.h"
#include "MedDLe.h"
#include "PaletteDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPaletteDlg dialog


CPaletteDlg::CPaletteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPaletteDlg::IDD, pParent)
{
		SelectedColor=0;

	//{{AFX_DATA_INIT(CPaletteDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	//if(!pDoc->IsKindOf(RUNTIME_CLASS(CMedDLeDoc))) OnCancel();

}


void CPaletteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPaletteDlg)
	DDX_Control(pDX, IDC_PAL_SELECT, m_PaletteArea);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPaletteDlg, CDialog)
	//{{AFX_MSG_MAP(CPaletteDlg)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPaletteDlg message handlers

void CPaletteDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CDC *pdc=m_PaletteArea.GetDC();
//	HDRAWDIB hDrawDib;
	
	CRect rc;
	m_PaletteArea.GetClientRect(&rc);

	BYTE *palpic=new BYTE [256];

	for(int i=0; i<16; i++) 
	for(int j=0; j<16; j++) palpic[j+i*16]=j+(15-i)*16;

//	hDrawDib=DrawDibOpen();

	// blit dib!
//	BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo;
//	bm->bmiHeader.biWidth=16;
//	bm->bmiHeader.biHeight=16;  // negative makes it a top down bmp
//	bm->bmiHeader.biSizeImage=16*16;

//	DrawDibRealize(hDrawDib,pdc->GetSafeHdc(),TRUE);
//	DrawDibDraw(hDrawDib, pdc->GetSafeHdc(),
//			2,2,  //x,y
//			rc.right-4, rc.bottom-4, //w,h
//			(BITMAPINFOHEADER *)MedDLeDIBInfo,//mdi,
//			palpic,
//			0,0, //source x,y
//			16, 16,//source w,h
//			DDF_BACKGROUNDPAL
//		);

//	DrawDibClose(hDrawDib);

//	delete [] palpic;

	//SelectedColor=23;

	CRect c;
	int xoff,yoff;
	xoff=SelectedColor&0xf;
	yoff=SelectedColor&0xf0;
	yoff=yoff/16;
	CBrush WSel( 0xffffff );
	c.left=xoff*(rc.right-4)/16+2; c.right=(xoff+1)*(rc.right-3.3)/16+2;
	c.top=yoff*(rc.bottom-4)/16+2; c.bottom=(yoff+1)*(rc.bottom-3.3)/16+2;

	pdc->FrameRect( &c, &WSel );

	/*c.left=xoff*xstep;
	c.right=xoff*xstep+xstep-1; 
	c.top=yoff*ystep; 
	c.bottom=yoff*ystep+ystep-1;
	*/
	// TODO: Add your message handler code here
	
	// Do not call CDialog::OnPaint() for painting messages
}

void CPaletteDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rc;
	m_PaletteArea.GetClientRect(&rc);
	
	CPoint ptPal( point );
	MapWindowPoints( &m_PaletteArea, &ptPal, 1 );

	if(ptPal.x>1)	ptPal.x-=2; 
	if(ptPal.y>1) ptPal.y-=2;
	ptPal.x=16*(ptPal.x)/(rc.right-4);
	ptPal.y=16*(ptPal.y)/(rc.bottom-4);
	SelectedColor=ptPal.x+ptPal.y*16;
	*color=SelectedColor;
	pDoc->UpdateAllViews(NULL);
	//CDialog::OnLButtonDown(nFlags, point);
	InvalidateRect(NULL,0);
}

void CPaletteDlg::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rc;
	m_PaletteArea.GetClientRect(&rc);
	
	CPoint ptPal( point );
	MapWindowPoints( &m_PaletteArea, &ptPal, 1 );

	if(ptPal.x>1)	ptPal.x-=2; 
	if(ptPal.y>1) ptPal.y-=2;
	ptPal.x=16*(ptPal.x)/(rc.right-4);
	ptPal.y=16*(ptPal.y)/(rc.bottom-4);
	
	SelectedColor=ptPal.x+ptPal.y*16;
	*color=SelectedColor;
	pDoc->UpdateAllViews(NULL);
	OnOK();	
//	CDialog::OnLButtonDblClk(nFlags, point);
}
