// PalDlg.cpp : implementation file
// 

#include "stdafx.h"
#include "MedDLe.h"
#include "PalDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPalDlg dialog


CPalDlg::CPalDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPalDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPalDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	SelectedColor=23;
	curPt=26;
}


void CPalDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPalDlg)
	DDX_Control(pDX, IDC_PALAREA, m_PalArea);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPalDlg, CDialog)
	//{{AFX_MSG_MAP(CPalDlg)
	ON_WM_PAINT()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPalDlg message handlers

//include "MedDLeGFX.h"
void CPalDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CDC *pdc=m_PalArea.GetDC();
	HDRAWDIB hDrawDib;
	
	CRect rc;
	m_PalArea.GetClientRect(&rc);

	BYTE *palpic=new BYTE [256];

	for(int i=0; i<16; i++) 
	for(int j=0; j<16; j++) palpic[j+i*16]=j+(15-i)*16;

	hDrawDib=DrawDibOpen();

	// blit dib!
	BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo;
	bm->bmiHeader.biWidth=16;
	bm->bmiHeader.biHeight=16;  // negative makes it a top down bmp
	bm->bmiHeader.biSizeImage=16*16;

	DrawDibRealize(hDrawDib,pdc->GetSafeHdc(),TRUE);
	DrawDibDraw(hDrawDib, pdc->GetSafeHdc(),
			2,2,  //x,y
			rc.right-3, rc.bottom-3, //w,h
			(BITMAPINFOHEADER *)MedDLeDIBInfo,//mdi,
			palpic,
			0,0, //source x,y
			16, 16,//source w,h
			DDF_BACKGROUNDPAL
		);

	DrawDibClose(hDrawDib);

	delete [] palpic;

	CRect c;
	int xstep=rc.right/16;
	int ystep=rc.bottom/16;
	int xoff,yoff;
	xoff=SelectedColor&0xf;
	yoff=SelectedColor&0xf0;
	yoff=yoff/16;
	c.left=0; c.right=
	pdc->FrameRect( &c, &Sel );

	c.left=xoff*xstep;
	c.right=xoff*xstep+xstep-1; 
	c.top=yoff*ystep; 
	c.bottom=yoff*ystep+ystep-1;
	CBrush WSel( 0xffffff );
	CBrush BSel( 0x0 );
  
}

void CPalDlg::OnMButtonDown(UINT nFlags, CPoint point) 
{	
	CDialog::OnMButtonDown(nFlags, point);
	CRect rc;
	m_PalArea.GetClientRect(&rc);
	
	CPoint ptPal( point );
	MapWindowPoints( &m_PalArea, &ptPal, 1 );


	//curPt=point;
	UpdateData();
}

void CPalDlg::OnMButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnMButtonDblClk(nFlags, point);
	curPt=point;
	UpdateData();
}
