// MedDLeTypes

#include "MedDLeTypes.h"
#include <math.h>

CMedDLePoint3D::CMedDLePoint3D()
{
	x[0]=x[1]=x[2]=0.0f;
	wx[0]=wx[1]=wx[2]=0.0f;
}

CMedDLePoint3D::CMedDLePoint3D(float a, float b, float c)
{
	x[0]=a;x[1]=b;x[2]=c;
	wx[0]=a;wx[1]=b;wx[2]=0;
}

CMedDLePoint3D::CMedDLePoint3D(const CMedDLePoint3D &pt)
{
	x[0]=pt.x[0];
	x[1]=pt.x[1];
	x[2]=pt.x[2];

}
CMedDLePoint3D& CMedDLePoint3D::operator= (const CMedDLePoint3D &pt)
{
	x[0]=pt.x[0];
	x[1]=pt.x[1];
	x[2]=pt.x[2];
	return *this;
}


//----------------------------------------------------------
// C M e d D L e M a t r i x
CMedDLeMatrix::CMedDLeMatrix()
{
	int i,j;
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)	
			m[i][j]=0.f;
}
CMedDLeMatrix::CMedDLeMatrix(const CMedDLeMatrix &mm)
{
	int i,j;
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)	
			m[i][j]=mm.m[i][j];
}

CMedDLeMatrix::CMedDLeMatrix(const float f)
{
	int i,j;
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)
			m[i][j]=0;

	m[0][0]=f;
	m[1][1]=f;
	m[2][2]=f;
	m[3][3]=f;

}

/*CMedDLeMatrix& CMedDLeMatrix::operator =(const CMedDLeMatrix &mm)
{
	int i,j;
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)
			m[i][j]=mm.m[i][j];

	return *this;
}
*/
CMedDLeMatrix& CMedDLeMatrix::operator =(const float f)
{
	int i,j;
	for(i=0; i<4; i++)
		for(j=0; j<4; j++)
			m[i][j]=0;

	m[0][0]=f;
	m[1][1]=f;
	m[2][2]=f;
	m[3][3]=f;
	return *this;

}
/*
CMedDLeVector CMedDLeMatrix::operator * (const CMedDLeVector &mv)
{
	CMedDLeVector a;
    a.x[0]=m[0].x[0]*mv.x[0]+m[0].x[1]*mv.x[1]+m[0].x[2]*mv.x[2]+m[0].x[3];
    a.x[1]=m[1].x[0]*mv.x[0]+m[1].x[1]*mv.x[1]+m[1].x[2]*mv.x[2]+m[1].x[3];
    a.x[2]=m[2].x[0]*mv.x[0]+m[2].x[1]*mv.x[1]+m[2].x[2]*mv.x[2]+m[2].x[3];
    return a;

}
*/

CMedDLePosition::CMedDLePosition()
{
	pTarget=NULL;		// position
	Target=CMedDLePoint3D(0,0,0);
	Orientation=1;	// direction matrix

}

CMedDLePosition::CMedDLePosition(const CMedDLePosition &mp)
{
	pTarget=mp.pTarget;		// position
	Target=mp.Target;
	Orientation=mp.Orientation;	

}

CMedDLePosition& CMedDLePosition::operator =(const CMedDLePosition &mp)
{
	pTarget=mp.pTarget;		// position
	Target=mp.Target;
	Orientation=mp.Orientation;	
	return *this;
}

void CMedDLePosition::SetTargert(CMedDLePoint3D &mp)
{
	pTarget=NULL;
	Target=mp;
}
void CMedDLePosition::SetTargert(CMedDLePosition *mp)
{
	pTarget=mp;
}

//------------------------
// CMedDLeVertex

CMedDLeVertex::CMedDLeVertex() : CMedDLePoint3D()
{
	n.x[0]=n.x[1]=n.x[2]=0.0f;
}

CMedDLeVertex::~CMedDLeVertex()
{
}

CMedDLeVertex::CMedDLeVertex(float x1, float x2, float x3) :CMedDLePoint3D(x1,x2,x3) 
{
	n.x[0]=n.x[1]=n.x[2]=0.0f;
}

CMedDLeVertex::CMedDLeVertex(const CMedDLeVertex& mv):CMedDLePoint3D(mv) 
{
	n.x[0]=mv.n.x[0];
	n.x[1]=mv.n.x[1];
	n.x[2]=mv.n.x[2];
}

CMedDLeVertex& CMedDLeVertex::operator=(const CMedDLeVertex& mv)
{
	x[0]=mv.x[0];
	x[1]=mv.x[1];
	x[2]=mv.x[2];

	n.x[0]=mv.n.x[0];
	n.x[1]=mv.n.x[1];
	n.x[2]=mv.n.x[2];

	return *this;
}


//------------------------
// CMedDLeBaseVertex

CMedDLeBaseVertex::CMedDLeBaseVertex()
{
	flags=V_VISIBLE;
	group=0;
	bone=0;
	color=0;

}

CMedDLeBaseVertex::~CMedDLeBaseVertex()
{
}


CMedDLeBaseVertex::CMedDLeBaseVertex(const CMedDLeBaseVertex& mv)
{

	flags=mv.flags;
	group=mv.group;
	bone=mv.bone;
	color=mv.color;

}

CMedDLeBaseVertex& CMedDLeBaseVertex::operator=(const CMedDLeBaseVertex& mv)
{

	flags=mv.flags;
	group=mv.group;
	bone=mv.bone;
	color=mv.color;

	return *this;
}

//----------------------------
// CMedDLeFace
CMedDLeFace::CMedDLeFace()
{
	group=0;
	flags=0;
	bone=0;
	color=0;
	for(int i=0; i<3; i++)
	{
		vindex[i]=0;
		linecolor[i]=0;
		tx[i][0]=0;
		tx[i][1]=0;
	}
	texture=0;
}

CMedDLeFace::CMedDLeFace(UINT n1, UINT n2, UINT n3)
{
	vindex[0]=n1;
	vindex[1]=n2;
	vindex[2]=n3;
	group=0;
	flags=0;
	bone=0;
	color=0;
	for(int i=0; i<3; i++)
	{
		linecolor[i]=0;
		tx[i][0]=0;
		tx[i][1]=0;
	}
	texture=0;
}

CMedDLeFace::CMedDLeFace(const CMedDLeFace& mf)
{
	flags=mf.flags;
	bone=mf.bone;
	color=mf.color;

	group=mf.group;
	vindex[0]=mf.vindex[0];
	vindex[1]=mf.vindex[1];
	vindex[2]=mf.vindex[2];
	flags=mf.flags;
	linecolor[0]=mf.linecolor[0];
	linecolor[1]=mf.linecolor[1];
	linecolor[2]=mf.linecolor[2];
	tx[0][0]=mf.tx[0][0]; tx[0][1]=mf.tx[0][1];
	tx[1][0]=mf.tx[1][0]; tx[1][1]=mf.tx[1][1];
	tx[2][0]=mf.tx[2][0]; tx[2][1]=mf.tx[2][1];
	texture=mf.texture;
}

CMedDLeFace& CMedDLeFace::operator=(const CMedDLeFace& mf)
{
	flags=mf.flags;
	bone=mf.bone;
	color=mf.color;
	group=mf.group;
	vindex[0]=mf.vindex[0];
	vindex[1]=mf.vindex[1];
	vindex[2]=mf.vindex[2];
	flags=mf.flags;
	linecolor[0]=mf.linecolor[0];
	linecolor[1]=mf.linecolor[1];
	linecolor[2]=mf.linecolor[2];
	tx[0][0]=mf.tx[0][0]; tx[0][1]=mf.tx[0][1];
	tx[1][0]=mf.tx[1][0]; tx[1][1]=mf.tx[1][1];
	tx[2][0]=mf.tx[2][0]; tx[2][1]=mf.tx[2][1];
	texture=mf.texture;
	return *this;
}

//----------------------------
// CMedDLeLine
CMedDLeLine::CMedDLeLine()
{
	vindex[0]=0;
	vindex[1]=0;
	flags=0;
	color=0;
}

CMedDLeLine::CMedDLeLine(UINT n1, UINT n2)
{
	vindex[0]=n1;
	vindex[1]=n2;
	flags=0;
	color=0;
}

CMedDLeLine::CMedDLeLine(const CMedDLeLine& ml)
{
	vindex[0]=ml.vindex[0];
	vindex[1]=ml.vindex[1];
	flags=ml.flags;
	color=ml.color;

}

CMedDLeLine& CMedDLeLine::operator=(const CMedDLeLine& ml)
{

	vindex[0]=ml.vindex[0];
	vindex[1]=ml.vindex[1];
	flags=ml.flags;
	color=ml.color;
	return *this;
}

/*
typedef struct tagBITMAPINFOHEADER{ // bmih 
   DWORD  biSize; 
   LONG   biWidth; 
   LONG   biHeight; 
   WORD   biPlanes; 
   WORD   biBitCount 
   DWORD  biCompression; 
   DWORD  biSizeImage; 
   LONG   biXPelsPerMeter; 
   LONG   biYPelsPerMeter; 
   DWORD  biClrUsed; 
   DWORD  biClrImportant; 
} BITMAPINFOHEADER; 
 

unsigned int Image::CreateHeader(LPBITMAPINFOHEADER p_bminfo,
								 int w, int h, 
								 COL_SPACE cs)
{
	int i=0;

	unsigned int size = sizeof(BITMAPINFOHEADER);

//Get pallette info
   LPBITMAPINFO p_bi = (LPBITMAPINFO) p_bminfo;

//Setup header
   p_bminfo->biSize = 40;
   p_bminfo->biWidth = w;
   p_bminfo->biHeight = h;
   p_bminfo->biPlanes = 1;
   p_bminfo->biBitCount = 8;
   p_bminfo->biCompression = BI_RGB;
   p_bminfo->biSizeImage = w*abs(h);
   p_bminfo->biXPelsPerMeter = 0;
   p_bminfo->biYPelsPerMeter = 0;
   p_bminfo->biClrUsed = 256;
   p_bminfo->biClrImportant = 0;

   switch (cs)
   {
   case m_CSGRAYSCALE:
		p_bminfo->biPlanes = 1;		// 1 bit plane
		p_bminfo->biBitCount = 8;	// 8 bit/pixel
		p_bminfo->biClrUsed = 256;	// 256 colors (gray values)
		p_bminfo->biClrImportant = 0;// all colors are important
	   // fill the lookup table
		for (i=0;i<256;i++) {
			p_bi->bmiColors[i].rgbRed=i;
			p_bi->bmiColors[i].rgbGreen=i;
			p_bi->bmiColors[i].rgbBlue=i;
			p_bi->bmiColors[i].rgbReserved=0;
		   }

		size += 256*sizeof(RGBQUAD);// add the size of the lut
	   break;

   case m_CSRGB555:
	   p_bminfo->biPlanes = 1;		// 1 bit plane
	   p_bminfo->biBitCount = 16;	// 16 bit/pixel
	   p_bminfo->biClrUsed = 0;		// 2^15 colors
	   p_bminfo->biClrImportant = 0;// all colors are important
	   p_bminfo->biSizeImage *= 2;	// 2 byte/pixel -> image size doubles
	   break;

   case m_CSRGB888:
	   p_bminfo->biPlanes = 1;		// 1 bit plane
	   p_bminfo->biBitCount = 24;	// 24 bit/pixel
	   p_bminfo->biClrUsed = 0;		// 2^24 colors
	   p_bminfo->biClrImportant = 0;// all colors are important
	   p_bminfo->biSizeImage *= 3;	// 3 byte/pixel -> image size triples
	   break;
}



*/

/*
  note that bmpheader->biWidth and bmpheader->biHeight are the size of
  the bitmap. Not the actual image, size[] holds the image size.
*/
CMedDLeTexture::CMedDLeTexture()
{
	name.Empty();
	size[0]=0;
	size[1]=0;
	header = NULL;
	bmpheader = NULL;
	colors=NULL;
	bitmap=NULL;
	count=0;
}
CMedDLeTexture::~CMedDLeTexture()
{
	name.Empty();
	size[0]=0;
	size[1]=0;
	if(count<1)
	{
		if(header)	delete [] header;
		if(bitmap) delete [] bitmap;
	}
}
CMedDLeTexture::CMedDLeTexture(const CMedDLeTexture& mt)
{	
	name = mt.name;
	size[0]=mt.size[0];
	size[1]=mt.size[1];

	long size = sizeof(BITMAPINFOHEADER);
	if((mt.bmpheader->biBitCount==8) && (mt.colors))
	{
		size+=256*sizeof(RGBQUAD);
	}

	header = new BYTE[size];
	memcpy(header,mt.header,size);

	bmpheader = (BITMAPINFOHEADER*)header;
	memcpy(bmpheader,mt.bmpheader,sizeof(BITMAPINFOHEADER));

	if(mt.colors)
	{
		colors = (RGBQUAD*)(header + sizeof(BITMAPINFOHEADER));
	}
	else 
	{
		colors=NULL;
	}

	long bmpsize;
	bmpsize=bmpheader->biWidth*bmpheader->biHeight*(bmpheader->biBitCount/8);
	if(bmpsize==0)
		bitmap=NULL;
	else
	{
		bitmap = new BYTE[bmpsize];
		memcpy(bitmap,mt.bitmap,sizeof(bmpsize));
	}

	count=0;

}

CMedDLeTexture& CMedDLeTexture::operator= (const CMedDLeTexture &mt)
{
	name = mt.name;
	size[0]=mt.size[0];
	size[1]=mt.size[1];
	
	if(header) delete [] header;
	
	long size = sizeof(BITMAPINFOHEADER);
	if((mt.bmpheader->biBitCount==8) && (mt.colors))
	{
		size+=256*sizeof(RGBQUAD);
	}

	header = new BYTE[size];
	memcpy(header,mt.header,size);

	bmpheader = (BITMAPINFOHEADER*)header;
	memcpy(bmpheader,mt.bmpheader,sizeof(BITMAPINFOHEADER));

	if(mt.colors)
	{
		colors = (RGBQUAD*)(header + sizeof(BITMAPINFOHEADER));
	}
	else 
	{
		colors=NULL;
	}

	long bmpsize;
	bmpsize=bmpheader->biWidth*bmpheader->biHeight*(bmpheader->biBitCount/8);
	if(bmpsize==0)
		bitmap=NULL;
	else
	{
		bitmap = new BYTE[bmpsize];
		memcpy(bitmap,mt.bitmap,sizeof(bmpsize));
	}

	count=0;
	return *this;

}

BOOL CMedDLeTexture::Attach()
{
	return FALSE;
}

BOOL CMedDLeTexture::Detach()
{
	return FALSE;
}

#include "../FileIO/IOPCX.h"
BOOL CMedDLeTexture::Read(LPCSTR Filename)
{
	FILE *in = fopen(Filename,"rb");
	BYTE magic[4];
	if(in==NULL) return FALSE;
	fread(magic,4,1,in);
	fclose(in);
	CString str,ext;
	str=Filename;
	int i=str.ReverseFind('.');
	if(i>0) ext = str.Right(str.GetLength()-i-1);
	else ext = "";

	if(ext.CompareNoCase("pcx")==0) return IOPCXRead(Filename,*this);

	return FALSE;
}
BOOL CMedDLeTexture::Write(LPCSTR Filename, int quality)
{
	return FALSE;
}


//--------------------------------------
// meddle group

CMedDLeGroup::CMedDLeGroup()
{
	name="unnamed";
	color=0;
	flags=0;
	bone=-1;
}
CMedDLeGroup::CMedDLeGroup(const CMedDLeGroup& mg)
{
	name=mg.name;
	color=mg.color;
	flags=mg.flags;
	bone=mg.bone;

}
CMedDLeGroup& CMedDLeGroup::operator= (const CMedDLeGroup &mg)
{
	name=mg.name;
	color=mg.color;
	flags=mg.flags;
	bone=mg.bone;

	return *this;
}


//--------------------------------
// CMedDLeMeshAnimation

CMedDLeMeshAnimation::CMedDLeMeshAnimation()
{
	name.Empty();
	framelist.RemoveAll();
	durationlist.RemoveAll();

}
CMedDLeMeshAnimation::~CMedDLeMeshAnimation()
{
	name.Empty();
	framelist.RemoveAll();
	durationlist.RemoveAll();
}

CMedDLeMeshAnimation::CMedDLeMeshAnimation(const CMedDLeMeshAnimation& ma)
{
	name=ma.name;
	int i,j,n;
	n=ma.framelist.GetSize();
	framelist.RemoveAll();
	durationlist.RemoveAll();
	for(i=0; i<n; i++)
	{
		j=ma.framelist[i];
		framelist.Add(j );
		j=ma.durationlist[i];
		durationlist.Add( j);
	}
}

//------------------------------
// CMedDLeBone 

CMedDLeBone::CMedDLeBone()
{
	name="unnamed";
	parent=-1;
	kid.RemoveAll();
	twist=0;
	length=0;
	flags=0;
}
CMedDLeBone::~CMedDLeBone()
{
	name.Empty();
	kid.RemoveAll();
}
CMedDLeBone::CMedDLeBone(const CMedDLeBone& mb)
{
	head=mb.head;
	tail=mb.tail;
	orientation=mb.orientation;

	name=mb.name;
	parent=mb.parent;
	kid.RemoveAll();
	int i,j,n;
	n=mb.kid.GetSize();
	for(i=0; i<n; i++)
	{
		j=mb.kid[i];
		kid.Add(j);
	}

	twist=mb.twist;
	length=mb.length;
	flags=mb.flags;

}
CMedDLeBone& CMedDLeBone::operator= (const CMedDLeBone &mb)
{
	head=mb.head;
	tail=mb.tail;
	orientation=mb.orientation;

	name=mb.name;
	parent=mb.parent;
	kid.RemoveAll();
	int i,j,n;
	n=mb.kid.GetSize();
	for(i=0; i<n; i++)
	{
		j=mb.kid[i];
		kid.Add(j);
	}

	twist=mb.twist;
	length=mb.length;
	flags=mb.flags;
	return *this;
}

//----------------------------
// CMedDLeFrame
CMedDLeFrame::CMedDLeFrame()
{

	name="unnamed";
	min.x[0]=min.x[1]=min.x[2]=0;
	max.x[0]=max.x[1]=max.x[2]=0;

	v.SetSize(V_GROW_N,V_GROW_N);

	v.RemoveAll();

}
CMedDLeFrame::CMedDLeFrame(const TCHAR *n)
{

	name=n;
	min.x[0]=min.x[1]=min.x[2]=0;
	max.x[0]=max.x[1]=max.x[2]=0;

	v.SetSize(V_GROW_N,V_GROW_N);

	v.RemoveAll();

}

CMedDLeFrame::~CMedDLeFrame()
{
	name.Empty();

	v.RemoveAll();

}

CMedDLeFrame::CMedDLeFrame(const CMedDLeFrame& mf)
{
	name=mf.name;
	min.x[0]=min.x[1]=min.x[2]=0;
	max.x[0]=max.x[1]=max.x[2]=0;

	v.SetSize(mf.v.GetSize(),V_GROW_N);
	v.RemoveAll();

	int i;

	for(i=0; i<mf.v.GetSize(); i++)
	{
		v.Add(mf.v.GetAt(i));
	}

}

CMedDLeFrame& CMedDLeFrame::operator=(const CMedDLeFrame& mf)
{
	name=mf.name;

	v.SetSize(mf.v.GetSize(),V_GROW_N);
	v.RemoveAll();

	int i;

	for(i=0; i<mf.v.GetSize(); i++)
	{
		v.Add(mf.v.GetAt(i));
	}

	return *this;
}

CMedDLeFrame CMedDLeFrame::operator+(const CMedDLeFrame& mf)
{

	CMedDLeFrame fr(*this);
	// add new verts
	UINT voff=v.GetSize();

	int i;
	for(i=0; i<mf.v.GetSize(); i++)
	{
		fr.v.Add(mf.v.GetAt(i));
	}

	return fr;
}


void CMedDLeFrame::GetMinMax()
{
	min.x[0]=min.x[1]=min.x[2]=0;
	max.x[0]=max.x[1]=max.x[2]=0;

	min.x[0]=v[0].x[0];
	min.x[1]=v[0].x[1];
	min.x[2]=v[0].x[2];
	max.x[0]=min.x[0];
	max.x[1]=min.x[1];
	max.x[2]=min.x[2];
	for (int i=0; i<v.GetSize(); i++)
	{
		if(v[i].x[0]<min.x[0]) min.x[0]=v[i].x[0];
		else if(v[i].x[0]>max.x[0]) max.x[0]=v[i].x[0];
		if(v[i].x[1]<min.x[1]) min.x[1]=v[i].x[1];
		else if(v[i].x[1]>max.x[1]) max.x[1]=v[i].x[1];
		if(v[i].x[2]<min.x[2]) min.x[2]=v[i].x[2];
		else if(v[i].x[2]>max.x[2]) max.x[2]=v[i].x[2];
	}

}

//----------------------------
// CMedDLeBaseFrame
CMedDLeBaseFrame::CMedDLeBaseFrame() 
{
	name ="unnamed";

	v.SetSize(V_GROW_N,V_GROW_N);
	f.SetSize(F_GROW_N,F_GROW_N);
	l.SetSize(L_GROW_N,L_GROW_N);

	t.RemoveAll();
	v.RemoveAll();
	f.RemoveAll();
	l.RemoveAll();

}
CMedDLeBaseFrame::CMedDLeBaseFrame(const TCHAR *n) 
{
	name =n;

	v.SetSize(V_GROW_N,V_GROW_N);
	f.SetSize(F_GROW_N,F_GROW_N);
	l.SetSize(L_GROW_N,L_GROW_N);

	t.RemoveAll();
	v.RemoveAll();
	f.RemoveAll();
	l.RemoveAll();

}

void CMedDLeBaseFrame::ClearAll() 
{

	v.RemoveAll();
	f.RemoveAll();
	l.RemoveAll();
	
	int N=t.GetSize();
	for(int i=0; i <N; i++)
	{
		delete t[i];
	}
	t.RemoveAll();

	v.SetSize(V_GROW_N,V_GROW_N);
	f.SetSize(F_GROW_N,F_GROW_N);
	l.SetSize(L_GROW_N,L_GROW_N);

	v.RemoveAll();
	f.RemoveAll();
	l.RemoveAll();

}

CMedDLeBaseFrame::~CMedDLeBaseFrame()
{
	name.Empty();
	l.RemoveAll();
	f.RemoveAll();
	v.RemoveAll();
	int N=t.GetSize();
	for(int i=0; i <N; i++)
	{
		delete t[i];
	}
	t.RemoveAll();

}

CMedDLeBaseFrame::CMedDLeBaseFrame(const CMedDLeBaseFrame& mf)
{
	name = mf.name;
	f.SetSize(mf.f.GetSize(),F_GROW_N);
	l.SetSize(mf.l.GetSize(),L_GROW_N);
	v.SetSize(mf.v.GetSize(),V_GROW_N);

	f.RemoveAll();
	l.RemoveAll();
	v.RemoveAll();
	t.RemoveAll();

	int i;
	for(i=0; i<mf.t.GetSize(); i++)
	{
		CMedDLeTexture *mt=new CMedDLeTexture(*mf.t.GetAt(i));
		t.Add(mt);
	}

	for(i=0; i<mf.v.GetSize(); i++)
	{
		v.Add(mf.v.GetAt(i));
	}

	for(i=0; i<mf.f.GetSize(); i++)
	{
		f.Add(mf.f.GetAt(i));
	}
	
	for(i=0; i<mf.l.GetSize(); i++)
	{
		l.Add(mf.l.GetAt(i));
	}


}

CMedDLeBaseFrame& CMedDLeBaseFrame::operator=(const CMedDLeBaseFrame& mf)
{
	name=mf.name;

	v.SetSize(mf.v.GetSize(),V_GROW_N);
	l.SetSize(mf.l.GetSize(),L_GROW_N);
	f.SetSize(mf.f.GetSize(),F_GROW_N);
	v.RemoveAll();
	f.RemoveAll();
	l.RemoveAll();
	int N=t.GetSize();
	for(int i=0; i <N; i++)
	{
		if(t[i]) delete t[i];
	}
	t.RemoveAll();

	for(i=0; i<mf.t.GetSize(); i++)
	{
		CMedDLeTexture *mt=new CMedDLeTexture;
		*mt=*mf.t.GetAt(i);
		t.Add(mt);
	}

	for(i=0; i<mf.v.GetSize(); i++)
	{
		v.Add(mf.v.GetAt(i));
	}

	for(i=0; i<mf.f.GetSize(); i++)
	{
		f.Add(mf.f.GetAt(i));
	}
	
	for(i=0; i<mf.l.GetSize(); i++)
	{
		l.Add(mf.l.GetAt(i));
	}

	return *this;
}

CMedDLeBaseFrame CMedDLeBaseFrame::operator+(const CMedDLeBaseFrame& mf)
{

	CMedDLeBaseFrame fr(*this);
	// add new verts
	UINT voff=v.GetSize();

	int i;
	for(i=0; i<mf.v.GetSize(); i++)
	{
		fr.v.Add(mf.v.GetAt(i));
	}

	CMedDLeFace m;
	for(i=0; i<mf.f.GetSize(); i++)
	{
		m=mf.f.GetAt(i);
		m.vindex[0]=voff+mf.f.GetAt(i).vindex[0];
		m.vindex[1]=voff+mf.f.GetAt(i).vindex[1];
		m.vindex[2]=voff+mf.f.GetAt(i).vindex[2];
		fr.f.Add(m);
	}

	CMedDLeLine ml;
	for(i=0; i<mf.l.GetSize(); i++)
	{
		ml=mf.l.GetAt(i);
		ml.vindex[0]=voff+mf.l.GetAt(i).vindex[0];
		ml.vindex[1]=voff+mf.l.GetAt(i).vindex[1];
		fr.l.Add(ml);
	}

	return fr;
}

CMedDLeBaseFrame CMedDLeBaseFrame::operator&(const DWORD flag)
{
	// add new verts
	CMedDLeBaseFrame fr(name);

	for(int i=0; i<v.GetSize(); i++)
	{
		if(flag&v[i].flags) fr.v.Add(v[i]);
	}
	return fr;
}

