// mdl graphics routines   
#ifndef __MEDDLEGFX_H
#define __MEDDLEGFX_H
#include <afxwin.h>
#include "MedDLeTypes.h"
#include <vfw.h>			// needed for DIBs
#pragma comment(lib, "vfw32.lib")

extern BYTE MedDLeCMap[256*64];
extern BYTE MedDLePalette[256*3];
// variables
// sorting
extern int *pIndexArray;
extern float *pZArray;
extern DWORD IndexArraySize;
extern void MedDLeSwap(float v[], int vi[], int i, int j);
extern void MedDLeSort(float v[], int vi[], int left, int right);
extern void GrowFor(DWORD N);
extern void ShrinkFor(DWORD N);
extern void DeleteSortArray();

extern int MedDLeCDCResX, MedDLeCDCResY; 
extern BYTE *MedDLeCurDib; 

// draw flags
#define DF_NONE		0
#define DF_18BIT	1
#define DF_ZBUFFER	2
#define DF_LIMIT	4

// functions
extern void MedDLeLoadPal( void );
extern void MedDLeLoadCMap( void );
extern BOOL MedDLeInitDIB (void );
extern BOOL MedDLeInitGFX();
extern void MedDLeShutDownGFX();
extern BOOL MedDLeBeginDraw(CDC* pDC, CRect &rc, int bgcolor, BYTE *dib=NULL, DWORD flags=0);
extern void MedDLeEndDraw();
extern void MedDLeDrawLine(int *x1,  int *x2,  int color );
extern void MedDLeDrawPoint( int *x1,  int color);
extern void MedDLeDrawSmallDot( int *x1,  int color);
extern void MedDLeDrawMediumDot( int *x1,  int color);
extern void MedDLeDrawLargeDot( int *x1,  int color);
extern BOOL MedDLeBeginOverlay(CDC* pDC);
extern void MedDLeEndOverlay();
extern void MedDLeOverlayLine(int *x1, int *x2, COLORREF color, int width, BOOL bDash );
extern void MedDLeOverlayText(int *x1, CString &str);


/*typedefs */
//typedef unsigned char byte;
//typedef unsigned short int  word;

//extern double BG_sin[256],BG_cos[256];  /* precalculated */
extern int G_ScreenWidth;
extern int G_ScreenHeight;
extern long G_ScreenSize;
extern long G_LineSize;
extern int G_ClipXMin, G_ClipYMin, G_ClipXMax, G_ClipYMax;       // clipping

// FUNCTIONS
/*
extern void BG_Init3dWindow(int w, int h);

extern void BG_Blit(void);
extern void BG_ClearScreen(byte color);
//extern void BG_Text(word x, word y,char *string,register unsigned char color);
extern void BG_Text(char *buff, int x, int y, int front, int back);
extern void MDL_Text(word x,word y,char *string,register unsigned char color);
extern void BG_PutPixel(word X, word Y, byte color );
extern void BG_Line(int, int, int, int, int);
extern void BG_WriteBMP(FILE *, unsigned char *pal, unsigned char *pic, unsigned w, unsigned h);
extern void BG_ReadBMP(FILE *, unsigned char *pal, unsigned char *pic, unsigned *w, unsigned *h);
extern void BG_SetPalette(byte *pal);
extern void BG_OpenPalette(char *palname, unsigned char *pal);

*/
extern void BG_Clip (int , int , int , int );

/////////////////////////////////////////////////////////////////////////
#define C_MAX_DIMENSIONS          6         /* dims in N-dimensional lines */
//#define C_Z_CLIPPING_MIN         10         /* where viewing plane is */
//#define C_X_CLIPPING_MIN          0         /* clipping cube */
//#define /   1024
//#define C_Y_CLIPPING_MIN          0
//#define C_Y_CLIPPING_MAX   1024

//int C_volume_clipping(int *from,int *to,int *vertex,int dimension,int length);

//int C_line_z_clipping(int **vertex1,int **vertex2,int dimension);
//int C_polygon_z_clipping(int *from,int *to,int dimension,int length);

int C_line_x_clipping(int **vertex1,int **vertex2,int dimension);
int C_line_y_clipping(int **vertex1,int **vertex2,int dimension);
int C_polygon_x_clipping(int *from,int *to,int dimension,int length);

//#define M_AMBIENT              0x3          /* constant colour polygon */
//#define M_SHADED               0x4          /* Gouraud shaded polygon */
//#define M_TEXTURED             0x5          /* texture mapped polygon */
//#define M_POLYGON_LENGTH_LIMIT  50          /* length of tmp arrays */

//#define M_SIZE_EDGE_ARRAY       15          /* coordinates + colours + etc */

//#define G_MAX_TUPLES            50          /* big enough? */
//#define G_MAX_SHADED_TUPLES    100
//#define G_MAX_TEXTURED_TUPLES  120


extern BYTE *G_buffer;                    /* the bitmap's bits */
extern WORD *G_buffer16;                    /* the bitmap's bits */
extern WORD *G_zbuffer;                    /* the bitmap's bits */

//unsigned char *G_init_graphics(void);
void G_clear(int c);
void G_dot(int *vertex,unsigned char colour);
void G_smalldot(int *vertex,unsigned char colour);
void G_bigdot(int *vertex,unsigned char colour);
void G_plusdot(int *vertex,unsigned char colour);
void G_xdot(int *vertex,unsigned char colour);
void G_meddot(int *vertex,unsigned char colour);
void G_line(int *vertex1,int *vertex2,unsigned char colour);
void G_text(int x,int y,char *string,unsigned char colour);
// returns a true if point is in poly
BOOL G_hit_polygon(int *edges,int length, POINT pt);
// flat shading
void G_ambient_polygon(int *edges,int length,BYTE colour);
// gourourd shading
void G_shaded_polygon(int *edges,int length);
// textured.. bilinear
void G_textured_polygon(int *edges,int length, BYTE *texture, unsigned bitmapw);
// textured and gourourd shaded
void G_gtex_poly(int *edges,int length,	BYTE *texture, unsigned bitmapw);
// textured and gourourd shaded.. uses z buffer
void Gz_gtex_poly(int *edges,int length, BYTE *texture, unsigned bitmapw);
// lighten area under poly
void G_hilight_polygon(int *edges,int length, BYTE colour);
// darken or lighten (depth 0 to 64, 32 = brightness change) with see through
void G_colored_glass_polygon(int *edges,int length,BYTE colour, BYTE depth);
// hilight textured 
void G_Htextured_polygon(int *edges,int length,	BYTE *texture, unsigned bitmapw, BYTE cd);
// hilight textured/ shaded 
void G_Hgtex_poly(int *edges,int length, BYTE *texture, unsigned bitmapw, BYTE cd);

#endif