// GridTool.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "GridTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGridTool dialog


CGridTool::CGridTool(CWnd* pParent /*=NULL*/)
	: CDialog(CGridTool::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGridTool)
	m_Snap = FALSE;
	m_Vis = FALSE;
	m_Spacing = 0.0f;
	m_frame = FALSE;
	m_framevalue = -1;
	//}}AFX_DATA_INIT
}


void CGridTool::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGridTool)
	DDX_Control(pDX, IDC_COMBO1, m_combo);
	DDX_Control(pDX, IDC_BUTTON1, m_btnSet);
	DDX_Check(pDX, IDC_CHECK_SNAP, m_Snap);
	DDX_Check(pDX, IDC_CHECK_VIS, m_Vis);
	DDX_Text(pDX, IDC_EDIT1, m_Spacing);
	DDV_MinMaxFloat(pDX, m_Spacing, 1.e-008f, 1000.f);
	DDX_Check(pDX, IDC_CHECK_SHOWLAST, m_frame);
	DDX_CBIndex(pDX, IDC_COMBO1, m_framevalue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGridTool, CDialog)
	//{{AFX_MSG_MAP(CGridTool)
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_CHECK_SNAP, OnCheckSnap)
	ON_BN_CLICKED(IDC_CHECK_VIS, OnCheckVis)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_CHECK_SHOWLAST, OnCheckFrame)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGridTool message handlers

void CGridTool::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	m_Snap = theApp.m_pActiveDoc->m_Grid.bSnap;
	m_Vis = theApp.m_pActiveDoc->m_Grid.bVisible;
	m_Spacing = theApp.m_pActiveDoc->m_Grid.fSpacing;
	m_combo.SetCurSel(0);
	UpdateData(0);

	// TODO: Add your message handler code here
	
}

void CGridTool::OnCheckSnap() 
{
	UpdateData();
	theApp.m_pActiveDoc->m_Grid.bSnap=m_Snap;
	theApp.m_pActiveDoc->UpdateAllViews(NULL);

}

void CGridTool::OnCheckVis() 
{
	UpdateData();
	theApp.m_pActiveDoc->m_Grid.bVisible=m_Vis;
	theApp.m_pActiveDoc->UpdateAllViews(NULL);
	
}

void CGridTool::OnButton1() 
{
	UpdateData();
	if(m_Spacing<=0) m_Spacing=1.;

	theApp.m_pActiveDoc->m_Grid.fSpacing=m_Spacing;
	theApp.m_pActiveDoc->UpdateAllViews(NULL);
	
}

void CGridTool::OnCheckFrame() 
{
	
}

void CGridTool::OnSelchangeCombo1() 
{
	
}
