// BonePage.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "BonePage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBonePage property page

IMPLEMENT_DYNCREATE(CBonePage, CPropertyPage)

CBonePage::CBonePage() : CPropertyPage(CBonePage::IDD)
{
	//{{AFX_DATA_INIT(CBonePage)
	m_Hard = FALSE;
	m_Stickverts = FALSE;
	m_Volume = FALSE;
	m_MoveKids = FALSE;
	//}}AFX_DATA_INIT
}

CBonePage::~CBonePage()
{
}

void CBonePage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBonePage)
	DDX_Control(pDX, IDC_BUTTON_PICKCURPARENT, m_PickCurParent);
	DDX_Control(pDX, IDC_BUTTON_PICKP, m_PickP);
	DDX_Control(pDX, IDC_BUTTON_MOVE, m_Move);
	DDX_Control(pDX, IDC_BUTTON_DETACH, m_Detach);
	DDX_Control(pDX, IDC_BUTTON_DEL, m_Del);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_Add);
	DDX_Check(pDX, IDC_CHECK_HARD, m_Hard);
	DDX_Check(pDX, IDC_CHECK_MOVEVERTS, m_Stickverts);
	DDX_Check(pDX, IDC_CHECK_VOLUME, m_Volume);
	DDX_Check(pDX, IDC_CHECK_MVKIDS, m_MoveKids);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBonePage, CPropertyPage)
	//{{AFX_MSG_MAP(CBonePage)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DEL, OnButtonDel)
	ON_BN_CLICKED(IDC_BUTTON_DETACH, OnButtonDetach)
	ON_BN_CLICKED(IDC_BUTTON_MOVE, OnButtonMove)
	ON_BN_CLICKED(IDC_BUTTON_PICKP, OnButtonPickp)
	ON_BN_CLICKED(IDC_CHECK_HARD, OnCheckHard)
	ON_BN_CLICKED(IDC_CHECK_MOVEVERTS, OnCheckMoveverts)
	ON_BN_CLICKED(IDC_CHECK_VOLUME, OnCheckVolume)
	ON_BN_CLICKED(IDC_RADIO_ROTATE, OnRadioRotate)
	ON_BN_CLICKED(IDC_RADIO_SCALE, OnRadioScale)
	ON_BN_CLICKED(IDC_RADIO_TRANS, OnRadioTrans)
	ON_BN_CLICKED(IDC_RADIO_TWIST, OnRadioTwist)
	ON_BN_CLICKED(IDC_CHECK_MVKIDS, OnCheckMvkids)
	ON_BN_CLICKED(IDC_BUTTON_PICKCURPARENT, OnButtonPickcurparent)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBonePage message handlers
void CBonePage::UpdateBoneInfo(void)
{
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
	if(pDoc==NULL) return;
	m_Hard=0;

	if(pDoc->SkelOptions&BO_HARD) m_Hard=1;
	m_Stickverts=0;
	if(pDoc->SkelOptions&BO_STICKY) m_Stickverts=1;
	m_Volume=0;
	if(pDoc->SkelOptions&BO_CONSTVOLUME) m_Volume=1;
	m_MoveKids=0;
	if(pDoc->SkelOptions&BO_MOVECHILD) m_MoveKids=1;
	

	UpdateData(0);

}


void CBonePage::OnButtonAdd() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_ADDVERTS;
	
}

void CBonePage::OnButtonDel() 
{
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
	if(theApp.m_pActiveDoc==NULL) return;
	if(pDoc->EditMode==SM_SKEL)
	{
		pDoc->SkelAction=BA_DETACHVERTS;
		for(int i=0; i<pDoc->Verts.GetSize(); i++)
		{
			if((pDoc->Verts[i].flags&O_SELECTED)&&!(pDoc->Verts[i].flags&O_HIDDEN)) 
			{ 
					pDoc->Verts[i].skel=-1; 
					pDoc->Verts[i].flags&= ~O_SELECTED;
			}

		}
		pDoc->SkelAction=0;
	}
	
}

void CBonePage::OnButtonDetach() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_DETACHBONE;
	
}

void CBonePage::OnButtonMove() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_MOVEVTO;
	
}

void CBonePage::OnButtonPickp() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_PICKPARENT;
	
}

void CBonePage::OnCheckHard() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	theApp.m_pActiveDoc->SkelOptions^=BO_HARD;
}

void CBonePage::OnCheckMoveverts() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	theApp.m_pActiveDoc->SkelOptions ^= BO_STICKY;
}

void CBonePage::OnCheckVolume() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	theApp.m_pActiveDoc->SkelOptions ^= BO_CONSTVOLUME;
}

void CBonePage::OnRadioRotate() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_ROT;
}

void CBonePage::OnRadioScale() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_SCALE;
	
}

void CBonePage::OnRadioTrans() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
	{
		//AfxMessageBox("Trans");	
		theApp.m_pActiveDoc->SkelAction=BA_TRANS;
	}
}

void CBonePage::OnRadioTwist() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_TWIST;
	
}

void CBonePage::OnCheckMvkids() 
{
	if(theApp.m_pActiveDoc==NULL) return;
	theApp.m_pActiveDoc->SkelOptions ^= BO_MOVECHILD;
	
}

void CBonePage::OnButtonPickcurparent() 
{
	
	if(theApp.m_pActiveDoc==NULL) return;
	if(theApp.m_pActiveDoc->EditMode==SM_SKEL)
		theApp.m_pActiveDoc->SkelAction=BA_PICKCURPARENT;
	
}
