// AnimateTool.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "AnimateTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAnimateTool dialog


CAnimateTool::CAnimateTool(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimateTool::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimateTool)
	//}}AFX_DATA_INIT
}


void CAnimateTool::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimateTool)
	DDX_Control(pDX, IDC_SKINS, m_skin);
	DDX_Control(pDX, IDC_VVERTS, m_v);
	DDX_Control(pDX, IDC_VTRIS, m_t);
	DDX_Control(pDX, IDC_VLINES, m_l);
	DDX_Control(pDX, IDC_VFULL, m_f);
	DDX_Control(pDX, IDC_SLIDER1, m_slider);
	DDX_Control(pDX, IDC_FRAME, m_frame);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAnimateTool, CDialog)
	//{{AFX_MSG_MAP(CAnimateTool)
	ON_WM_TIMER()
	ON_WM_HSCROLL()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_VFULL, OnVfull)
	ON_BN_CLICKED(IDC_VLINES, OnVlines)
	ON_BN_CLICKED(IDC_VTRIS, OnVtris)
	ON_BN_CLICKED(IDC_VVERTS, OnVverts)
	ON_WM_KEYDOWN()
	ON_BN_CLICKED(IDC_SKINS, OnSkins)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimateTool message handlers

BOOL CAnimateTool::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CRect rc;

	m_frame.GetClientRect(&rc);
	m_frame.MapWindowPoints( this, &rc);

	m_wnd3D.Create(NULL, 
		"Animation View", 
		WS_CHILD|WS_VISIBLE, 
		rc, 
		this, 
		1);
		
	m_wnd3D.m_bDrawLines=0;
	m_l.SetCheck(0);
	m_l.InvalidateRect(NULL,0);
	m_wnd3D.m_bDrawFaces=0;
	m_wnd3D.m_bTexture=TRUE;

//	m_t.SetCheck(1);
//	m_t.InvalidateRect(NULL,0);
	m_wnd3D.m_bDrawVerts=0;
	m_v.SetCheck(0);
	m_v.InvalidateRect(NULL,0);

	m_curframe=0;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


BEGIN_EVENTSINK_MAP(CAnimateTool, CDialog)
    //{{AFX_EVENTSINK_MAP(CAnimateTool)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CAnimateTool::OnTimer(UINT nIDEvent) 
{
	CDialog::OnTimer(nIDEvent);
	CMedDLeObject *mo;
	int i,j;
	m_wnd3D.m_cur3dframe=-1;
	if(theApp.m_pActiveDoc!=NULL)
	{
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		mo=&pDoc->m_MedDLeObject;

		if(mo->m_Anims.GetSize()>0)
		{
			int ca=mo->m_curAnimN;
			if(mo->m_Anims[ca]->framelist.GetSize()>0)
			{
				if(mo->m_Anims[ca])
				{
					if( m_curframe >= mo->m_Anims[mo->m_curAnimN]->framelist.GetSize())
					{
						m_curframe=0;
//				m_wnd3D.FullScreen(0);
					}
					j=mo->m_Anims[ca]->framelist[m_curframe];
	
					m_wnd3D.m_cur3dframe=j;
					m_wnd3D.InvalidateRect(NULL,0);

					m_curframe++;
				}
			}
			else
			{
				m_curframe=0;
				m_wnd3D.m_cur3dframe=-1;
				m_wnd3D.InvalidateRect(NULL,0);
			}
		}
		else
		{
				m_curframe=0;
				m_wnd3D.m_cur3dframe=0;

		}
	}


}

void CAnimateTool::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

BOOL CAnimateTool::DestroyWindow() 
{
	KillTimer(1);
	return CDialog::DestroyWindow();
}

void CAnimateTool::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	if(!bShow) KillTimer(1);
	else SetTimer(1,100,NULL);
	CDialog::OnShowWindow(bShow, nStatus);
	
}

void CAnimateTool::OnVfull() 
{
	m_wnd3D.FullScreen(1);
	//AfxGetMainWnd()->SetForegroundWindow();

	SetForegroundWindow();
}

void CAnimateTool::OnVlines() 
{
	if(m_wnd3D.m_bDrawLines==1)
	{
		m_wnd3D.m_bDrawLines=0;
		m_l.SetCheck(0);
		m_l.InvalidateRect(NULL,0);
	}
	else
	{
		m_wnd3D.m_bDrawLines=1;
		m_l.SetCheck(1);
		m_l.InvalidateRect(NULL,0);
	}
	
}

void CAnimateTool::OnVtris() 
{
	if(m_wnd3D.m_bDrawFaces==1)
	{
		m_wnd3D.m_bDrawFaces=0;
		m_wnd3D.m_bTexture=TRUE;

//		m_t.SetCheck(0);
//		m_t.InvalidateRect(NULL,0);
	}
	else if(m_wnd3D.m_bTexture==TRUE)
	{
		m_wnd3D.m_bDrawFaces=0;
		m_wnd3D.m_bTexture=0;
//		m_t.SetCheck(1);
//		m_t.InvalidateRect(NULL,0);
	}
	else
	{
		m_wnd3D.m_bDrawFaces=1;
		m_wnd3D.m_bTexture=0;
//		m_t.SetCheck(1);
//		m_t.InvalidateRect(NULL,0);
	}
	
}

void CAnimateTool::OnVverts() 
{
	if(m_wnd3D.m_bDrawVerts==1)
	{
		m_wnd3D.m_bDrawVerts=0;
		m_v.SetCheck(0);
		m_v.InvalidateRect(NULL,0);
	}
	else
	{
		m_wnd3D.m_bDrawVerts=1;
		m_v.SetCheck(1);
		m_v.InvalidateRect(NULL,0);
	}
}

void CAnimateTool::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default

	if(nChar==VK_ESCAPE) m_wnd3D.FullScreen(0);
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CAnimateTool::FullScreen(BOOL f)
{
	m_wnd3D.FullScreen(f);
}
void CAnimateTool::OnSkins() 
{
	m_wnd3D.m_curtexture++;
}
