// 3DWnd.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "MedDLeGFX\MedDLeGFX.h"
#include "MedDLeGFX\MedDLeMath.h"
#include "3DWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// C3DWnd

C3DWnd::C3DWnd()
{
	MovingEye=FALSE; 
	RotatingLight=FALSE; 
	RotatingEye=FALSE;
	LeftStart=FALSE;
	RightStart=FALSE;
	LeftClean=FALSE;
	RightClean=FALSE;
	sensitivity = .85;

	win_width=3.2f;
	win_height=2.4f;
	focus=4;

	m_bTexture=TRUE;
	m_bDrawVerts=0;
	m_bDrawLines=0;
	m_bDrawFaces=1;
	m_bBackFaceCull=1;
	m_cur3dframe=-1;
	m_curtexture=-1;
	m_bFullScreen=0;
	m_pParent=NULL;
}

C3DWnd::~C3DWnd()
{
}


BEGIN_MESSAGE_MAP(C3DWnd, CWnd)
	//{{AFX_MSG_MAP(C3DWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_ESCAPEPRESSED, OnEscapepressed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// C3DWnd message handlers

BOOL C3DWnd::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL ret;
	ret=CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);

	m_World = 1.f;

	m_View = ViewMatrix(
		CMedDLePoint3D(100,0,0), 
		CMedDLePoint3D(0,0,0), 
		CMedDLePoint3D(0,0,1), 0);

//	m_Proj = ProjectionMatrix(0.01f, 2000000.0f, (float)(60*PI/180)); // 60 degree FOV
	m_rcSmall=rect;
	m_pParent=pParentWnd;
	RightStart=0;	
	ResetView();	
	return ret;

}

void C3DWnd::FullScreen(BOOL f)
{

	if(f)
	{
		if(!m_bFullScreen)
		{
			GetWindowRect(&m_rcSmall);
			m_bFullScreen=1;
			m_pParent=GetParent();
//			SetOwner(m_pParent);
			SetParent(NULL);
			
			ModifyStyle(WS_CHILD, WS_POPUP);
			int w,h;
			w=GetSystemMetrics(SM_CXSCREEN);
			h=GetSystemMetrics(SM_CYSCREEN);
			CRect rc;
			AfxGetMainWnd()->GetWindowRect(&rc);
			SetWindowPos( NULL , 0, 0, w,h, SWP_SHOWWINDOW|SWP_NOACTIVATE|SWP_NOOWNERZORDER|SWP_NOZORDER );
			SetForegroundWindow();
			SetFocus();
		}
	}
	else
	{
		if(m_bFullScreen)
		{
			m_bFullScreen=0;
			ModifyStyle(WS_POPUP,WS_CHILD);
			::SetWindowPos( m_hWnd, HWND_TOPMOST,
				0, 0, 
				m_rcSmall.Width(), m_rcSmall.Height(), 
				SWP_NOMOVE|SWP_SHOWWINDOW );
			::SetWindowPos( m_hWnd, m_pParent->m_hWnd, 
				m_rcSmall.left, m_rcSmall.top, 
				m_rcSmall.Width(), m_rcSmall.Height(),
				SWP_SHOWWINDOW );
			SetParent(m_pParent);
			
		}

	}
}

BOOL C3DWnd::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CWnd::DestroyWindow();
}

void C3DWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{

	CWnd::OnLButtonDown(nFlags, point);

	CMedDLeDoc *pDoc= GetDocument();
	if ((!RightStart) && !(nFlags&MK_RBUTTON)){
		HasShift=FALSE;
		if (nFlags&MK_SHIFT) HasShift=TRUE;
		HasCtrl=FALSE;
		if (nFlags&MK_CONTROL) HasCtrl=TRUE;
/*		if (HasShift) {
			RenderHit(point);
			int i, cnt;
			cnt=pDoc->HitIndex.GetSize();
			if(cnt==0) return;

			int j=cnt-1;
			int PClicked;
			PClicked=pDoc->Tris[pDoc->HitIndex.GetAt(j)].vindex[0];
			int trin=pDoc->HitIndex.GetAt(j);
			int objn=pDoc->Verts[PClicked].object;
			int grpn=pDoc->Verts[PClicked].group;
			if (pDoc->EditMode == SM_VERT){
				if((pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags&O_SELECTED)
				&&(pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags&O_SELECTED)
				&&(pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags&O_SELECTED))
				{
					pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags &=~O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags &=~O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags &=~O_SELECTED;
				}
				else
				{
					pDoc->Verts[pDoc->Tris[trin].vindex[0]].flags |= O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[1]].flags |= O_SELECTED;
					pDoc->Verts[pDoc->Tris[trin].vindex[2]].flags |= O_SELECTED;
				}
			} else if (pDoc->EditMode == SM_TRI){ 
				if (pDoc->Tris[trin].Vflags & O_SELECTED) pDoc->Tris[trin].Vflags &=~O_SELECTED;
				else pDoc->Tris[trin].Vflags |= O_SELECTED;
			} else if (pDoc->EditMode == SM_GROUP){
				if (pDoc->Objects[objn].Groups[grpn]->flags & O_SELECTED) pDoc->Objects[objn].Groups[grpn]->flags &=~O_SELECTED;
				else pDoc->Objects[objn].Groups[grpn]->flags |= O_SELECTED;
			} else if (pDoc->EditMode == SM_OBJECT){
				if (pDoc->Objects[objn].flags & O_SELECTED) pDoc->Objects[objn].flags &=~O_SELECTED;
				else pDoc->Objects[objn].flags |= O_SELECTED;
			}
			pDoc->ColorSort();
			pDoc->UpdateAllViews(NULL);
		}
		else {
		*///	oldsit=pDoc->sit;
			RotatingEye=TRUE;
			LeftStart=TRUE;
			LeftClean=FALSE;
			RightClean=FALSE;
			SetCapture();
			NoMotion=0;
			ClickPoint=point;
			OldPoint=point;
	}

}

void C3DWnd::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonUp(nFlags, point);

	if (LeftStart){
		LeftStart=FALSE;
		if (!(nFlags&MK_RBUTTON) && (GetCapture()==this)) ReleaseCapture();
		else if (nFlags&MK_RBUTTON) RightClean=TRUE;
		RotatingEye=FALSE;
		RotatingLight=FALSE;
	}
	if (LeftClean==TRUE) if (GetCapture()==this) ReleaseCapture();
	LeftClean=FALSE;
	

}

void C3DWnd::OnMouseMove(UINT nFlags, CPoint point) 
{
	CWnd::OnMouseMove(nFlags, point);
	CMedDLeDoc *pDoc= GetDocument();

	if (GetCapture() != this) return;

	if (LeftStart) 
	{
		if (RotatingEye)
		{
			float dx,dy;
			dx=(float)(OldPoint.x-point.x)/70.;
			dy=-(float)(OldPoint.y-point.y)/70.;
		    float x=m_View(0,3);
			float y=m_View(1,3);
			float z=m_View(2,3);

			m_View= MatrixMultiply(Translate(-x,-y,-z),m_View);
			m_View = MatrixMultiply(RotateX(dy),m_View);
			m_View=MatrixMultiply(Translate(x,y,z),m_View);
			m_View = MatrixMultiply(m_View,RotateZ(dx)); 

			OldPoint=point;
			InvalidateRect(NULL,0);
		} 
		else if (RotatingLight)
		{
	//		pDoc->light_ray=oldlight;
	//		BG_Matrix Rx;
	//		BG_Matrix Ry;
			int dx,dy;
			dx=(ClickPoint.x-point.x);
			dy=(ClickPoint.y-point.y);
	//		Rx=BG_CalcRx((byte)dx);
	//		Ry=BG_CalcRy((byte)dy);
	//		pDoc->light_ray=BG_MatrixVector3(&Rx,&pDoc->light_ray);
	//		pDoc->light_ray=BG_MatrixVector3(&Ry,&pDoc->light_ray);
			OldPoint=point;
			InvalidateRect(NULL,0);
		}
	}
	else if (RightStart)
	{
		if (NoMotion == 0) 
		{
			if (abs(point.x-OldPoint.x) > 2) NoMotion = 1;
			if (abs(point.y-OldPoint.y) > 2) NoMotion = 1;
		} 
		else if (MovingEye)
		{
   			float dx,dy;
			dx=(float)(OldPoint.x-point.x);
			dy=(float)(OldPoint.y-point.y);

			if (nFlags&MK_LBUTTON)
			m_View=MatrixMultiply(Translate(dx,0,dy),m_View);
			else	
			m_View=MatrixMultiply(Translate(dx,dy,0),m_View);

			OldPoint=point;
			InvalidateRect(NULL,0);
		}
	}


}

void C3DWnd::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CDC *pDC=&dc;

	CMedDLeDoc *pDoc=GetDocument();
	if(!pDoc) return;
	
	CMedDLeFrame *mf;
	if((m_cur3dframe<0)||(m_cur3dframe>=pDoc->m_MedDLeObject.m_Frames.GetSize()) )
	{
		mf=pDoc->m_MedDLeObject.m_curFrame;
	}
	else
	{
		mf=pDoc->m_MedDLeObject.m_Frames[m_cur3dframe];

	}

	if (mf == NULL  || pDoc->m_MedDLeObject.m_Frames.GetSize()==0)
	{
	    CRect rc;    
		GetClientRect(&rc);
		int resx, resy; 
		resx=rc.right+1;
		resy=rc.bottom+1;
		// upper limit on res of rendering
		if(resx>1023) resx=1024;
		if(resy>1023) resy=1024;
		rc.right=resx-1;
		rc.bottom=resy-1;
	
		MedDLeBeginDraw(pDC, rc, 0);
		resx=MedDLeCDCResX;
		resy=MedDLeCDCResY;
	
		MedDLeEndDraw();
		return;
	}


	int		i,j,k,l;
	float	faceintensity;		// intensity of flat shaded face
	int		nFacePts[32];		// vertex corners (screen coords)
	DWORD		vindex;				// vertex index
	DWORD		findex;				// face index
	CMedDLePoint3D	pt[3];		
	CMedDLePoint3D	facenormal;		
	DWORD faces;
	
	faces = pDoc->m_MedDLeObject.m_BaseFrame->f.GetSize();

	
	// get size of windows
    CRect rc;    
	GetClientRect(&rc);
	int resx, resy; 
	resx=rc.right+1;
	resy=rc.bottom+1;
	// upper limit on res of rendering
	if(resx>1023) resx=1024;
	if(resy>1023) resy=1024;
	rc.right=resx-1;
	rc.bottom=resy-1;
	

	BYTE *dib=NULL;
	if(pDoc->m_MedDLeObject.m_BaseFrame->t.GetSize()>0)
	{
		BYTE *sdib, *ddib;
		sdib=pDoc->m_MedDLeObject.m_BaseFrame->t[0]->header;
		int bits= ((LPBITMAPINFOHEADER)sdib)->biBitCount;
		if(bits==8)
		{
			dib=new BYTE[sizeof(RGBQUAD)*256+sizeof(BITMAPINFOHEADER)];
			if(dib) memcpy(dib,sdib,sizeof(RGBQUAD)*256+sizeof(BITMAPINFOHEADER));
		}

	}

	MedDLeBeginDraw(pDC, rc, 0, dib);

	resx=MedDLeCDCResX;
	resy=MedDLeCDCResY;
	// Scaling matrix, scales the points to the screen
	Scaling=1.f;
	Scaling(0,0)=-focus*(double)(resy-1)/win_height;    //scale x
	Scaling(0,2)=(resx/2);
	Scaling(1,2)=(resy/2);
	Scaling(1,1)=-focus*(double)(resy-1)/win_width;    // scale y


	// put all points in camera coordinates
	for(k=0; k < pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); k++)
	{
		
		// the vertext into working coordinates
	    mf->v[k].wx[0] =
			 m_View.m[0][0]*mf->v[k].x[0]
			+m_View.m[0][1]*mf->v[k].x[1]
			+m_View.m[0][2]*mf->v[k].x[2]
			+m_View.m[0][3];
	    mf->v[k].wx[1] =
			 m_View.m[1][0]*mf->v[k].x[0]
			+m_View.m[1][1]*mf->v[k].x[1]
			+m_View.m[1][2]*mf->v[k].x[2]
			+m_View.m[1][3];
	    mf->v[k].wx[2] =
			 m_View.m[2][0]*mf->v[k].x[0]
			+m_View.m[2][1]*mf->v[k].x[1]
			+m_View.m[2][2]*mf->v[k].x[2]
			+m_View.m[2][3];

		// now the vertex normals...
	    mf->v[k].n.wx[0] =
			 m_View.m[0][0]*mf->v[k].n.x[0]
			+m_View.m[0][1]*mf->v[k].n.x[1]
			+m_View.m[0][2]*mf->v[k].n.x[2]
			+m_View.m[0][3];
	    mf->v[k].n.wx[1] =
			 m_View.m[1][0]*mf->v[k].n.x[0]
			+m_View.m[1][1]*mf->v[k].n.x[1]
			+m_View.m[1][2]*mf->v[k].n.x[2]
			+m_View.m[1][3];
	    mf->v[k].n.wx[2] =
			 m_View.m[2][0]*mf->v[k].n.x[0]
			+m_View.m[2][1]*mf->v[k].n.x[1]
			+m_View.m[2][2]*mf->v[k].n.x[2]
			+m_View.m[2][3];

	}
	
	// do some sorting...
	// grow index array if needed
	GrowFor(faces);

	// go through all the triangles and put in list to sort
	for(k=0; k <faces; k++)
	{
		pIndexArray[k]=k;
	
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[0];
		pZArray[k]=mf->v[vindex].wx[2];
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[1];
		if(mf->v[vindex].wx[2] > pZArray[k]) pZArray[k]=mf->v[vindex].wx[2];
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[2];
		if(mf->v[vindex].wx[2] > pZArray[k]) pZArray[k]=mf->v[vindex].wx[2];
	}

	MedDLeSort(pZArray, pIndexArray, 0, faces-1);

	// draw floor grid

	// DrawGrid(resy);

	// go through all the triangles and draw em
	for(k=0; k <faces; k++)
	{
		findex=pIndexArray[k];
		// get the 3 vertices for this face (in camera's coordinates)
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[0];
		pt[0].x[0]=mf->v[vindex].wx[0];
		pt[0].x[1]=mf->v[vindex].wx[1];
		pt[0].x[2]=mf->v[vindex].wx[2];
		
		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[1];
		pt[1].x[0]=mf->v[vindex].wx[0];
		pt[1].x[1]=mf->v[vindex].wx[1];
		pt[1].x[2]=mf->v[vindex].wx[2];

		vindex=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].vindex[2];
		pt[2].x[0]=mf->v[vindex].wx[0];
		pt[2].x[1]=mf->v[vindex].wx[1];
		pt[2].x[2]=mf->v[vindex].wx[2];

		// get face normal
		facenormal=CrossProduct(pt[0] - pt[1], pt[2] - pt[1]);
		facenormal=Normalize(facenormal);
		
		// to screen coords (i cut out some fat, p=Scale*pt)
		pt[0].wx[2] = pt[0].x[2];
		pt[1].wx[2] = pt[1].x[2];
		pt[2].wx[2] = pt[2].x[2];

		// if in front of camera
		if((pt[0].wx[2]!=0.f)&&(pt[0].wx[2]>0.f) &&
			(pt[1].wx[2]!=0.f)&&(pt[1].wx[2]>0.f) &&
			(pt[2].wx[2]!=0.f)&&(pt[2].wx[2]>0.f) &&
			(!m_bDrawFaces || !m_bBackFaceCull || (facenormal.x[2]<0)) ) 
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
			pt[2].wx[0] = Scaling.m[0][0]*pt[2].x[0] + Scaling.m[0][2]*pt[2].x[2];
			pt[2].wx[1] = Scaling.m[1][1]*pt[2].x[1] + Scaling.m[1][2]*pt[2].x[2];

			if(!m_bTexture || (pDoc->m_MedDLeObject.m_BaseFrame->t.GetSize()<1))
			{
				nFacePts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
				nFacePts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
				nFacePts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
				nFacePts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
				nFacePts[4]=(int)(pt[2].wx[0]/pt[2].wx[2]);
				nFacePts[5]=resy-(int)(pt[2].wx[1]/pt[2].wx[2]);

				nFacePts[6]=nFacePts[0];
				nFacePts[7]=nFacePts[1];
	
				int color;
			
				color=MedDLeCMap[7 + 256*(int)(64+facenormal.x[2]*64.f)];

				if(m_bDrawFaces)
				{
					G_ambient_polygon(nFacePts,3,color);
					color=0;
				}
				else
				{
					color=12;
				}
				if(m_bDrawLines)
				{
					G_line(&nFacePts[0],&nFacePts[2],color);
					G_line(&nFacePts[4],&nFacePts[2],color);
					G_line(&nFacePts[4],&nFacePts[0],color);
				}
				if(m_bDrawVerts)
				{
					G_dot(&nFacePts[0],250);
					G_dot(&nFacePts[2],250);
					G_dot(&nFacePts[4],250);
				}
			}
			else
			{
				nFacePts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
				nFacePts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
				nFacePts[2]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[0][0];
				nFacePts[3]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[0][1];

				nFacePts[4]=(int)(pt[1].wx[0]/pt[1].wx[2]);
				nFacePts[5]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
				nFacePts[6]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[1][0];
				nFacePts[7]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[1][1];
			
				nFacePts[8]=(int)(pt[2].wx[0]/pt[2].wx[2]);
				nFacePts[9]=resy-(int)(pt[2].wx[1]/pt[2].wx[2]);
				nFacePts[10]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[2][0];
				nFacePts[11]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[2][1];

				nFacePts[12]=nFacePts[0];
				nFacePts[13]=nFacePts[1];
				nFacePts[14]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[0][0];
				nFacePts[15]=pDoc->m_MedDLeObject.m_BaseFrame->f[findex].tx[0][1];
	
			
				if(m_curtexture>=pDoc->m_MedDLeObject.m_BaseFrame->t.GetSize()) m_curtexture=0;
				else if(m_curtexture==-1) m_curtexture=0;
				BYTE *buf=pDoc->m_MedDLeObject.m_BaseFrame->t[0]->bitmap;
				int w=pDoc->m_MedDLeObject.m_BaseFrame->t[0]->bmpheader->biWidth;
				G_textured_polygon(nFacePts,3,buf,w);

				if(m_bDrawLines)
				{
					int	color=12;

					G_line(&nFacePts[0],&nFacePts[4],color);
					G_line(&nFacePts[8],&nFacePts[4],color);
					G_line(&nFacePts[8],&nFacePts[0],color);
				}
				if(m_bDrawVerts)
				{
					G_dot(&nFacePts[0],250);
					G_dot(&nFacePts[4],250);
					G_dot(&nFacePts[8],250);
				}
			
			}
		}


	}

	MedDLeEndDraw();
	if(dib) delete [] dib;

}
void C3DWnd::DrawGrid(int resy)
{
	//CMedDLeFrame *mf=pDoc->m_MedDLeObject.m_curFrame;
	CMedDLePoint3D	pt[3];		

	int i,j,k;
	int npts[4];
	for(k=0; k <= 10; k++)
	{
		for(i=0; i<3; i++)
		{

	    pt[0].x[i] =
			 m_View.m[i][0]*(-100.f+k*20)
			+m_View.m[i][1]*-100.f
			+m_View.m[i][3];

		pt[1].x[i] =
			 m_View.m[i][0]*(-100.f+k*20)
			+m_View.m[i][1]*100.f
			+m_View.m[i][3];

		}

		pt[0].wx[2]=pt[0].x[2];
		pt[1].wx[2]=pt[1].x[2];
		// if in front of camera
		if((pt[0].x[2]!=0.f) && (pt[1].x[2]!=0.f))
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
		
			npts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
			npts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
			npts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
			npts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
			G_line(&npts[0],&npts[2],6);
		}

	}
	for(k=0; k <= 10; k++)
	{
		for(i=0; i<3; i++)
		{

	    pt[0].x[i] =
			 m_View.m[i][0]*-100.f
			+m_View.m[i][1]*(-100.f+k*20)
			+m_View.m[i][3];

		pt[1].x[i] =
			 m_View.m[i][0]*100.f
			+m_View.m[i][1]*(-100.f+k*20)
			+m_View.m[i][3];

		}

		pt[0].wx[2]=fabs(pt[0].x[2]);
		pt[1].wx[2]=fabs(pt[1].x[2]);
		// if in front of camera
		if((pt[0].x[2]!=0.f) && (pt[1].x[2]!=0.f))
		{
			pt[0].wx[0] = Scaling.m[0][0]*pt[0].x[0] + Scaling.m[0][2]*pt[0].x[2];
			pt[0].wx[1] = Scaling.m[1][1]*pt[0].x[1] + Scaling.m[1][2]*pt[0].x[2];
			pt[1].wx[0] = Scaling.m[0][0]*pt[1].x[0] + Scaling.m[0][2]*pt[1].x[2];
			pt[1].wx[1] = Scaling.m[1][1]*pt[1].x[1] + Scaling.m[1][2]*pt[1].x[2];
		
			npts[0]=(int)(pt[0].wx[0]/pt[0].wx[2]);
			npts[1]=resy-(int)(pt[0].wx[1]/pt[0].wx[2]);
			
			npts[2]=(int)(pt[1].wx[0]/pt[1].wx[2]);
			npts[3]=resy-(int)(pt[1].wx[1]/pt[1].wx[2]);
			
			G_line(&npts[0],&npts[2],6);
		}

	}

}
void C3DWnd::ResetView(void) 
{
	CMedDLeDoc* pDoc = GetDocument();
}

CMedDLeDoc* C3DWnd::GetDocument()
{
	return theApp.m_pActiveDoc;

}

void C3DWnd::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc=GetDocument();
	if ((!LeftStart) && !(nFlags&MK_LBUTTON)){
		MovingEye=TRUE;
		RightStart=TRUE;
		LeftClean=FALSE;
		RightClean=FALSE;
		SetCapture();
		NoMotion=0;
		OldPoint=point;
	} else{
		ClickPoint=point;
//		oldlight=pDoc->light_ray;
		RotatingEye=FALSE;
		RotatingLight=TRUE;
	}
}

void C3DWnd::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CMedDLeDoc *pDoc=GetDocument();
	if (RightStart){
		RightStart=FALSE;
		if (!(nFlags&MK_LBUTTON) && (GetCapture()==this)){
			ReleaseCapture();
//			if (NoMotion==0){
//				CMenu menu;
//				if (menu.LoadMenu(IDR_POPUPS)){
//					CMenu* pPopup = menu.GetSubMenu(0);
//					ASSERT(pPopup != NULL);
//					ClientToScreen(&point);
//					pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, AfxGetMainWnd());
//				}
//			}
		} else if (nFlags&MK_LBUTTON) LeftClean=TRUE;
		MovingEye=FALSE;
	} else{
		RotatingEye=TRUE;
//		oldsit=pDoc->sit;
		ClickPoint=point;
		RotatingLight=FALSE;
	}
	if (RightClean==TRUE) if (GetCapture()==this) ReleaseCapture();
	RightClean=FALSE;
	CWnd::OnRButtonUp(nFlags, point);
}

void C3DWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	FullScreen(0);

//	if(nChar==VK_ESCAPE)
//	{
//		AfxMessageBox("Boiing");
//	}
	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void C3DWnd::OnEscapepressed() 
{
	FullScreen(0);
	
}

BOOL C3DWnd::PreTranslateMessage(MSG* pMsg) 
{
//		FullScreen(0);

	if((pMsg->message==WM_KEYDOWN)&&(m_bFullScreen))
	{
//		FullScreen(0);

	}
	
	return CWnd::PreTranslateMessage(pMsg);
}

BOOL C3DWnd::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{

	//	FullScreen(0);
	
	return CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

BOOL C3DWnd::OnCommand(WPARAM wParam, LPARAM lParam) 
{

	MessageBeep(MB_OK);
	return CWnd::OnCommand(wParam, lParam);
}
