// 2DView.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "MedDLeGFX\MedDLeGFX.h"
//#include "MedDLeGFX.h"		// Our added graphics routines
#include "MedDLeEdit.h"		// Our added graphics routines
#include "ChildFrm.h"
#include "2DView.h"
//#include "ViewActions.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
#define A_NULL 0
#define A_LZOOM 1
#define A_RZOOM 2
#define A_LSCALE 3
#define A_RSCALE 4
#define A_LROTATE 5
#define A_RROTATE 6
#define A_LTRANS 7
#define A_RTRANS 8
#define A_MOVETRI 9
#define A_SNAPTRI 10
#define A_STARTTRI 11
#define A_SNAPTRANS 12
#define A_MOVEBONE 13
#define A_PICKBONE 14
*/
/////////////////////////////////////////////////////////////////////////////
// C2DView

IMPLEMENT_DYNCREATE(C2DView, CView)

C2DView::C2DView()
{
	m_ViewAction=VA_NULL;

	m_bLStarted=0;
	m_bRStarted=0;
	m_bMotion=0;
}

C2DView::~C2DView()
{
}

BEGIN_MESSAGE_MAP(C2DView, CView)
	//{{AFX_MSG_MAP(C2DView)
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDBLCLK()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_VIEW_IN, OnViewIn)
	ON_COMMAND(ID_VIEW_OUT, OnViewOut)
	ON_UPDATE_COMMAND_UI(ID_VIEW_IN, OnUpdateViewIn)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OUT, OnUpdateViewOut)
	ON_COMMAND(ID_VIEW_SOLID, OnViewSolid)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SOLID, OnUpdateViewSolid)
	ON_COMMAND(ID_VIEW_VERTS, OnViewVerts)
	ON_UPDATE_COMMAND_UI(ID_VIEW_VERTS, OnUpdateViewVerts)
	ON_COMMAND(ID_ADDSELBONE, OnAddselbone)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// C2DView drawing

void C2DView::OnDraw(CDC* pDC)
{
    CRect rc;
    GetClientRect(&rc);
	float w = (float)rc.right;
	float h = (float)rc.bottom;
//	AfxMessageBox("Draw");

	if((h==0)||(w==0)) return;

	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	
	int iv1[2], iv2[2];
	int view=ViewNum;

	MedDLeBeginDraw(pDC, rc, AppColors[AC_2DBACK]);

	// this is the width, height (resolution)
	int resx, resy; 
	resx=MedDLeCDCResX;
	resy=MedDLeCDCResY;

		
	// new scale variable taking into account the zoom
	float zoomedscale;
	zoomedscale=pDoc->Scale*pDoc->Zoom[view];

	//centers of window, view area must coincide
	float offset[2];
	offset[0]=pDoc->Center[view][0];
	offset[1]=pDoc->Center[view][1];
	// figure out direction of axis and correct for it
	int xc,yc;
	xc = rc.right/2;
	yc = rc.bottom/2;

	long v1,v2,x1,x2,y1,y2;
	float fl,fr,ft,fb;
	int i,j,k,l;

	// -----------------------
	// draw background

	// Draw 2D grid
	if(pDoc->m_Grid.bVisible)
	{
		float s;

		fl=(rc.left-xc)/(zoomedscale*pDoc->AxisDir[view][0]) + offset[0];
		fr=(rc.right-xc)/(zoomedscale*pDoc->AxisDir[view][0]) + offset[0];
		ft=(rc.top-yc)/(zoomedscale*pDoc->AxisDir[view][1]) + offset[1];
		fb=(rc.bottom-yc)/(zoomedscale*pDoc->AxisDir[view][1]) + offset[1];
		float tmp;
		if(fl>fr) {tmp=fr; fr=fl; fl=tmp;}
		if(fb>ft) {tmp=ft; ft=fb; fb=tmp;}
		
		float pos;

		float kicker;
		kicker=fl/pDoc->m_Grid.fSpacing;
		int k;
		k=(int)kicker;
		kicker=fabs(kicker-k);

		if(fl>0) kicker=-kicker;

		s=fr-fl;
		pos=fl+kicker*pDoc->m_Grid.fSpacing;
		// axis 0
		float toosmall=pDoc->m_Grid.fSpacing*zoomedscale;
		if(toosmall > 1.0)
		{
			for(i=0; pos<=fr; i++)
			{
				x1 = xc+(pos-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
				x2 = x1;//xc+(pos-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
				y1 = rc.top;
				y2 = rc.bottom;
				iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
				MedDLeDrawLine(iv1, iv2, AppColors[AC_GRID]);
				pos+=pDoc->m_Grid.fSpacing;

			}
		
			// axis 1
			kicker=fb/pDoc->m_Grid.fSpacing;
			//kicker=fabs(kicker);
			k=(int)kicker;
			kicker=fabs(kicker-k);
			if(fb>0) kicker=-kicker;

			s=ft-fb;
			pos=fb+kicker*pDoc->m_Grid.fSpacing;
			for(i=0; pos<=ft; i++)
			{
				x1 = rc.left;
				x2 = rc.right;
				y1 = yc+(pos-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
				y2 = y1;//yc+(pos-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
				iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
				MedDLeDrawLine(iv1, iv2, AppColors[AC_GRID]);
				pos+=pDoc->m_Grid.fSpacing;

			}
		}
	}
	// Draw 2d axis
	if(pDoc->m_Grid.bAxis)
	{

		// axis 0
		x1 = xc+(0-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		x2 = xc+(0-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = rc.top;
		y2 = rc.bottom;
		iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
		MedDLeDrawLine(iv1, iv2, AppColors[AC_AXIS]);
		// axis 1
		x1 = rc.left;
		x2 = rc.right;
		y1 = yc+(0-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		y2 = yc+(0-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
		MedDLeDrawLine(iv1, iv2, AppColors[AC_AXIS]);


	}

		//int cg=pDoc->cur.grid;
//		x1 = xc+(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
//		x2 = xc+(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
//		y1 = yc+(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
//		y2 = yc+(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);

		//char st[40];
		//itoa(pDoc->Grids[0].steps[view], st, 10);
		//AfxMessageBox(st);
//		for(int i=0; i<pDoc->Grids[cg].lines[view]; i++)
//		{
//			v1 = pDoc->Grids[cg].sl[view][i][0];
//			v2 = pDoc->Grids[cg].sl[view][i][1];
//			x1 = xc+(pDoc->Grids[cg].fv[view][v1][0]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
//			x2 = xc+(pDoc->Grids[cg].fv[view][v2][0]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
//			y1 = yc+(pDoc->Grids[cg].fv[view][v1][1]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
//			y2 = yc+(pDoc->Grids[cg].fv[view][v2][1]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
//			iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
//			G_line(iv1, iv2, AppColors[AC_GRID]);
//		}

	
	int adir,asign;
	int axis1=pDoc->AxisMap[view][0], axis2=pDoc->AxisMap[view][1];

	CMedDLeFrame *mf;
	mf=pDoc->m_MedDLeObject.m_curFrame;

  if(mf)
  {

	// Draw Faces
	for(i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->f.GetSize(); i++)
	{

	}
	// Draw Lines
	for(i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->l.GetSize(); i++)
	{
		int vindex1, vindex2;
		vindex1=pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[0];
		vindex2=pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[1];

		if((pDoc->m_MedDLeObject.m_BaseFrame->v[vindex1].flags&V_VISIBLE) &&
			(pDoc->m_MedDLeObject.m_BaseFrame->v[vindex2].flags&V_VISIBLE))
		{
		iv1[0] = xc+(mf->v[ vindex1 ].x[axis1]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		iv1[1] = yc+(mf->v[ vindex1 ].x[axis2]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		
		iv2[0] = xc+(mf->v[ vindex2 ].x[axis1]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		iv2[1] = yc+(mf->v[ vindex2 ].x[axis2]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		
		if((pDoc->m_MedDLeObject.m_BaseFrame->v[ pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[0] ].flags&V_SELECTED || pDoc->m_MedDLeObject.m_BaseFrame->v[ pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[0] ].flags&V_TEMP_SELECTED)
			&&
			(pDoc->m_MedDLeObject.m_BaseFrame->v[ pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[1] ].flags&V_SELECTED || pDoc->m_MedDLeObject.m_BaseFrame->v[ pDoc->m_MedDLeObject.m_BaseFrame->l[i].vindex[1] ].flags&V_TEMP_SELECTED))	
		{
			MedDLeDrawLine(iv1, iv2, 250);
		}
		else MedDLeDrawLine(iv1, iv2, pDoc->m_MedDLeObject.m_BaseFrame->l[i].color);
		}
	}

	// draw bones
	for(i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->b.GetSize(); i++)
	{
		CMedDLeBone *b;
		b=&pDoc->m_MedDLeObject.m_BaseFrame->b[i];
		if(b->flags&B_VISIBLE)
		{
			iv1[0] = xc+(b->head.x[axis1]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			iv1[1] = yc+(b->head.x[axis2]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		
			iv2[0] = xc+(b->tail.x[axis1]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			iv2[1] = yc+(b->tail.x[axis2]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		
			MedDLeDrawLargeDot(iv1, 0);
			MedDLeDrawLargeDot(iv2, 250);
			MedDLeDrawLine(iv1, iv2, 0);
		}
	}
  }
	// Draw selection Box
	if((theApp.m_AppAction==AA_SELECT) &&(pDoc->ActiveView==view))
	{
		if((pDoc->m_ptSelection0.x!=pDoc->m_ptSelection1.x)&&
			(pDoc->m_ptSelection0.y!=pDoc->m_ptSelection1.y))
		{
		int t[8];
		int x0,x1,y0,y1;
		
		if(pDoc->m_ptSelection0.x<pDoc->m_ptSelection1.x)
		{ x0=pDoc->m_ptSelection0.x; x1=pDoc->m_ptSelection1.x;}
		else
		{ x1=pDoc->m_ptSelection0.x; x0=pDoc->m_ptSelection1.x;}
		if(pDoc->m_ptSelection0.y<pDoc->m_ptSelection1.y)
		{ y0=pDoc->m_ptSelection0.y; y1=pDoc->m_ptSelection1.y;}
		else
		{ y1=pDoc->m_ptSelection0.y; y0=pDoc->m_ptSelection1.y;}


		t[0] = x0;
		t[1] = rc.bottom-y0;
		t[2] = x0;
		t[3] = rc.bottom-y1;
		MedDLeDrawLine(t, &t[2], 0);
		t[0] = x0;
		t[1] = rc.bottom-y1;
		t[2] = x1;
		t[3] = rc.bottom-y1;
		MedDLeDrawLine(t, &t[2], 0);
		t[0] = x1;
		t[1] = rc.bottom-y1;
		t[2] = x1;
		t[3] = rc.bottom-y0;
		MedDLeDrawLine(t, &t[2], 0);
		t[0] = x1;
		t[1] = rc.bottom-y0;
		t[2] = x0;
		t[3] = rc.bottom-y0;
		MedDLeDrawLine(t, &t[2], 0);
		}
	}

  if(mf)
  {
	// Draw vertex dots
	for(i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
	{
		if(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE)
		{
			iv1[0] = xc+(mf->v[i].x[axis1]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			iv1[1] = yc+(mf->v[i].x[axis2]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
					
			if((pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_SELECTED)
				||(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_TEMP_SELECTED))
				MedDLeDrawMediumDot(iv1, 250);
			else
				MedDLeDrawSmallDot(iv1, 0);
		}
	}

  }



/*
	asign = -1;
	//if (pDoc->Vflags[view] & R_FB) asign=1;

	for(i=0; i<3; i++)
	{
		if((pDoc->AxisMap[view][1]!=i)&&(pDoc->AxisMap[view][0]!=i)) adir=i;
	}
		
	float norm[3];
	for(k=0; k <pDoc->num.triangles ; k++)
	{
		xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[0]].v[adir];
		for(l=1; l < 3; l++)
		{
			if(asign==1) {if(pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir] < xlist[k]) xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir];}
			else {if(pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir] > xlist[k]) xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir];}
		}
		xindexlist[k]=k;
	}
			
		// now sort polys by furthest point (or closest?)
		sort(xlist,xindexlist,0,pDoc->num.triangles-1);
		int t[8];
		int vi[3];
		int si;
		for(i=0; i<pDoc->num.triangles; i++)
		{	
			if(asign==1) si=xindexlist[i];
			else si=xindexlist[pDoc->num.triangles-i-1];
			if (!(pDoc->Tris[si].Vflags&O_VHIDDEN)) {
				//si=i;
				for(j=0; j<3; j++)
				{
					vi[j]=pDoc->Tris[si].vindex[j];
					t[j*2]=xc+(pDoc->cur.frameptr->fv[pDoc->Tris[si].vindex[j]].v[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
					t[j*2+1]=yc+(pDoc->cur.frameptr->fv[pDoc->Tris[si].vindex[j]].v[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
				}
				t[6]=t[0];
				t[7]=t[1];
				//G_transparent_ambient_polygon(t,3,46);
				//G_hilight_polygon(t, 3, 34);
				if (pDoc->Vflags[view]&R_SOLID) 
				{
					// find normal.
			//		pDoc->GetNormal(pDoc->cur.frameptr,si,norm);
			//		if(norm[adir]>0)
						G_ambient_polygon(t, 3, 42);
			//		else
			//			G_ambient_polygon(t, 3,241);
				}
				G_line(&t[0], &t[2], pDoc->Tris[si].color[0]);
				G_line(&t[2], &t[4], pDoc->Tris[si].color[1]);
				G_line(&t[4], &t[0], pDoc->Tris[si].color[2]);
				if (pDoc->Vflags[view]&R_VERT) {
					int color;
					for(j=0; j<3; j++)
					{
						color=0;
						if (pDoc->Verts[pDoc->Tris[si].vindex[j]].flags & O_VSELECTED) {color=251; G_meddot(&t[j*2], color);}
						if (pDoc->Verts[pDoc->Tris[si].vindex[j]].flags & O_DRAW_BLUE) {color=208; G_meddot(&t[j*2], color);}
						else G_smalldot(&t[j*2], color);
					}
				}
			}
		}
		x1 = xc+(pDoc->cur.frameptr->fbboxmin.v[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->cur.frameptr->fbboxmin.v[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 0);
		G_xdot(iv1, 15);
		x1 = xc+(pDoc->cur.frameptr->fbboxmin.v[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->cur.frameptr->fbboxmax.v[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 0);
		G_xdot(iv1, 15);
		x1 = xc+(pDoc->cur.frameptr->fbboxmax.v[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->cur.frameptr->fbboxmax.v[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 0);
		G_xdot(iv1, 15);
		x1 = xc+(pDoc->cur.frameptr->fbboxmax.v[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->cur.frameptr->fbboxmin.v[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 0);
		G_xdot(iv1, 15);
		x1 = xc+(pDoc->boxmin[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->boxmin[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 251);
		G_xdot(iv1, 254);
		x1 = xc+(pDoc->boxmin[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->boxmax[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 251);
		G_xdot(iv1, 254);
		x1 = xc+(pDoc->boxmax[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->boxmax[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 251);
		G_xdot(iv1, 254);
		x1 = xc+(pDoc->boxmax[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->boxmin[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1;
		G_bigdot(iv1, 251);
		G_xdot(iv1, 254);

	}
	// draw rotation axis
	if(theApp.m_AppAction==AA_ROTATE)
	{
		x1 = xc+(pDoc->RotHead[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		x2 = xc+(pDoc->RotTail[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
		y1 = yc+(pDoc->RotHead[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		y2 = yc+(pDoc->RotTail[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
		iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
		G_line(iv1, iv2, 208);
		if(pDoc->RotHSel) G_bigdot(iv1, 251);
		else G_bigdot(iv1, 208);
		if(pDoc->RotTSel) G_bigdot(iv2, 251);
		else G_bigdot(iv2, 208);
		G_meddot(iv1, 0);
		G_meddot(iv2, 254);
	}
	if(pDoc->TriAdd==TRUE){
		int ii=0, newtri[8];
		for(int i=0; i<3; i++){
			x1=xc+(pDoc->Triloc[i][pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			x2=xc+(pDoc->Triloc[(i+1)%3][pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			y1=yc+(pDoc->Triloc[i][pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
			y2=yc+(pDoc->Triloc[(i+1)%3][pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
			iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
			newtri[ii++]=x1;
			newtri[ii++]=y1;
		}
		newtri[ii++]=newtri[0];
		newtri[ii++]=newtri[1];
		G_colored_glass_polygon(newtri,3,0,33);
		G_line(&newtri[0], &newtri[2], 208);
		G_line(&newtri[2], &newtri[4], 208);
		G_line(&newtri[4], &newtri[0], 208);
		G_meddot(&newtri[0], 208);
		G_meddot(&newtri[2], 208);
		G_meddot(&newtri[4], 208);

	}
	// draw bones
	if(pDoc->EditMode==SM_SKEL)
	{	
		int b[4];
		// draw all bones
		for(int i=0; i<pDoc->Skeleton.cnt; i++)
		{
			x1 = xc+(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			x2 = xc+(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[view][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[view][0]);
			y1 = yc+(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
			y2 = yc+(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[view][1]]-offset[1])*(zoomedscale*pDoc->AxisDir[view][1]);
			iv1[0] = x1; iv1[1] = y1; iv2[0] = x2; iv2[1] = y2;
			int c;
			c=255;
			if((pDoc->SkelAction==BA_PICKCURPARENT)||(pDoc->SkelAction==BA_PICKPARENT))
			{
				if(i==pDoc->curParentBone) c=251;
			
			}
			//if(pDoc->SkelOptions&BO_MOVECHILD)
			//{

			//}
			G_line(iv1, iv2, c);
			if(pDoc->Skeleton.hflags[i]&O_SELECTED) G_bigdot(iv1, 251);
			else G_bigdot(iv1, 208);
			if(pDoc->Skeleton.tflags[i]&O_SELECTED) G_bigdot(iv2, 251);
			else G_bigdot(iv2, 208);
			G_meddot(iv1, 0);
			G_meddot(iv2, 254);
			
		}
	}
	*/

	MedDLeEndDraw();
	
	
	MedDLeBeginOverlay(pDC);
	// -----------------------
	// draw overlays

	// draw axis indicator
	if(1)
	{
		x1 = 6;
		x2 = 26;
		y1 = rc.bottom-6;
		y2 = rc.bottom-26;
		COLORREF c0=0,c1=0;
		// x = red
		// y = green
		// z = blue

		switch (pDoc->AxisMap[view][0])
		{
		case 0: c0=RGB(255,0,0); break;
		case 1: c0=RGB(0,255,0); break;
		case 2: c0=RGB(0,0,255); break;
		}
		switch (pDoc->AxisMap[view][1])
		{
		case 0: c1=RGB(255,0,0); break;
		case 1: c1=RGB(0,255,0); break;
		case 2: c1=RGB(0,0,255); break;
		}
//		if(pDoc->AxisMap[view][0]==0) 
//		c0=AppColors[pDoc->AxisMap[view][0]+AC_XAXIS];
//		c1=AppColors[pDoc->AxisMap[view][1]+AC_XAXIS];

		iv1[0] = x1; iv1[1] = y1; iv2[0] = x1; iv2[1] = y2-1;
		MedDLeOverlayLine(iv1, iv2, c1,1,0);
		pDC->SetPixel(x1-1, y2+1, c1);
		pDC->SetPixel(x1+1, y2+1, c1);
		pDC->SetPixel(x1-2, y2+2, c1);
		pDC->SetPixel(x1+2, y2+2, c1);
//
//		iv1[0] = x1-1; iv1[1] = y2-1;
//		MedDLeDrawPoint(iv1, c1);
//		iv1[0] = x1+1; iv1[1] = y2-1;
//		MedDLeDrawPoint(iv1, c1);
//		iv1[0] = x1-2; iv1[1] = y2-2;
//		MedDLeDrawPoint(iv1, c1);
//		iv1[0] = x1+2; iv1[1] = y2-2;
//		MedDLeDrawPoint(iv1, c1);

		
		iv1[0] = x1; iv1[1] = y1; iv2[0] = x2+1; iv2[1] = y1;
		MedDLeOverlayLine(iv1, iv2, c0,1,0);

		pDC->SetPixel(x2-1, y1-1, c0);
		pDC->SetPixel(x2-1, y1+1, c0);
		pDC->SetPixel(x2-2, y1+2, c0);
		pDC->SetPixel(x2-2, y1-2, c0);
//		iv1[0] = x2-1; iv1[1] = y1-1;
//		MedDLeDrawPoint(iv1, c0);
//		iv1[0] = x2-1; iv1[1] = y1+1;
//		MedDLeDrawPoint(iv1, c0);
//		iv1[0] = x2-2; iv1[1] = y1-2;
//		MedDLeDrawPoint(iv1, c0);
//		iv1[0] = x2-2; iv1[1] = y1+2;
//		MedDLeDrawPoint(iv1, c0);

	}
	pDC->SetBkMode(TRANSPARENT);
//	pDC->TextOut(0,0,"MedDLe");
//	iv1[0] = 0; iv1[1] = 0; iv2[0] = 10; iv2[1] = 10;
//	MedDLeOverlayLine(iv1, iv2, RGB(0,255,0),1, 0);
	MedDLeEndOverlay();


	//AfxMessageBox("DrawView Finish");
//}
	
	
//	DrawView(pDoc, pDC, rc, ViewNum);
}

/////////////////////////////////////////////////////////////////////////////
// C2DView diagnostics

#ifdef _DEBUG
void C2DView::AssertValid() const
{
	CView::AssertValid();
}

void C2DView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// C2DView message handlers

void C2DView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();

	CRect rc;
	GetClientRect(&rc);


	if (nFlags&MK_LBUTTON)
		return;

	m_bMotion=0;

	m_ViewAction=VA_NULL;

	// chek for quick scale/zoom
	if (nFlags&MK_CONTROL) 
	{
		m_ViewAction=VA_ZOOM;
		SetCapture();
		pDoc->ActiveView=ViewNum;
		m_ptClicked=point;
		m_ptOld=point;
		return;
	}
		
		
	switch(theApp.m_AppAction)
	{

	case AA_ZOOM:
		m_ViewAction=VA_ZOOM;
		break;
	case AA_SCALE:
		m_ViewAction=VA_SCALE;
		break;
	case AA_SELECT:
		pDoc->m_ptSelection0=point;
		pDoc->m_ptSelection1=point;

	//	m_ViewAction=VA_SELECT;

	/*	PClicked = OnPoint(pDoc, rc, point, ViewNum);
		if (PClicked != -1) 
			if (pDoc->Verts[PClicked].flags & O_VHIDDEN) 
				PClicked = -1;
		if (PClicked != -1)
		{
			m_ViewAction=VA_SNAPTRANS;
			PMapped=-1;
			pDoc->Verts[PClicked].flags |= O_DRAW_BLUE;
			pDoc->ClearBlue=FALSE;
			pDoc->ColorSort();
			pDoc->ClearBlue=TRUE;
			pDoc->UpdateAllViews(NULL);
		} 
		//else if(pDoc->EditMode!=SM_SKEL) m_ViewAction=VA_STARTTRI;
				//Shift will be used for a triangle selection
*/
		break;
	default:
		m_ViewAction=VA_NULL;

	}
	SetCapture();
	pDoc->ActiveView=ViewNum;
	m_ptClicked=point;
	m_ptOld=point;
	

		//		else
//		{
//			switch(theApp.m_AppAction)
//			{
//				case AA_ROTATE
//			}
//
//		}

/*		else if (theApp.m_AppAction==AA_ROTATE)
		{
			m_ViewAction=VA_ROTATE;
			for (int i=0; i<pDoc->num.vertices; i++)
			{ 
				if (pDoc->Verts[i].flags & O_VSELECTED) 
					pDoc->Verts[i].flags |= O_DRAW_BLUE; 
			}
			pDoc->ClearBlue=FALSE;
			pDoc->ColorSort();
			pDoc->ClearBlue=TRUE;
		} 
		else if (theApp.m_AppAction==AA_SCALE)
		{
			m_ViewAction=VA_SCALE;
			for (int i=0; i<pDoc->num.vertices; i++){ if (pDoc->Verts[i].flags & O_VSELECTED) pDoc->Verts[i].flags |= O_DRAW_BLUE; }
			pDoc->ClearBlue=FALSE;
			pDoc->ColorSort();
			pDoc->ClearBlue=TRUE;
		} 
		else if (theApp.m_AppAction==AA_SELECT)
		{
			if (pDoc->TriAdd)
			{
				float zoomedscale;
				zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
				int xc,yc;
				xc = rc.right/2;
				yc = rc.bottom/2;
				float offset[2];
				offset[0]=pDoc->Center[ViewNum][0];
				offset[1]=pDoc->Center[ViewNum][1];
				int trint[2];
				float tridist[3];
				float tridif[2];
				float dist;
				int iv1[2];
				char st[40];
				for(int i=0; i<3; i++)
				{
					trint[0]=xc+(pDoc->Triloc[i][pDoc->AxisMap[ViewNum][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[ViewNum][0]);
					trint[1]=yc+(pDoc->Triloc[i][pDoc->AxisMap[ViewNum][1]]-offset[1])*(zoomedscale*-pDoc->AxisDir[ViewNum][1]);
					tridif[0]=point.x-trint[0];
					tridif[1]=point.y-trint[1];
					tridist[i] = (tridif[0]*tridif[0])+(tridif[1]*tridif[1]);
				}
				dist=tridist[2];
				int cvert=2;
				for(i=0; i<2; i++){
					if (tridist[i]<dist) 
					{
						dist=tridist[i];
						cvert=i;
					}
				}
				if (dist > 36)
				{
					PClicked=-1;
					m_ViewAction=VA_SELECT;
				} 
				else 
				{
					PClicked=cvert;
					m_ViewAction=VA_SNAPTRI;
				}
			} 
			else 
			{
				PClicked = OnPoint(pDoc, rc, point, ViewNum,this);
				if (PClicked != -1) if (pDoc->Verts[PClicked].flags & O_VHIDDEN) PClicked = -1;
				if (PClicked != -1){
					m_ViewAction=VA_SNAPTRANS;
					PMapped=-1;
					pDoc->Verts[PClicked].flags |= O_DRAW_BLUE;
					pDoc->ClearBlue=FALSE;
					pDoc->ColorSort();
					pDoc->ClearBlue=TRUE;
					pDoc->UpdateAllViews(NULL);
				} 
				else if(pDoc->EditMode!=SM_SKEL) m_ViewAction=VA_STARTTRI;
				//Shift will be used for a triangle selection
			}
		}
*/		//m_bLStarted
		//RightStart=TRUE;
		//LeftClean=FALSE;
//		//RightClean=FALSE;
//		SetCapture();
//		m_ptOld=point;
//		m_ptClicked=point;
//	}
}                    

void C2DView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);
	
	int i,j;

	// if 2 buttons
	if (nFlags&MK_RBUTTON)
		return;

	// set no motion
	m_bMotion=0;
	
	// if ctrl down
	if (nFlags&MK_CONTROL) 
	{
		m_ViewAction=VA_ZOOM;
		SetCapture();
		pDoc->ActiveView=ViewNum;
		m_ptClicked=point;
		m_ptOld=point;
		return;
	}

	switch(theApp.m_AppAction)
	{

	case AA_ZOOM:
		m_ViewAction=VA_ZOOM;
		break;
	case AA_SCALE:
		m_ViewAction=VA_SCALE;
		break;
	case AA_SELECT:
		m_ViewAction=VA_SELECT;
		pDoc->m_ptSelection0=point;
		pDoc->m_ptSelection1=point;
		m_bHittingVert=0;
		if(theApp.m_AppMode==AM_VERT)
		{
			//int vindex;
			m_nLastHitIndex=HitPointIndex(point);
			if(m_nLastHitIndex!=-1) 
			{
				m_bHittingVert=1;
				pDoc->m_MedDLeObject.m_BaseFrame->v[m_nLastHitIndex].flags|=V_TEMP_SELECTED;
			}
		}
		else if	(theApp.m_AppMode==AM_GROUP)
		{
			CArray <int,int> gs;
			gs.RemoveAll();
			// if that vert is in group, select all of group
			for(int k=0; k<pDoc->m_MedDLeObject.m_BaseFrame->f.GetSize(); k++)
			{
				for(int l=0; l<3; l++)
				{
					int vindex;
					vindex = pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[l];

					if(vindex == m_nLastHitIndex)
					{
						int gg=pDoc->m_MedDLeObject.m_BaseFrame->f[k].group;
						BOOL add=TRUE;
						for(int m=0; m<gs.GetSize(); m++)
						{
							if(gg==gs[m]) 
							{
								add=FALSE;break;
							}
						}
						if(add)	gs.Add(gg);
					}
				}
			}

			if(gs.GetSize()>0)
			{
				for(k=0; k<pDoc->m_MedDLeObject.m_BaseFrame->f.GetSize(); k++)
				{
					for(int m=0; m<gs.GetSize(); m++)
					{
						int gg=pDoc->m_MedDLeObject.m_BaseFrame->f[k].group;
						if(gg == gs[m])
						{

							for(int l=0; l<3; l++)
							{
								int vindex;
								vindex = pDoc->m_MedDLeObject.m_BaseFrame->f[k].vindex[l];
								pDoc->m_MedDLeObject.m_BaseFrame->v[vindex].flags|=V_TEMP_SELECTED;
							}
						}
					}
				}
			}
			gs.RemoveAll();
		}
		pDoc->UpdateAllViews(NULL);
	
		break;
	default:
		m_ViewAction=VA_NULL;

	}
	SetCapture();
	pDoc->ActiveView=ViewNum;
	m_ptClicked=point;
	m_ptOld=point;

		/*	case AA_SCALE:
		m_ViewAction=VA_SCALE;
		for (i=0; i<pDoc->Verts.GetSize(); i++)
		{ 
			if (pDoc->Verts[i].flags & O_VSELECTED) 
				pDoc->Verts[i].flags |= O_DRAW_BLUE; 
		}
		pDoc->ClearBlue=FALSE;
		pDoc->ColorSort();
		pDoc->ClearBlue=TRUE;
		pDoc->UpdateAllViews(NULL);
		break;
	case AA_SELECT:
		if(pDoc->EditMode!=SM_SKEL)
		{

		}
*/
/*	default:
		m_ViewAction=VA_NULL;

	}
	SetCapture();
	m_ptClicked=point;
	m_ptOld=point;

	//

	/*		
else if ((theApp.m_AppAction==AA_SELECT)&&(pDoc->EditMode!=SM_SKEL))
		{
			if (pDoc->TriAdd){
				float zoomedscale;
				zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
				int xc,yc;
				xc = rc.right/2;
				yc = rc.bottom/2;
				float offset[2];
				offset[0]=pDoc->Center[ViewNum][0];
				offset[1]=pDoc->Center[ViewNum][1];
				int trint[2];
				float tridist[3];
				float tridif[2];
				float dist;
				int iv1[2];
				char st[40];
				for(int i=0; i<3; i++){
					trint[0]=xc+(pDoc->Triloc[i][pDoc->AxisMap[ViewNum][0]]-offset[0])*(zoomedscale*pDoc->AxisDir[ViewNum][0]);
					trint[1]=yc+(pDoc->Triloc[i][pDoc->AxisMap[ViewNum][1]]-offset[1])*(zoomedscale*-pDoc->AxisDir[ViewNum][1]);
					
					tridif[0]=point.x-trint[0];
					tridif[1]=point.y-trint[1];
					
					tridist[i] = (tridif[0]*tridif[0])+(tridif[1]*tridif[1]);
				}
				dist=tridist[2];
				int cvert=2;
				for(i=0; i<2; i++){
					if (tridist[i]<dist) {
						dist=tridist[i];
						cvert=i;
					}
				}
				if (dist > 36){
					PClicked=-1;
					m_ViewAction=VA_SELECT;
				} else {
					PClicked=cvert;
					m_ViewAction=VA_MOVETRI;
				}
			} 
			else if (pDoc->Verts.GetSize()>0)
			{
				int i, cnt, j;
				IsSelected=FALSE;
				if (pDoc->EditMode==SM_VERT){
					PClicked = OnPoint(pDoc, rc, point, ViewNum);
					if (PClicked != -1) 
						if (pDoc->Verts[PClicked].flags&O_VHIDDEN) 
							PClicked = -1;
					if (PClicked != -1) 
						if (pDoc->Verts[PClicked].flags&O_SELECTED) 
							IsSelected=TRUE;
				} 
				else if ((pDoc->EditMode==SM_TRI) || (pDoc->EditMode==SM_GROUP) || (pDoc->EditMode==SM_OBJECT))
				{


					TriHit(point);
					cnt=pDoc->HitIndex.GetSize();
					if (cnt==0) {
						j=0;
						PClicked=-1;
						ObjN=-1;
						GrpN=-1;
					} else {
						j=cnt-1;
						PClicked=pDoc->HitIndex.GetAt(j);
						ObjN=pDoc->Verts[pDoc->Tris[PClicked].vindex[0]].object;
						GrpN=pDoc->Verts[pDoc->Tris[PClicked].vindex[0]].group;
						if (GrpN!=pDoc->Verts[pDoc->Tris[PClicked].vindex[1]].group) 
							GrpN=0;
						else if (GrpN!=pDoc->Verts[pDoc->Tris[PClicked].vindex[2]].group) 
							GrpN=0;
						if (pDoc->EditMode==SM_TRI)
						{
							if (pDoc->Tris[PClicked].Vflags&O_SELECTED) 
								IsSelected=TRUE;
						} 
						else if (pDoc->EditMode==SM_GROUP)
						{
							if (pDoc->Objects[ObjN].Groups[GrpN]->flags&O_SELECTED) 
								IsSelected=TRUE;
						}
						else if (pDoc->EditMode==SM_OBJECT)
						{
							if (pDoc->Objects[ObjN].flags&O_SELECTED) 
								IsSelected=TRUE;
						}
					}
				}
				m_ViewAction=VA_TRANSLATE;
				if (PClicked==-1) for (i=0; i<pDoc->Verts.GetSize(); i++){ if (pDoc->Verts[i].flags & O_VSELECTED) pDoc->Verts[i].flags |= O_DRAW_BLUE; }
				else {
					if (pDoc->EditMode==SM_VERT){
						pDoc->Verts[PClicked].flags |= O_DRAW_BLUE;
						if (nFlags&MK_SHIFT) {
							int j;
							for(i=0; i<pDoc->num.lines; i++){
								if (pDoc->Sort[i].vindex[0] == PClicked) {
									j = pDoc->Sort[i].vindex[1];
									pDoc->Verts[j].flags |= O_DRAW_BLUE;
								}
								if (pDoc->Sort[i].vindex[1] == PClicked) {
									j = pDoc->Sort[i].vindex[0];
									pDoc->Verts[j].flags |= O_DRAW_BLUE;
								} 
							}
						}
					} else if (pDoc->EditMode==SM_TRI){
						pDoc->Verts[pDoc->Tris[PClicked].vindex[0]].flags |= O_DRAW_BLUE;
						pDoc->Verts[pDoc->Tris[PClicked].vindex[1]].flags |= O_DRAW_BLUE;
						pDoc->Verts[pDoc->Tris[PClicked].vindex[2]].flags |= O_DRAW_BLUE;
					} else if (pDoc->EditMode==SM_GROUP){
						for (i=0; i<pDoc->Verts.GetSize(); i++){
							if ((pDoc->Verts[i].object==ObjN) && (pDoc->Verts[i].group==GrpN)) pDoc->Verts[i].flags |= O_DRAW_BLUE;
						}
					} else if (pDoc->EditMode==SM_OBJECT){
						for (i=0; i<pDoc->Verts.GetSize(); i++){
							if (pDoc->Verts[i].object==ObjN) pDoc->Verts[i].flags |= O_DRAW_BLUE;
						}
					}
				}
				pDoc->ClearBlue=FALSE;
				pDoc->ColorSort();
				pDoc->ClearBlue=TRUE;
				pDoc->UpdateAllViews(NULL);
			}
		} else if(theApp.m_AppAction==AA_ROTATE){
			m_ViewAction=VA_ROTATE;
			pDoc->RotHSel=FALSE;
			pDoc->RotTSel=FALSE;
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			double p[2], q[2];
			p[0] = ((point.x+pDoc->AxisDir[ViewNum][0]*3-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			p[1] = ((point.y-pDoc->AxisDir[ViewNum][1]*3-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
			q[0] = ((point.x-pDoc->AxisDir[ViewNum][0]*3-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			q[1] = ((point.y+pDoc->AxisDir[ViewNum][1]*3-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
		
			if((pDoc->RotHead[pDoc->AxisMap[ViewNum][0]] < p[0])&&(pDoc->RotHead[pDoc->AxisMap[ViewNum][0]] > q[0])
				&&(pDoc->RotHead[pDoc->AxisMap[ViewNum][1]] < p[1])&&(pDoc->RotHead[pDoc->AxisMap[ViewNum][1]] > q[1]))
			{pDoc->RotHSel=TRUE; if(nFlags&MK_SHIFT) pDoc->RotTSel=TRUE; }
			else if((pDoc->RotTail[pDoc->AxisMap[ViewNum][0]] < p[0])&&(pDoc->RotTail[pDoc->AxisMap[ViewNum][0]] > q[0])
				&&(pDoc->RotTail[pDoc->AxisMap[ViewNum][1]] < p[1])&&(pDoc->RotTail[pDoc->AxisMap[ViewNum][1]] > q[1]))
			{pDoc->RotTSel=TRUE; if(nFlags&MK_SHIFT) pDoc->RotHSel=TRUE; }

			pDoc->UpdateAllViews(NULL);
		}

		///////////// new bone stuff
		else if ((theApp.m_AppAction==AA_SELECT)&&(pDoc->EditMode==SM_SKEL))
		{
			//pDoc->RotHSel=FALSE;
			//pDoc->RotTSel=FALSE;
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			double p[2], q[2];
			p[0] = ((point.x+pDoc->AxisDir[ViewNum][0]*3-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			p[1] = ((point.y-pDoc->AxisDir[ViewNum][1]*3-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
			q[0] = ((point.x-pDoc->AxisDir[ViewNum][0]*3-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			q[1] = ((point.y+pDoc->AxisDir[ViewNum][1]*3-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
			// see if hit a bone
			int i, sel=0;
			for(i=0; i<pDoc->Skeleton.cnt; i++)
			{

				pDoc->Skeleton.hflags[i] &= ~O_SELECTED; 
				pDoc->Skeleton.tflags[i] &= ~O_SELECTED; 
				if((pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[ViewNum][0]] < p[0])&&(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[ViewNum][0]] > q[0])
					&&(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[ViewNum][1]] < p[1])&&(pDoc->cur.frameptr->bone[i].head[pDoc->AxisMap[ViewNum][1]] > q[1]))
				{
					pDoc->Skeleton.hflags[i]|=O_SELECTED; 
					if(nFlags&MK_SHIFT) pDoc->Skeleton.tflags[i]|=O_SELECTED; 
					sel=1;
					break;
				}
				else if((pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[ViewNum][0]] < p[0])&&(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[ViewNum][0]] > q[0])
					&&(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[ViewNum][1]] < p[1])&&(pDoc->cur.frameptr->bone[i].tail[pDoc->AxisMap[ViewNum][1]] > q[1]))
				{
					pDoc->Skeleton.tflags[i]|=O_SELECTED; 
					if(nFlags&MK_SHIFT) pDoc->Skeleton.hflags[i]|=O_SELECTED; 
					sel=1;
					break;
				}
			}
			// if delete bone (the flag movevto is used for reasons beyond me)
			if((pDoc->SkelAction==BA_MOVEVTO)&&(sel))
			{
				sel=0;
				if(pDoc->Skeleton.cnt>0)
				{
				for(int j=i; j<pDoc->Skeleton.cnt-1; j++)
				{
					pDoc->Skeleton.tflags[j]=pDoc->Skeleton.tflags[j+1];
					pDoc->Skeleton.hflags[j]=pDoc->Skeleton.hflags[j+1];
					pDoc->Skeleton.parentindex[j]=pDoc->Skeleton.parentindex[j+1];
					pDoc->Base->bone[j].head[0]=pDoc->Base->bone[j+1].head[0];
					pDoc->Base->bone[j].head[1]=pDoc->Base->bone[j+1].head[1];
					pDoc->Base->bone[j].head[2]=pDoc->Base->bone[j+1].head[2];
					pDoc->Base->bone[j].tail[0]=pDoc->Base->bone[j+1].tail[0];
					pDoc->Base->bone[j].tail[1]=pDoc->Base->bone[j+1].tail[1];
					pDoc->Base->bone[j].tail[2]=pDoc->Base->bone[j+1].tail[2];
					pDoc->Base->bone[j].length=pDoc->Base->bone[j+1].length;
					pDoc->Base->bone[j].twist=pDoc->Base->bone[j+1].twist;
					pDoc->MapGen->bone[j].head[0]=pDoc->MapGen->bone[j+1].head[0];
					pDoc->MapGen->bone[j].head[1]=pDoc->MapGen->bone[j+1].head[1];
					pDoc->MapGen->bone[j].head[2]=pDoc->MapGen->bone[j+1].head[2];
					pDoc->MapGen->bone[j].tail[0]=pDoc->MapGen->bone[j+1].tail[0];
					pDoc->MapGen->bone[j].tail[1]=pDoc->MapGen->bone[j+1].tail[1];
					pDoc->MapGen->bone[j].tail[2]=pDoc->MapGen->bone[j+1].tail[2];
					pDoc->MapGen->bone[j].length=pDoc->MapGen->bone[j+1].length;
					pDoc->MapGen->bone[j].twist=pDoc->MapGen->bone[j+1].twist;
					for(int k=0; k<pDoc->Frames.GetSize(); k++)
					{
						pDoc->Frames[k]->bone[j].head[0]=pDoc->Frames[k]->bone[j+1].head[0];
						pDoc->Frames[k]->bone[j].head[1]=pDoc->Frames[k]->bone[j+1].head[1];
						pDoc->Frames[k]->bone[j].head[2]=pDoc->Frames[k]->bone[j+1].head[2];
						pDoc->Frames[k]->bone[j].tail[0]=pDoc->Frames[k]->bone[j+1].tail[0];
						pDoc->Frames[k]->bone[j].tail[1]=pDoc->Frames[k]->bone[j+1].tail[1];
						pDoc->Frames[k]->bone[j].tail[2]=pDoc->Frames[k]->bone[j+1].tail[2];
						pDoc->Frames[k]->bone[j].length=pDoc->Frames[k]->bone[j+1].length;
						pDoc->Frames[k]->bone[j].twist=pDoc->Frames[k]->bone[j+1].twist;

					}
				}
				for(j=0; j<pDoc->Verts.GetSize(); j++)
				{
					if(pDoc->Verts[i].skel==i)
					{
						pDoc->Verts[i].skel=-1;
					
					}

					else if(pDoc->Verts[i].skel>i) 
					{
						pDoc->Verts[i].skel--;
					}

				}
				pDoc->Skeleton.cnt--;
				}

				pDoc->SkelAction=0;
			}
			if((sel)&&(pDoc->SkelOptions&BO_MOVECHILD))
			{
				pDoc->curChildBones.RemoveAll();
				pDoc->FindChildBones(i);
			}
			// set current parent
			if((pDoc->SkelAction==BA_PICKCURPARENT)&&(sel))
			{
				pDoc->curParentBone=i;
				pDoc->SkelAction=0;
			}
			// pick parent of this child
			if((pDoc->SkelAction==BA_PICKPARENT)&&(sel))
			{
				if((pDoc->curParentBone>=0)&&(pDoc->curParentBone!=i)) 
					pDoc->Skeleton.parentindex[i]=pDoc->curParentBone;
				pDoc->SkelAction=0;
			}

			if((pDoc->SkelAction==BA_DETACHBONE)&&(sel))
			{
				pDoc->Skeleton.parentindex[i]=-1;
				pDoc->SkelAction=0;
			}
				
			
			if((pDoc->SkelAction==BA_ADDVERTS)&&(sel))
			{

				for(int j=0; j<pDoc->Verts.GetSize(); j++)
				{
					if((pDoc->Verts[j].flags&O_SELECTED)&&!(pDoc->Verts[j].flags&O_HIDDEN)) 
					{ 
						pDoc->Verts[j].skel=i; 
						pDoc->Verts[j].flags&= ~O_SELECTED;
					}
				}
				pDoc->ColorSort();
				pDoc->SkelAction=0;
				pDoc->Skeleton.hflags[i] &= ~O_SELECTED; 
				pDoc->Skeleton.tflags[i] &= ~O_SELECTED; 

			}


			pDoc->UpdateAllViews(NULL);
			m_ViewAction=VA_MOVEBONE;

		}

		//LeftStart=TRUE;
  		//LeftClean=FALSE;
		//RightClean=FALSE;
		SetCapture();
		m_ptClicked=point;
		m_ptOld=point;
	}
	*/
}

void C2DView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);
	CDC *Context=GetDC();
	CMedDLeFrame *f=pDoc->m_MedDLeObject.m_curFrame;

	if (GetCapture() != this) return;

	if((abs(point.x-m_ptOld.x)>=1) ||(abs(point.x-m_ptOld.x)>=1) && !m_bMotion)
		m_bMotion=1;

	int i,j;
	// if no button down
	if(!((nFlags&MK_LBUTTON)||(nFlags&MK_RBUTTON))) return;

	switch(m_ViewAction)
	{
	case VA_ZOOM:
		if(nFlags&MK_LBUTTON)
		{
			float s=pDoc->Scale*pDoc->Zoom[ViewNum];
			//move the center of the view
			pDoc->Center[ViewNum][0]+= pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/s;
			pDoc->Center[ViewNum][1]+= pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/s;
		} 
		else if(nFlags&MK_RBUTTON) 
		{
			// a weak powerlaw for zooming
			if (m_ptOld.y < point.y) 
			{
				j = point.y-m_ptOld.y;
				for (i=0; i<j; i++) pDoc->Zoom[ViewNum]*=1.01f;
			}
			else if (m_ptOld.y > point.y) 
			{
				 j = m_ptOld.y-point.y;
				for (i=0; i<j; i++) pDoc->Zoom[ViewNum]/=1.01f;
			}
		}
		m_ptOld=point;
		InvalidateRect(NULL, 0);
		break;

	case VA_SCALE:
		{
			//AfxMessageBox("KK");
		float su,sd;
		su=1.1;
		sd=.9;
		if(nFlags & MK_SHIFT) {su=1.02f; sd=.98f;}
		float j = point.y-m_ptOld.y;
		float i = point.x-m_ptOld.x;


		pDoc->ScaleVal[0]=1.f; pDoc->ScaleVal[1]=1.f; pDoc->ScaleVal[2]=1.f;

		if(nFlags&MK_LBUTTON) 
		{
			j=i;
			if (m_ptOld.y < point.y){
				for(int i=0; i<3; i++){
					if (pDoc->Restrict[i] == TRUE) pDoc->ScaleVal[i]=1.f;
					else pDoc->ScaleVal[i]=sd;
				}
			}	
			else if(m_ptOld.y > point.y){
				for(int i=0; i<3; i++){
					if (pDoc->Restrict[i] == TRUE) pDoc->ScaleVal[i]=1.f;
					else pDoc->ScaleVal[i]=su;
				}
			}

		}
		else
		{
			if(pDoc->Restrict[pDoc->AxisMap[ViewNum][1]] != TRUE)
			{
				if (m_ptOld.y < point.y) 
					pDoc->ScaleVal[pDoc->AxisMap[ViewNum][1]]=sd;
				else if(m_ptOld.y > point.y) 
					pDoc->ScaleVal[pDoc->AxisMap[ViewNum][1]]=su;
			}
			if(pDoc->Restrict[pDoc->AxisMap[ViewNum][0]] != TRUE){
				if (m_ptOld.x > point.x) 
					pDoc->ScaleVal[pDoc->AxisMap[ViewNum][0]]=sd;
				else if(m_ptOld.x < point.x)
					pDoc->ScaleVal[pDoc->AxisMap[ViewNum][0]]=su;
			}
		}
	
		m_ptOld = point;
		ScaleSelected(pDoc, pDoc->ScaleVal);
		pDoc->ScaleVal[0]=1.f;
		pDoc->ScaleVal[1]=1.f;
		pDoc->ScaleVal[2]=1.f;
			
		OnDraw(Context);
		ReleaseDC(Context);
		pDoc->UpdateAllViews(this);
		}
		break;

	case VA_SELECT:
		// if hitting vert, translate
		if(m_bHittingVert && f)
		{
			int i;
			float xofs, yofs;
			float min[2];
			float max[2];
			int map[2];
			map[0]=pDoc->AxisMap[ViewNum][0];
			map[1]=pDoc->AxisMap[ViewNum][1];

			
			if (pDoc->Restrict[map[1]] == TRUE) yofs = 0;
			else if(pDoc->m_Grid.bSnap)
			{
				float x0,x1;
				x0 = (-(float)point.y+(float)rc.bottom*.5)/
					 (pDoc->Scale*pDoc->Zoom[ViewNum]*pDoc->AxisDir[ViewNum][1])
					 + pDoc->Center[ViewNum][1];
					
				float snf=x0/pDoc->m_Grid.fSpacing;
				int sni=(int)snf;
				snf-=sni;
				if(fabs(snf)>.5)
				{
					if(snf>0) sni+=1;
					else sni-=1;
				}
				x1=(float)sni*pDoc->m_Grid.fSpacing;
				yofs = -x1+pDoc->m_MedDLeObject.m_curFrame->v[m_nLastHitIndex].x[map[1]];//pDoc->AxisDir[ViewNum][0]*(-px )/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			}
			else
				yofs = pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
		
			
			
			if (pDoc->Restrict[map[0]] == TRUE) xofs = 0;
			else if(pDoc->m_Grid.bSnap)
			{
				float x0,x1;
				x0 = ((float)point.x-(float)rc.right*.5)/
					 (pDoc->Scale*pDoc->Zoom[ViewNum]*pDoc->AxisDir[ViewNum][0])
					 + pDoc->Center[ViewNum][0];
					
				float snf=x0/pDoc->m_Grid.fSpacing;
				int sni=(int)snf;
				snf-=sni;
				if(fabs(snf)>.5)
				{
					if(snf>0) sni+=1;
					else sni-=1;
				}
				x1=(float)sni*pDoc->m_Grid.fSpacing;
				xofs = -x1+pDoc->m_MedDLeObject.m_curFrame->v[m_nLastHitIndex].x[map[0]];//pDoc->AxisDir[ViewNum][0]*(-px )/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			}
			else
				xofs = pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			
			float sn, snf;
			int sni;
			float x0,y0;
	
			for (i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
			{
				if (((pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_SELECTED)||(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_TEMP_SELECTED)) 
					&& (pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE))
				{
	
					pDoc->m_MedDLeObject.m_curFrame->v[i].x[map[0]] -= xofs;
					pDoc->m_MedDLeObject.m_curFrame->v[i].x[map[1]] -= yofs;

				}
			}

	/*		if (f != NULL){
				min[0]=f->fv[0].v[map[0]];
				min[1]=f->fv[0].v[map[1]];
				max[0]=min[0];
				max[1]=min[1];
				for (i=0; i<pDoc->num.vertices; i++){
					if(f->fv[i].v[map[0]]<min[0]) min[0]=f->fv[i].v[map[0]];
					else if(f->fv[i].v[map[0]]>max[0]) max[0]=f->fv[i].v[map[0]];
					if(f->fv[i].v[map[1]]<min[1]) min[1]=f->fv[i].v[map[1]];
					else if(f->fv[i].v[map[1]]>max[1]) max[1]=f->fv[i].v[map[1]];
				}
				f->fbboxmin.v[map[0]]=min[0];
				f->fbboxmin.v[map[1]]=min[1];
				f->fbboxmax.v[map[0]]=max[0];
				f->fbboxmax.v[map[1]]=max[1];
				min[0]=pDoc->Frames[0]->fv[0].v[map[0]];
				min[1]=pDoc->Frames[0]->fv[0].v[map[1]];
				max[0]=min[0];
				max[1]=min[1];
				for (i=0; i<pDoc->num.frames; i++){
					if(pDoc->Frames[i]->fbboxmin.v[map[0]]<min[0]) min[0]=pDoc->Frames[i]->fbboxmin.v[map[0]];
					if(pDoc->Frames[i]->fbboxmin.v[map[1]]<min[1]) min[1]=pDoc->Frames[i]->fbboxmin.v[map[1]];
					if(pDoc->Frames[i]->fbboxmax.v[map[0]]>max[0]) max[0]=pDoc->Frames[i]->fbboxmax.v[map[0]];
					if(pDoc->Frames[i]->fbboxmax.v[map[1]]>max[1]) max[1]=pDoc->Frames[i]->fbboxmax.v[map[1]];
				}
				pDoc->boxmin[map[0]]=min[0];
				pDoc->boxmin[map[1]]=min[1];
				pDoc->boxmax[map[0]]=max[0];
				pDoc->boxmax[map[1]]=max[1];
			}
			*/
			CDC *pDC=GetDC();
			OnDraw(pDC);
//			pDC->MoveTo(m_ptSelection0.x,m_ptSelection0.y);
//			pDC->LineTo(m_ptSelection1.x,m_ptSelection0.y);
//			pDC->LineTo(m_ptSelection1.x,m_ptSelection1.y);
//			pDC->LineTo(m_ptSelection0.x,m_ptSelection1.y);
//			pDC->LineTo(m_ptSelection0.x,m_ptSelection0.y);
			ReleaseDC(pDC);
			pDoc->UpdateAllViews(this);
			m_ptOld = point;
		}
		
		// else draw selection region
		else
		{
			pDoc->m_ptSelection1=point;
			SelectRect(rc);
			CDC *pDC=GetDC();
			OnDraw(pDC);
			ReleaseDC(pDC);
			pDoc->UpdateAllViews(this);
			m_ptOld = point;

		}

		break;

	}
//	if (m_bMotion == 0) 
//	{
//	if (abs(point.x-m_ptOld.x) > 2) m_bMotion = 1;
//	else if (abs(point.y-m_ptOld.y) > 2) m_bMotion = 1;

//		if (m_bMotion==1) 
//		{
/*			if (m_ViewAction==VA_STARTTRI)
			{
				BOOL maxis[3];
				double pi = 3.1415926535;
				double rtod = 180/pi;
				float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
				int mval;
				int aval[2];
				int AltView;
				float mcenter;
				double dif[2];
				double angle;
				int res;
				float center[2];
				float click[2];
				center[0] = ((m_ptClicked.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
				center[1] = ((m_ptClicked.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
				click[0] = ((point.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
				click[1] = ((point.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
				dif[0] = click[0]-center[0];
				dif[1] = click[1]-center[1];
				angle = tanh(dif[0]/dif[1]);
				AltView=(ViewNum+1)%3;
				maxis[0]=FALSE;
				maxis[1]=FALSE;
				maxis[2]=FALSE;
				double dist=(dif[0]*dif[0])+(dif[1]*dif[1]);
				dist=sqrt(dist);
				maxis[pDoc->AxisMap[ViewNum][0]]=TRUE;
				maxis[pDoc->AxisMap[ViewNum][1]]=TRUE;
				for (int i=0; i<3; i++) if (maxis[i]==FALSE) mval=i;
				for (i=0; i<2; i++) {
					if (pDoc->AxisMap[AltView][i]==mval) mcenter=pDoc->Center[AltView][i];
					aval[i]=pDoc->AxisMap[ViewNum][i];
				}
				pDoc->Triloc[0][mval]=mcenter;
				pDoc->Triloc[1][mval]=mcenter;
				pDoc->Triloc[2][mval]=mcenter;
				pDoc->Triloc[0][aval[0]]=center[0]+(dist*sin(angle));
				pDoc->Triloc[0][aval[1]]=center[1]+(dist*cos(angle));
				angle+=(120/rtod);
				pDoc->Triloc[1][aval[0]]=center[0]+(dist*sin(angle));
				pDoc->Triloc[1][aval[1]]=center[1]+(dist*cos(angle));
				angle+=(120/rtod);
				pDoc->Triloc[2][aval[0]]=center[0]+(dist*sin(angle));
				pDoc->Triloc[2][aval[1]]=center[1]+(dist*cos(angle));
				for (i=0; i<3; i++) {
					pDoc->Trimap[i]=-1;
				}
				pDoc->TriAdd=TRUE;
			}
			*/
//		}
//	} 
//	else 
//	{

/*		if ((m_ViewAction==VA_TRANSLATE)&&(nFlags&MK_LBUTTON)) 
		{
			int i;
			float xofs, yofs;
			float min[2];
			float max[2];
			int map[2];
			map[0]=pDoc->AxisMap[ViewNum][0];
			map[1]=pDoc->AxisMap[ViewNum][1];
			yofs = pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			if (pDoc->Restrict[map[1]] == TRUE) yofs = 0;
			xofs = pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			if (pDoc->Restrict[map[0]] == TRUE) xofs = 0;
			for (i=0; i<pDoc->num.vertices; i++){
				if (pDoc->Verts[i].flags & O_DRAW_BLUE) {
					f->fv[i].v[map[0]] -= xofs;
					f->fv[i].v[map[1]] -= yofs;
				}
			}
			if (f != NULL){
				min[0]=f->fv[0].v[map[0]];
				min[1]=f->fv[0].v[map[1]];
				max[0]=min[0];
				max[1]=min[1];
				for (i=0; i<pDoc->num.vertices; i++){
					if(f->fv[i].v[map[0]]<min[0]) min[0]=f->fv[i].v[map[0]];
					else if(f->fv[i].v[map[0]]>max[0]) max[0]=f->fv[i].v[map[0]];
					if(f->fv[i].v[map[1]]<min[1]) min[1]=f->fv[i].v[map[1]];
					else if(f->fv[i].v[map[1]]>max[1]) max[1]=f->fv[i].v[map[1]];
				}
				f->fbboxmin.v[map[0]]=min[0];
				f->fbboxmin.v[map[1]]=min[1];
				f->fbboxmax.v[map[0]]=max[0];
				f->fbboxmax.v[map[1]]=max[1];
				min[0]=pDoc->Frames[0]->fv[0].v[map[0]];
				min[1]=pDoc->Frames[0]->fv[0].v[map[1]];
				max[0]=min[0];
				max[1]=min[1];
				for (i=0; i<pDoc->num.frames; i++){
					if(pDoc->Frames[i]->fbboxmin.v[map[0]]<min[0]) min[0]=pDoc->Frames[i]->fbboxmin.v[map[0]];
					if(pDoc->Frames[i]->fbboxmin.v[map[1]]<min[1]) min[1]=pDoc->Frames[i]->fbboxmin.v[map[1]];
					if(pDoc->Frames[i]->fbboxmax.v[map[0]]>max[0]) max[0]=pDoc->Frames[i]->fbboxmax.v[map[0]];
					if(pDoc->Frames[i]->fbboxmax.v[map[1]]>max[1]) max[1]=pDoc->Frames[i]->fbboxmax.v[map[1]];
				}
				pDoc->boxmin[map[0]]=min[0];
				pDoc->boxmin[map[1]]=min[1];
				pDoc->boxmax[map[0]]=max[0];
				pDoc->boxmax[map[1]]=max[1];
			}
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
			m_ptOld = point;
//			ReleaseDC(Context);
		}
		} else if (m_ViewAction==VA_STARTTRI){
			BOOL maxis[3];
			double pi = 3.1415926535;
			double rtod = 180/pi;
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			int mval;
			int aval[2];
			int AltView;
			float mcenter;
			double dif[2];
			double angle;
			int res;
			float center[2];
			float click[2];
			center[0] = ((m_ptClicked.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			center[1] = ((m_ptClicked.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
			click[0] = ((point.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
			click[1] = ((point.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
			dif[0] = click[0]-center[0];
			dif[1] = click[1]-center[1];
			angle = tanh(dif[0]/dif[1]);
			AltView=(ViewNum+1)%3;
			maxis[0]=FALSE;
			maxis[1]=FALSE;
			maxis[2]=FALSE;
			double dist=(dif[0]*dif[0])+(dif[1]*dif[1]);
			dist=sqrt(dist);
			maxis[pDoc->AxisMap[ViewNum][0]]=TRUE;
			maxis[pDoc->AxisMap[ViewNum][1]]=TRUE;
			for (int i=0; i<3; i++) if (maxis[i]==FALSE) mval=i;
			for (i=0; i<2; i++) {
				if (pDoc->AxisMap[AltView][i]==mval) mcenter=pDoc->Center[AltView][i];
				aval[i]=pDoc->AxisMap[ViewNum][i];
			}
			pDoc->Triloc[0][mval]=mcenter;
			pDoc->Triloc[1][mval]=mcenter;
			pDoc->Triloc[2][mval]=mcenter;
			pDoc->Triloc[0][aval[0]]=center[0]+(dist*sin(angle));
			pDoc->Triloc[0][aval[1]]=center[1]+(dist*cos(angle));
			angle+=(120/rtod);
			pDoc->Triloc[1][aval[0]]=center[0]+(dist*sin(angle));
			pDoc->Triloc[1][aval[1]]=center[1]+(dist*cos(angle));
			angle+=(120/rtod);
			pDoc->Triloc[2][aval[0]]=center[0]+(dist*sin(angle));
			pDoc->Triloc[2][aval[1]]=center[1]+(dist*cos(angle));
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} else if (m_ViewAction==VA_MOVETRI){
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][0]]==FALSE){
				pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][0]] = ((point.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
				pDoc->Trimap[PClicked]=-1;
			}
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][1]]==FALSE){
				pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][1]] = ((point.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
				pDoc->Trimap[PClicked]=-1;
			}
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} 
		else if (m_ViewAction==VA_SNAPTRI){
			BOOL snapped=FALSE;
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][0]]==FALSE){
				pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][0]] = ((point.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
				pDoc->Trimap[PClicked]=-2;
			}
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][1]]==FALSE){
				pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][1]] = ((point.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
				pDoc->Trimap[PClicked]=-2;
			}
			if ((pDoc->Trimap[PClicked]==-2) && (pDoc->Verts.GetSize()>0)) {
				zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
				double shrtdist, testdist;
				int cvert;
				float vertx, verty;
				float px, py;
				px=pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][0]];
				py=pDoc->Triloc[PClicked][pDoc->AxisMap[ViewNum][1]];
				shrtdist = 1000;
				cvert = -1;
				for(int i=0; i<pDoc->Verts.GetSize(); i++){
					vertx=f->fv[i].v[pDoc->AxisMap[ViewNum][0]];
					verty=f->fv[i].v[pDoc->AxisMap[ViewNum][1]];
					testdist = ((px-vertx)*(px-vertx))+((py-verty)*(py-verty));
					if ((testdist < shrtdist) && (!(pDoc->Verts[i].flags & O_VHIDDEN))){
						shrtdist = testdist;
						cvert = i;
					}
				}
				if (sqrt(shrtdist) > (12/zoomedscale)) cvert=-1;
				if (cvert != -1){
					snapped=TRUE;
					for (i=0; i<3; i++){
						if (pDoc->Restrict[i]==FALSE){
							pDoc->Triloc[PClicked][i]=f->fv[cvert].v[i];
						} else snapped=FALSE;
					}
					if (snapped) pDoc->Trimap[PClicked]=cvert;
					else pDoc->Trimap[PClicked]=-1;
				}
			} else if (pDoc->Trimap[PClicked]==-2) PClicked=-1;
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} else if ((pDoc->EditMode!=SM_SKEL)&&(m_ViewAction==VA_SNAPTRANS)){
			BOOL snapped=FALSE;
			float zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][0]]==FALSE){
				f->fv[PClicked].v[pDoc->AxisMap[ViewNum][0]] = ((point.x-(rc.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
				PMapped=-2;
			}
			if (pDoc->Restrict[pDoc->AxisMap[ViewNum][0]]==FALSE){
				f->fv[PClicked].v[pDoc->AxisMap[ViewNum][1]] = ((point.y-(rc.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
				PMapped=-2;
			}
			if ((PMapped==-2) && (pDoc->Verts.GetSize()>0)) {
				zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];
				double shrtdist, testdist;
				int cvert;
				float vertx, verty;
				float px, py;
				px=f->fv[PClicked].v[pDoc->AxisMap[ViewNum][0]];
				py=f->fv[PClicked].v[pDoc->AxisMap[ViewNum][1]];
				shrtdist = 1000;
				cvert = -1;
				for(int i=0; i<pDoc->Verts.GetSize(); i++){
					if (i != PClicked) {
						vertx=f->fv[i].v[pDoc->AxisMap[ViewNum][0]];
						verty=f->fv[i].v[pDoc->AxisMap[ViewNum][1]];
						testdist = ((px-vertx)*(px-vertx))+((py-verty)*(py-verty));
						if ((testdist < shrtdist) && (!(pDoc->Verts[i].flags & O_VHIDDEN))){
							shrtdist = testdist;
							cvert = i;
						}
					}
				}
				if (sqrt(shrtdist) > (10/zoomedscale)) cvert=-1;
				if (cvert != -1){
					snapped=TRUE;
					for (i=0; i<3; i++){
						if (pDoc->Restrict[i]==FALSE){
							f->fv[PClicked].v[i]=f->fv[cvert].v[i];
						} else snapped=FALSE;
					}
					if (snapped) PMapped=cvert;
					else PMapped=-1;
				}
			} else if (PMapped==-2) PMapped=-1;
			FindMinMax(pDoc);
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} else if (m_ViewAction==VA_SCALE){ //L
			float su,sd;
			su=1.1;
			sd=.9;
			if(nFlags & MK_SHIFT) {su=1.02f; sd=.98f;}
			if (m_ptOld.y < point.y){
				for(int i=0; i<3; i++){
					if (pDoc->Restrict[i] == TRUE) pDoc->ScaleVal[i]=1.f;
					else pDoc->ScaleVal[i]=sd;
				}
			}	
			else if(m_ptOld.y > point.y){
				for(int i=0; i<3; i++){
					if (pDoc->Restrict[i] == TRUE) pDoc->ScaleVal[i]=1.f;
					else pDoc->ScaleVal[i]=su;
				}
			}
			m_ptOld = point;
			ScaleSelected(pDoc, pDoc->ScaleVal);
			pDoc->ScaleVal[0]=1.f;
			pDoc->ScaleVal[1]=1.f;
			pDoc->ScaleVal[2]=1.f;			
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} else if ((m_ViewAction==VA_ROTATE)&&(nFlags&MK_RBUTTON)) {
			float fact;
			if(nFlags & MK_SHIFT) fact=.5f;
			else fact=5.f;
			int j = point.y-m_ptOld.y;
			pDoc->RotAngle=fact*j;
			RotateSelected(pDoc, pDoc->RotAngle, pDoc->RotHead, pDoc->RotTail);
			pDoc->RotAngle=0.f;
			m_ptOld=point;
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		} else if ((m_ViewAction==VA_ROTATE)&&(nFlags&MK_LBUTTON)) {
			float xofs, yofs;
			yofs = pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			xofs = pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			if (pDoc->RotHSel){
				pDoc->RotHead[pDoc->AxisMap[ViewNum][0]] -= xofs;
				pDoc->RotHead[pDoc->AxisMap[ViewNum][1]] -= yofs;
			}
			if (pDoc->RotTSel){
				pDoc->RotTail[pDoc->AxisMap[ViewNum][0]] -= xofs;
				pDoc->RotTail[pDoc->AxisMap[ViewNum][1]] -= yofs;
			}
			m_ptOld = point;
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
		}
		////////////// test stuffs.. bones
		else if (m_ViewAction==VA_MOVEBONE) {
			float xofs, yofs;
			int moved[200], cnt;
			yofs = pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			xofs = pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			// find hit bone
			int bone=-2;
			int i;
			for(i=0; i<pDoc->Skeleton.cnt; i++)
			{
				if ((pDoc->Skeleton.hflags[i]&O_SELECTED)||(pDoc->Skeleton.tflags[i]&O_SELECTED))
				{
					bone=i;
					break;
				}
				
			}
			if(bone<0) return;
			// select all verts to be played with;
			if(pDoc->SkelOptions&BO_STICKY)
			{
				for (i=0; i<pDoc->Verts.GetSize(); i++)
				{
					if(pDoc->Verts[i].skel==bone) 
					{
						pDoc->Verts[i].flags|=O_SELECTED;
						//pDoc->Verts[i].flags&= ~O_HIDDEN;
					}
					else 
					{
						pDoc->Verts[i].flags&= ~O_SELECTED;
						//pDoc->Verts[i].flags |= O_HIDDEN;
					}

					// now check if it is a child bone
					if(pDoc->SkelOptions&BO_MOVECHILD)
					for(int j=0; j<pDoc->curChildBones.GetSize(); j++)
					{
						if(pDoc->Verts[i].skel==pDoc->curChildBones[j]) 
						{
							pDoc->Verts[i].flags|=O_SELECTED; 
							pDoc->Verts[i].flags&= ~O_HIDDEN;
							break;
						}
					}

				}
			}
			// translate
			if(pDoc->SkelAction==BA_TRANS)
			{

				//just hit head (childs too)
				if ((pDoc->Skeleton.hflags[bone]&O_SELECTED)&&!(pDoc->Skeleton.tflags[bone]&O_SELECTED)&&!(pDoc->SkelOptions&BO_STICKY))
				{
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][0]] -= xofs;
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][1]] -= yofs;
					if(pDoc->SkelOptions&BO_MOVECHILD)
					{
						int ii;
						for(i=0; i<pDoc->curChildBones.GetSize(); i++)
						{
							ii=pDoc->curChildBones[i];
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][0]] -= xofs;
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][1]] -= yofs;
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][0]] -= xofs;
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][1]] -= yofs;
							if(pDoc->SkelOptions&BO_STICKY)
							{
								for(int j=0; j<pDoc->Verts.GetSize(); j++)
								{
									if(pDoc->Verts[j].flags&O_SELECTED) 
									{
										pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][0]] -= xofs;
										pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][1]] -= yofs;
									}
								}

							}

						}
					}
				}
				// just tail
				if ((pDoc->Skeleton.tflags[bone]&O_SELECTED)&&!(pDoc->Skeleton.hflags[bone]&O_SELECTED)&&!(pDoc->SkelOptions&BO_STICKY))
				{
					
					pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]] -= xofs;
					pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]] -= yofs;
				}
			    // if both ends selected & translate move bone
				if ((pDoc->Skeleton.hflags[bone]&O_SELECTED)&&(pDoc->Skeleton.tflags[bone]&O_SELECTED))
				{
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][0]] -= xofs;
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][1]] -= yofs;
					pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]] -= xofs;
					pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]] -= yofs;
					// only move bone?
					if(pDoc->SkelOptions&BO_STICKY)
					{
						for(int j=0; j<pDoc->Verts.GetSize(); j++)
						{
							if(pDoc->Verts[j].flags&O_SELECTED) 
							{
								pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][0]] -= xofs;
								pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][1]] -= yofs;
							}
						}
					}
					// move child bones too
					if(pDoc->SkelOptions&BO_MOVECHILD)
					{
						int ii;
						for(i=0; i<pDoc->curChildBones.GetSize(); i++)
						{
							ii=pDoc->curChildBones[i];
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][0]] -= xofs;
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][1]] -= yofs;
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][0]] -= xofs;
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][1]] -= yofs;

						}
					}
					FindMinMax(pDoc);

				}
			}
			// if  head or tail selected, twist
			if (((pDoc->Skeleton.hflags[bone]&O_SELECTED)||(pDoc->Skeleton.tflags[bone]&O_SELECTED))&&(pDoc->SkelAction==BA_TWIST))
			{
				float fact; 
				double a;
				if(nFlags & MK_SHIFT) fact=.5f;
				else fact=5.f;
				int j = point.y-m_ptOld.y;
				a=fact*j;
				//rotate verts
				if(pDoc->SkelOptions&BO_STICKY)		
					RotateSelected(pDoc, a, pDoc->cur.frameptr->bone[bone].head, pDoc->cur.frameptr->bone[bone].tail);
				//rotate bones
				a=a*3.141596/180.;

				float s, c;
				s=sin(a); c=cos(a);

				float dx,dy,dz,dd,dr;
				dx=pDoc->cur.frameptr->bone[bone].head[0]-pDoc->cur.frameptr->bone[bone].tail[0];
				dy=pDoc->cur.frameptr->bone[bone].head[1]-pDoc->cur.frameptr->bone[bone].tail[1];
				dz=pDoc->cur.frameptr->bone[bone].head[2]-pDoc->cur.frameptr->bone[bone].tail[2];
				dr=dx*dx+dy*dy+dz*dz;
				dr=sqrt(dr);
	
				dd=sqrt(dx*dx+dy*dy);
	
				double dtheta,dphi;
				if(dd!=0) 
					dtheta=atan2(dd,dz);
				else dtheta=0.;
				if(dy!=0) 
					dphi=atan2(dy,dx);
				else dphi=0.;
				double dcp, dsp, dct,dst;
				dct=cos(-dtheta); dst=sin(-dtheta);
				dcp=cos(dphi); dsp=sin(dphi);
				// move child bones too
				if(pDoc->SkelOptions&BO_MOVECHILD)
				{
					int ii;
					for(i=0; i<pDoc->curChildBones.GetSize(); i++)
					{
						ii=pDoc->curChildBones[i];
						// rotate the point
						// put point in axis frame
						double x[3],xp[3],xpp[3];
						for (j=0; j<3; j++)
							x[j]=pDoc->cur.frameptr->bone[ii].head[j] -pDoc->cur.frameptr->bone[bone].tail[j];
	
						xp[0]=dcp*x[0]+dsp*x[1];
						xp[1]=-dsp*x[0]+dcp*x[1];
						xp[2]=x[2];

						x[0]=dct*xp[0]+dst*xp[2];
						x[1]=xp[1];
						x[2]=-dst*xp[0]+dct*xp[2];

						// rotate around axis
						float tx[2];
						tx[0]=c*x[0]+s*x[1];
						tx[1]=-s*x[0]+c*x[1];
						x[0]=tx[0]; 
						x[1]=tx[1]; 

						// put back in real space
						xp[0]=dct*x[0]-dst*x[2];
						xp[1]=x[1];
						xp[2]=dst*x[0]+dct*x[2];
	
						x[0]=dcp*xp[0]-dsp*xp[1];
						x[1]=dsp*xp[0]+dcp*xp[1];
						x[2]=xp[2];
						for (j=0; j<3; j++)
							pDoc->cur.frameptr->bone[ii].head[j]=x[j] +pDoc->cur.frameptr->bone[bone].tail[j];
		
						/// now tail
						for (j=0; j<3; j++)
							x[j]=pDoc->cur.frameptr->bone[ii].tail[j] -pDoc->cur.frameptr->bone[bone].tail[j];
	
						xp[0]=dcp*x[0]+dsp*x[1];
						xp[1]=-dsp*x[0]+dcp*x[1];
						xp[2]=x[2];

						x[0]=dct*xp[0]+dst*xp[2];
						x[1]=xp[1];
						x[2]=-dst*xp[0]+dct*xp[2];

						// rotate around axis
//						float tx[2];
						tx[0]=c*x[0]+s*x[1];
						tx[1]=-s*x[0]+c*x[1];
						x[0]=tx[0]; 
						x[1]=tx[1]; 

						// put back in real space
						xp[0]=dct*x[0]-dst*x[2];
						xp[1]=x[1];
						xp[2]=dst*x[0]+dct*x[2];
	
						x[0]=dcp*xp[0]-dsp*xp[1];
						x[1]=dsp*xp[0]+dcp*xp[1];
						x[2]=xp[2];
						for (j=0; j<3; j++)
							pDoc->cur.frameptr->bone[ii].tail[j]=x[j] +pDoc->cur.frameptr->bone[bone].tail[j];

					}
				}


			}
			// if just head end selected, rotate about head
			if ((pDoc->Skeleton.hflags[bone]&O_SELECTED)&&(pDoc->SkelAction==BA_ROT))
			{
					float old[2],d, dx,dy,tx,ty;
					double x[3],xp[3],xpp[3];
					int ia = (point.y-m_ptOld.y)*2;

					dx=pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][0]]-
						pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
					dy=pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][1]]-
						pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
					d=sqrt(dx*dx+dy*dy);
					double ca,sa;
					ca=cos((double)ia/180.*3.14159);
					sa=sin((double)ia/180.*3.14159);
					tx=ca*dx+sa*dy;
					ty=-sa*dx+ca*dy;
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][0]]=
						tx+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
					pDoc->cur.frameptr->bone[bone].head[pDoc->AxisMap[ViewNum][1]]=
						ty+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];

					if(pDoc->SkelOptions&BO_STICKY)
					{
						for(int j=0; j<pDoc->Verts.GetSize(); j++)
						{
							if(pDoc->Verts[j].flags&O_SELECTED) 
							{
								dx=pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][0]]-
								pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
								dy=pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][1]]-
								pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
								d=sqrt(dx*dx+dy*dy);
								tx=ca*dx+sa*dy;
								ty=-sa*dx+ca*dy;
								pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][0]]=
								tx+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
								pDoc->cur.frameptr->fv[j].v[pDoc->AxisMap[ViewNum][1]]=
								ty+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
							}
						}
					}
					if(pDoc->SkelOptions&BO_MOVECHILD)
					{
						int ii;
						for(i=0; i<pDoc->curChildBones.GetSize(); i++)
						{
							ii=pDoc->curChildBones[i];

							dx=pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][0]]-
							pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
							dy=pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][1]]-
							pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
							d=sqrt(dx*dx+dy*dy);
							tx=ca*dx+sa*dy;
							ty=-sa*dx+ca*dy;
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][0]]=
							tx+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
							pDoc->cur.frameptr->bone[ii].head[pDoc->AxisMap[ViewNum][1]]=
							ty+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
							
							dx=pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][0]]-
							pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
							dy=pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][1]]-
							pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];
							d=sqrt(dx*dx+dy*dy);
							tx=ca*dx+sa*dy;
							ty=-sa*dx+ca*dy;
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][0]]=
							tx+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][0]];
							pDoc->cur.frameptr->bone[ii].tail[pDoc->AxisMap[ViewNum][1]]=
							ty+pDoc->cur.frameptr->bone[bone].tail[pDoc->AxisMap[ViewNum][1]];

						}
					}

					FindMinMax(pDoc);

			}

			pDoc->ColorSort();
			m_ptOld = point;
			CDC *Context=GetDC();
			OnDraw(Context);
			ReleaseDC(Context);
			pDoc->UpdateAllViews(this);
	
	///////////////////////////////////////////	
		}
		

		else if ((m_ViewAction==VA_ZOOM)&&(nFlags&MK_LBUTTON)) 
		{
			pDoc->Center[ViewNum][0]+= pDoc->AxisDir[ViewNum][0]*(-point.x + m_ptOld.x)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			pDoc->Center[ViewNum][1]+= pDoc->AxisDir[ViewNum][1]*(point.y - m_ptOld.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]);
			InvalidateRect(NULL, 0);
			m_ptOld=point;
		} 
		else if ((m_ViewAction==VA_ZOOM)&&(nFlags&MK_RBUTTON)) {
			if (m_ptOld.y < point.y) 
			{
				int j = point.y-m_ptOld.y;
				for (int i=0; i<j; i++) pDoc->Zoom[ViewNum]*=1.01f;
			}
			else if (m_ptOld.y > point.y) {
				int j = m_ptOld.y-point.y;
				for (int i=0; i<j; i++) pDoc->Zoom[ViewNum]/=1.01f;
			}
			InvalidateRect(NULL, 0);
			m_ptOld=point;
		}
	}
	*/
}

void C2DView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	pDoc->HandleCommonKeys(nChar, nRepCnt, nFlags, -1);

	switch(nChar)
	{
	case '1': pDoc->Zoom[ViewNum]=.05f; InvalidateRect(NULL, 0); break;
	case '2': pDoc->Zoom[ViewNum]=.1f; InvalidateRect(NULL, 0); break;
	case '3': pDoc->Zoom[ViewNum]=.3f; InvalidateRect(NULL, 0); break;
	case '4': pDoc->Zoom[ViewNum]=.6f; InvalidateRect(NULL, 0); break;
	case '5': pDoc->Zoom[ViewNum]=1.f; InvalidateRect(NULL, 0); break;
	case '6': pDoc->Zoom[ViewNum]=2.f; InvalidateRect(NULL, 0); break;
	case '7': pDoc->Zoom[ViewNum]=4.f; InvalidateRect(NULL, 0); break;
	case '8': pDoc->Zoom[ViewNum]=8.f; InvalidateRect(NULL, 0); break;
	case '9': pDoc->Zoom[ViewNum]=16.f; InvalidateRect(NULL, 0); break;
	case '0': pDoc->Zoom[ViewNum]=30.f; InvalidateRect(NULL, 0); break;
	}
}



void C2DView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);

	int i;

	// if have capture and no buttons down
	if ((!(nFlags&MK_RBUTTON)) && (GetCapture()==this)) 
	{
		ReleaseCapture();
		
		switch(m_ViewAction)
		{
		case VA_ZOOM:
			// if click to zoom
			if(!m_bMotion)
			{
				pDoc->Center[ViewNum][0]+=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum]); 
				pDoc->Center[ViewNum][1]+=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]); 
				//for (i=0; i<CLICK_ZOOM_MAG; i++) pDoc->Zoom[ViewNum]*=1.01f;
				pDoc->Zoom[ViewNum]*=2.f;
				InvalidateRect(NULL, 0);
			}
			break;
		case VA_SELECT:
			if(theApp.m_AppMode==AM_VERT)
			{
				// if moved, unselect temp selected
				if(m_bMotion && m_bHittingVert)
				{
					for(int i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
					{
						pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;
					}
				}
				// unselect/select single
				else if(!m_bMotion && m_bHittingVert)
				{
					for(int i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
					{
						if(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_TEMP_SELECTED)
						{
							pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;
							pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags^=V_SELECTED;
						}
					}
				}
				// selection rect, make perment selection
				else if(m_bMotion && !m_bHittingVert)
				{
					for(int i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
					{
						if(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_TEMP_SELECTED)
						{
							pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;
							pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags|=V_SELECTED;
						}
					}
				}

				pDoc->m_ptSelection0=point;
				pDoc->m_ptSelection1=point;
				pDoc->UpdateAllViews(NULL);
			}
		
		break;
	default:
		m_ViewAction=VA_NULL;

	//}


	/*		case VA_ROTATE:
			pDoc->RotHSel=FALSE;
			pDoc->RotTSel=FALSE;
			pDoc->UpdateAllViews(NULL);
			m_bMotion=0;
			break;
		case VA_MOVEBONE:
			for(i=0; i<pDoc->Skeleton.cnt; i++)
			{
				pDoc->Skeleton.hflags[i] &= ~O_SELECTED;
				pDoc->Skeleton.tflags[i] &= ~O_SELECTED;
			}
			pDoc->UpdateAllViews(NULL);
			m_bMotion=0;
			break;
		case VA_SCALE:
			pDoc->ClearBlue=TRUE;
			pDoc->ColorSort();
			pDoc->UpdateAllViews(NULL);
			break;
		case VA_TRANSLATE:
			if (!m_bMotion) 
			{
				if (PClicked != -1) 
				{
					if (pDoc->EditMode==SM_VERT){ 
						if (IsSelected) {
							pDoc->Verts[PClicked].flags &=~ O_SELECTED;
							if (nFlags&MK_SHIFT){
								int j;
								for(i=0; i<pDoc->Sort.GetSize(); i++){
									if (pDoc->Sort[i].vindex[0] == PClicked) {
										j = pDoc->Sort[i].vindex[1];
										if (!(pDoc->Verts[j].flags & O_HIDDEN)) pDoc->Verts[j].flags &=~O_SELECTED;
									}
									if (pDoc->Sort[i].vindex[1] == PClicked) {
										j = pDoc->Sort[i].vindex[0];
										if (!(pDoc->Verts[j].flags & O_HIDDEN))	pDoc->Verts[j].flags &=~O_SELECTED;
									} 
								}
							}
						} 
						else 
						{
							pDoc->Verts[PClicked].flags |= O_SELECTED;
							if (nFlags&MK_SHIFT)
							{
								int j;
								for(i=0; i<pDoc->Sort.GetSize(); i++)
								{
									if (pDoc->Sort[i].vindex[0] == PClicked) 
									{
										j = pDoc->Sort[i].vindex[1];
										if (!(pDoc->Verts[j].flags & O_HIDDEN)) 
											pDoc->Verts[j].flags |=O_SELECTED;
									}
									if (pDoc->Sort[i].vindex[1] == PClicked) 
									{
										j = pDoc->Sort[i].vindex[0];
										if (!(pDoc->Verts[j].flags & O_HIDDEN))	
											pDoc->Verts[j].flags |=O_SELECTED;
									} 
								}
							}
						}
					} 
					else if (pDoc->EditMode==SM_TRI)
					{
						if (IsSelected)
						{
							pDoc->Tris[PClicked].Vflags &=~O_SELECTED;
						} 
						else 
						{
							pDoc->Tris[PClicked].Vflags |=O_SELECTED;
						}
					} 
					else if (pDoc->EditMode == SM_GROUP)
					{ 
						if (IsSelected)
						{
							pDoc->Objects[ObjN].Groups[GrpN]->flags &=~O_SELECTED;
						} 
						else 
						{
								pDoc->Objects[ObjN].Groups[GrpN]->flags |=O_SELECTED;
						}
					} 
					else if (pDoc->EditMode == SM_OBJECT)
					{ 
						if (IsSelected)
						{
							pDoc->Objects[ObjN].flags &=~O_SELECTED;
						} 
						else 
						{
							pDoc->Objects[ObjN].flags |=O_SELECTED;
						}
					}
				}
			}
			pDoc->ClearBlue=TRUE;
			pDoc->ColorSort();
			pDoc->UpdateAllViews(NULL);
			break;
			*/
		}// end of switch
	}
} 


void C2DView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);

	int i;
	// if left isn't down and have capture
	if ((!(nFlags&MK_LBUTTON)) && (GetCapture()==this))
	{
		ReleaseCapture();
	
/*		if (m_ViewAction==VA_SCALE) //R
		{
				pDoc->ClearBlue=TRUE;
				pDoc->ColorSort();
				pDoc->UpdateAllViews(NULL);
		} else if (m_ViewAction==VA_ROTATE){ //R
				pDoc->ClearBlue=TRUE;
				pDoc->ColorSort();
				pDoc->UpdateAllViews(NULL);
		} else if (m_ViewAction==VA_SNAPTRANS){
				pDoc->ClearBlue=TRUE;
				pDoc->ColorSort();
				pDoc->UpdateAllViews(NULL);
		}
*/		
		if (!m_bMotion)
		{
			if (m_ViewAction==VA_ZOOM) 
			{ //R
					pDoc->Center[ViewNum][0]+=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum]); 
					pDoc->Center[ViewNum][1]+=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum]); 
					pDoc->Zoom[ViewNum]/=2.f;
					InvalidateRect(NULL, 0);
			} 
/*			else 
			{
				CMenu menu;
				if (menu.LoadMenu(IDR_POPUPS)){
					CMenu* pPopup = menu.GetSubMenu(1);
					ASSERT(pPopup != NULL);
					ClientToScreen(&point);
					pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, AfxGetMainWnd());
				}
			}
*/		} 
		else 
		{
/*			if (m_ViewAction==VA_STARTTRI)
			{
				pDoc->UpdateAllViews(NULL);
			} 
			else if (m_ViewAction==VA_SNAPTRANS)
			{
				if (PMapped != -1) {
					BOOL degen;
					degen=FALSE;
					BOOL fnd[2];
					for (int i=0; i<pDoc->Tris.GetSize(); i++){
						fnd[0]=FALSE;
						fnd[1]=FALSE;
						for (int k=0; k<3; k++){
							if (pDoc->Tris[i].vindex[k]==PClicked) fnd[0]=TRUE;
							if (pDoc->Tris[i].vindex[k]==PMapped) fnd[1]=TRUE;
						}
						if ((fnd[0])&&(fnd[1])) degen=TRUE;
					}
					if (degen){
						AfxMessageBox("You cannot merge those vertices.\nIt will create a degenerate triangle!");
						PMapped=-1;
					}
				}
			
				if (PMapped==PClicked) PMapped=-1;
				if (PMapped != -1) {
					int k=0;
					int flg;
					BOOL sel;
					int numingrp=0;
					int objn, objn2, grpn, grpn2;
					objn=pDoc->Verts[PClicked].object;
					objn2=pDoc->Verts[PMapped].object;
					grpn=pDoc->Verts[PClicked].group;
					grpn2=pDoc->Objects[objn2].Groups.GetSize();
					if (grpn != 0){
						for (k=0; k<pDoc->Verts.GetSize(); k++){
							if ((pDoc->Verts[k].object==objn) && (pDoc->Verts[k].group==grpn)) numingrp++;
						}
					} else numingrp=-1;
					if ((numingrp<2) && (numingrp!=-1)){
						delete pDoc->Objects[objn].Groups[grpn];
						pDoc->Objects[objn].Groups.RemoveAt(grpn);
						pDoc->Objects[objn].Groups.FreeExtra();
						for (k=0; k<pDoc->Verts.GetSize(); k++){
							if (pDoc->Verts[k].object==objn){
								if (pDoc->Verts[k].group>grpn) pDoc->Verts[k].group--;
							}
						}
					}
					if (objn2!=objn){
						for (k=0; k<pDoc->Objects[objn].Groups.GetSize(); k++){
							if (k!=0) pDoc->Objects[objn2].Groups.Add(pDoc->Objects[objn].Groups[0]);
							pDoc->Objects[objn].Groups.RemoveAt(0);
						}
						for (k=0; k<pDoc->Verts.GetSize(); k++){
							if (pDoc->Verts[k].object==objn){
								pDoc->Verts[k].object=objn2;
								if (pDoc->Verts[k].group != 0){
									pDoc->Verts[k].group+=grpn2;
									pDoc->Verts[k].group--;
								}
							}
							if (pDoc->Verts[k].object>objn){
								pDoc->Verts[k].object--;
							}
						}
						pDoc->Objects[objn].Groups.RemoveAll();
						pDoc->Objects.RemoveAt(objn);
						pDoc->Objects.FreeExtra();
						pDoc->num.objects=pDoc->Objects.GetSize();
					}
					pDoc->num.vertices=pDoc->Verts.GetSize();
					pDoc->num.vertices--;
					for(int i=0; i<pDoc->Tris.GetSize(); i++){
						for (k=0; k<3; k++) {
							if (pDoc->Tris[i].vindex[k]==PClicked) pDoc->Tris[i].vindex[k]=PMapped;
							else if (pDoc->Tris[i].vindex[k]==pDoc->num.vertices) pDoc->Tris[i].vindex[k]=PClicked;
						}
					}
					pDoc->Verts[PClicked]=pDoc->Verts[pDoc->num.vertices];
					pDoc->Base->fv[PClicked].v[0]=pDoc->Base->fv[pDoc->num.vertices].v[0];
					pDoc->Base->fv[PClicked].v[1]=pDoc->Base->fv[pDoc->num.vertices].v[1];
					pDoc->Base->fv[PClicked].v[2]=pDoc->Base->fv[pDoc->num.vertices].v[2];
					pDoc->Base->fv[PClicked].vnormal=pDoc->Base->fv[pDoc->num.vertices].vnormal;
					pDoc->MapGen->fv[PClicked].v[0]=pDoc->MapGen->fv[pDoc->num.vertices].v[0];
					pDoc->MapGen->fv[PClicked].v[1]=pDoc->MapGen->fv[pDoc->num.vertices].v[1];
					pDoc->MapGen->fv[PClicked].v[2]=pDoc->MapGen->fv[pDoc->num.vertices].v[2];
					pDoc->MapGen->fv[PClicked].vnormal=pDoc->MapGen->fv[pDoc->num.vertices].vnormal;
					for (k=0; k<pDoc->Frames.GetSize(); k++){
						pDoc->Frames[k]->fv[PClicked].v[0]=pDoc->Frames[k]->fv[pDoc->num.vertices].v[0];
						pDoc->Frames[k]->fv[PClicked].v[1]=pDoc->Frames[k]->fv[pDoc->num.vertices].v[1];
						pDoc->Frames[k]->fv[PClicked].v[2]=pDoc->Frames[k]->fv[pDoc->num.vertices].v[2];
						pDoc->Frames[k]->fv[PClicked].vnormal=pDoc->Frames[k]->fv[pDoc->num.vertices].vnormal;
					}
					pDoc->Verts.RemoveAt(pDoc->num.vertices);
					pDoc->Verts.FreeExtra();
					pDoc->num.vertices=pDoc->Verts.GetSize();
					FindMinMaxAll(pDoc);
					pDoc->PrimeSort();
					pDoc->ColorSort();
					pDoc->UpdateAllViews(NULL);
				}
			}
*/		}
	} 
}

DROPEFFECT C2DView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	return CView::OnDragEnter(pDataObject, dwKeyState, point);
}

void C2DView::OnInitialUpdate() 
{
	//AfxMessageBox("Start Initial Update");
	
	Parent=(CChildFrame *)GetParentFrame();

	CMedDLeDoc *pDoc = (CMedDLeDoc *)GetDocument();
	
	Parent->m_wndSplitter.SetActivePane(0, 0, this);
	Parent->m_wndSplitter.GetActivePane(&row, &col);
	if (row == 1) { ViewNum = 2; Init = FALSE; }
	else if (col == 1) { ViewNum = 1; Init = FALSE; }
	else { ViewNum = 0; Init = TRUE; }
	Parent->Kids[row][col] = this;

	CRect rc;
	GetClientRect(&rc);
	int x[2];
	x[1]=rc.bottom;
	x[0]=rc.right;

	if (Init == TRUE)
	{
		float a;		
		pDoc->Scale= 1e10;

		for(int i=0; i<3; i++)
		{
			for (int j=0; j<2; j++)
			{
				if(pDoc->Extent[i][j]>0)
				{
					a= (float)x[j]/pDoc->Extent[i][j];
					if (a<pDoc->Scale) pDoc->Scale = a;
				}
			}   
		}
	}

//	int TResX;
//	for (TResX = (rc.right+1); TResX%4 != 0; TResX++);
//	if ((rc.bottom+1)*TResX > ResX*ResY) {
//		delete RAMScreen;
//		ResX = TResX;
//		ResY = rc.bottom+1;
//		RAMScreen = new BYTE[ResX*ResY];
//	}
	CView::OnInitialUpdate();
	//AfxMessageBox("End Initial Update");
}

void C2DView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);

//	Frame *f=pDoc->cur.frameptr;

	// Shift for global zoom, 
	if ((theApp.m_AppAction==AA_ZOOM) & !(nFlags & MK_RBUTTON))
	{
		pDoc->Center[ViewNum][0]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
		pDoc->Center[ViewNum][1]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
		pDoc->Zoom[ViewNum]*=2.f;
		InvalidateRect(NULL, 0);
	}
/*	else if((pDoc->EditMode == SM_SKEL))
	{
		int cnt;
		//AfxMessageBox("Add New Bone");
		pDoc->Skeleton.cnt++;
		cnt=pDoc->Skeleton.cnt;
		pDoc->Skeleton.hflags[cnt-1]=0;//O_SELECTED;
		pDoc->Skeleton.tflags[cnt-1]=0;//O_SELECTED;
		if(cnt==1) pDoc->Skeleton.parentindex[1]=-1;
		//add to base & mapgen
		pDoc->Base->bone[cnt-1].head[0]=0;
		pDoc->Base->bone[cnt-1].head[1]=0;
		pDoc->Base->bone[cnt-1].head[2]=0;
		pDoc->Base->bone[cnt-1].tail[0]=10.;
		pDoc->Base->bone[cnt-1].tail[1]=10.;
		pDoc->Base->bone[cnt-1].tail[2]=10.;
		pDoc->MapGen->bone[cnt-1].head[0]=0;
		pDoc->MapGen->bone[cnt-1].head[1]=0;
		pDoc->MapGen->bone[cnt-1].head[2]=0;
		pDoc->MapGen->bone[cnt-1].tail[0]=10.;
		pDoc->MapGen->bone[cnt-1].tail[1]=10.;
		pDoc->MapGen->bone[cnt-1].tail[2]=10.;
		// add to rest
		for(int i=0; i<pDoc->Frames.GetSize(); i++)
		{
			pDoc->Frames[i]->bone[cnt-1].head[0]=0;
			pDoc->Frames[i]->bone[cnt-1].head[1]=0;
			pDoc->Frames[i]->bone[cnt-1].head[2]=0;
			pDoc->Frames[i]->bone[cnt-1].tail[0]=10.;
			pDoc->Frames[i]->bone[cnt-1].tail[1]=10.;
			pDoc->Frames[i]->bone[cnt-1].tail[2]=10.;
		//	pDoc->Frames[i]->bone[cnt-1].length;
		//	pDoc->Frames[i]->bone[cnt-1].twist;

		}
/*		if (f != NULL) {
			pDoc->RotHead[0]=f->fbboxmax.v[0];
			pDoc->RotHead[1]=f->fbboxmax.v[1];
			pDoc->RotHead[2]=f->fbboxmax.v[2];
			pDoc->RotTail[0]=f->fbboxmin.v[0];
			pDoc->RotTail[1]=f->fbboxmin.v[1];
			pDoc->RotTail[2]=f->fbboxmin.v[2];
		
			pDoc->RotHead[pDoc->AxisMap[ViewNum][0]]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
			pDoc->RotHead[pDoc->AxisMap[ViewNum][1]]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
			pDoc->RotTail[pDoc->AxisMap[ViewNum][0]]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
			pDoc->RotTail[pDoc->AxisMap[ViewNum][1]]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
			pDoc->RotHSel=0;
			pDoc->RotTSel=0;
		} else {
			pDoc->RotHead[0]=0;
			pDoc->RotHead[1]=0;
			pDoc->RotHead[2]=20;
			pDoc->RotTail[0]=0;
			pDoc->RotTail[1]=0;
			pDoc->RotTail[2]=-20;
			pDoc->RotHSel=0;
			pDoc->RotTSel=0;
		}
		*/
/*		CDC *Context=GetDC();
		OnDraw(Context);
		ReleaseDC(Context);
		pDoc->UpdateAllViews(this);
		
	}
*/
/*	else if(theApp.m_AppAction==AA_ROTATE)
	{
		if (f != NULL) 
		{
			pDoc->RotHead[0]=f->fbboxmax.v[0];
			pDoc->RotHead[1]=f->fbboxmax.v[1];
			pDoc->RotHead[2]=f->fbboxmax.v[2];
			pDoc->RotTail[0]=f->fbboxmin.v[0];
			pDoc->RotTail[1]=f->fbboxmin.v[1];
			pDoc->RotTail[2]=f->fbboxmin.v[2];
		
			pDoc->RotHead[pDoc->AxisMap[ViewNum][0]]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
			pDoc->RotHead[pDoc->AxisMap[ViewNum][1]]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
			pDoc->RotTail[pDoc->AxisMap[ViewNum][0]]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
			pDoc->RotTail[pDoc->AxisMap[ViewNum][1]]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
			pDoc->RotHSel=0;
			pDoc->RotTSel=0;
		} 
		else 
		{
			pDoc->RotHead[0]=0;
			pDoc->RotHead[1]=0;
			pDoc->RotHead[2]=20;
			pDoc->RotTail[0]=0;
			pDoc->RotTail[1]=0;
			pDoc->RotTail[2]=-20;
			pDoc->RotHSel=0;
			pDoc->RotTSel=0;
		}
		CDC *Context=GetDC();
		OnDraw(Context);
		ReleaseDC(Context);
		pDoc->UpdateAllViews(this);

	} 
/*	
	else if (pDoc->TriAdd) 
	{
		Triangle tri;
		VertData vrt;
		if (pDoc->Verts.GetSize()<1996) {
			Group* newgroup=new Group;
			int numobj=pDoc->Objects.GetSize();
			pDoc->Objects.SetSize(numobj+1);
			pDoc->Objects[numobj].Groups.RemoveAll();
			pDoc->Objects[numobj].color=0;
			pDoc->Objects[numobj].viscolor=0;
			pDoc->Objects[numobj].dummy=0;
			pDoc->Objects[numobj].flags=O_SELECTED;
			strcpy(pDoc->Objects[numobj].name, "unnamednew");
			pDoc->Objects[numobj].Groups.Add(newgroup);
			strcpy(pDoc->Objects[numobj].Groups[0]->name, "unassigned");
			pDoc->Objects[numobj].Groups[0]->flags=O_SELECTED;
			pDoc->Objects[numobj].Groups[0]->dummy=0;
			pDoc->Objects[numobj].Groups[0]->viscolor=0;
			pDoc->Objects[numobj].Groups[0]->color=0;
			for (int i=0; i<3; i++){
				pDoc->Base->fv[pDoc->Verts.GetSize()].v[0]=pDoc->Triloc[i][0];
				pDoc->Base->fv[pDoc->Verts.GetSize()].v[1]=pDoc->Triloc[i][1];
				pDoc->Base->fv[pDoc->Verts.GetSize()].v[2]=pDoc->Triloc[i][2];
				pDoc->Base->fv[pDoc->Verts.GetSize()].vnormal=0;
				pDoc->MapGen->fv[pDoc->Verts.GetSize()].v[0]=pDoc->Triloc[i][0];
				pDoc->MapGen->fv[pDoc->Verts.GetSize()].v[1]=pDoc->Triloc[i][1];
				pDoc->MapGen->fv[pDoc->Verts.GetSize()].v[2]=pDoc->Triloc[i][2];
				pDoc->MapGen->fv[pDoc->Verts.GetSize()].vnormal=0;
				for (int j=0; j<pDoc->Frames.GetSize(); j++){
					pDoc->Frames[j]->fv[pDoc->Verts.GetSize()].v[0]=pDoc->Triloc[i][0];
					pDoc->Frames[j]->fv[pDoc->Verts.GetSize()].v[1]=pDoc->Triloc[i][1];
					pDoc->Frames[j]->fv[pDoc->Verts.GetSize()].v[2]=pDoc->Triloc[i][2];
					pDoc->Frames[j]->fv[pDoc->Verts.GetSize()].vnormal=0;
				}
				pDoc->Trimap[i]=pDoc->Verts.GetSize();
				vrt.object=numobj;
				vrt.group=0;
				vrt.x=10;
				vrt.y=10;
				vrt.flags=O_SELECTED;
				pDoc->Verts.Add(vrt);
				pDoc->Gflags &= ~S_HAS_SKIN;
				pDoc->num.vertices=pDoc->Verts.GetSize();
				tri.vindex[i]=pDoc->Trimap[i];
			}
			tri.flags=0;
			tri.Vflags=O_SELECTED;
			pDoc->Tris.Add(tri);
			pDoc->num.triangles=pDoc->Tris.GetSize();
			pDoc->TriAdd=FALSE;
		} 
		else 
		{
			pDoc->TriAdd=FALSE;
			AfxMessageBox("You have reached the 2000 vertex limit");
		}
		pDoc->PrimeSort();
		FindMinMaxAll(pDoc);
		pDoc->ColorSort();
		pDoc->UpdateAllViews(NULL);
	}
	*/
}

void C2DView::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);

	if ((theApp.m_AppAction==AA_ZOOM) & !(nFlags & MK_LBUTTON))
	{
		pDoc->Center[ViewNum][0]=pDoc->AxisDir[ViewNum][0]*(point.x-rc.right/2.f)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][0]; 
		pDoc->Center[ViewNum][1]=pDoc->AxisDir[ViewNum][1]*(rc.bottom/2.f-point.y)/(pDoc->Scale*pDoc->Zoom[ViewNum])+pDoc->Center[ViewNum][1]; 
		pDoc->Zoom[ViewNum]*=.5f;
		InvalidateRect(NULL, 0);
	}
}

BOOL C2DView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void C2DView::OnViewIn() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pDoc->Vflags[ViewNum] &= ~R_FB;
//	InvalidateRect(NULL, 0);
}

void C2DView::OnViewOut() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pDoc->Vflags[ViewNum] |= R_FB;
//	InvalidateRect(NULL, 0);
}

void C2DView::OnUpdateViewIn(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Vflags[ViewNum]&R_FB) pCmdUI->SetCheck(FALSE);
//	else pCmdUI->SetCheck(TRUE);
}

void C2DView::OnUpdateViewOut(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pCmdUI->SetCheck(pDoc->Vflags[ViewNum]&R_FB);
}

void C2DView::OnViewSolid() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	if (pDoc->Vflags[ViewNum]&R_SOLID) pDoc->Vflags[ViewNum] &= ~R_SOLID;
//	else pDoc->Vflags[ViewNum] |= R_SOLID;
//	InvalidateRect(NULL, 0);
}

void C2DView::OnUpdateViewSolid(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pCmdUI->SetCheck(pDoc->Vflags[ViewNum]&R_SOLID);
}

void C2DView::OnViewVerts() 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();	
//	if (pDoc->Vflags[ViewNum]&R_VERT) pDoc->Vflags[ViewNum] &= ~R_VERT;
//	else pDoc->Vflags[ViewNum] |= R_VERT;
//	InvalidateRect(NULL, 0);
}

void C2DView::OnUpdateViewVerts(CCmdUI* pCmdUI) 
{
//	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
//	pCmdUI->SetCheck(pDoc->Vflags[ViewNum]&R_VERT);
}

void C2DView::TriHit(CPoint point)
{
/*	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	ASSERT_VALID(pDoc);
	
	pDoc->HitIndex.RemoveAll();
	// get size of windows
    CRect rc;    
	GetClientRect(&rc);

	// this is the width, height (resolution)
	int resx, resy; 
	resx=rc.right+1;
	resy=rc.bottom+1;

	point.y=resy-point.y;

	// don't ask how I know..
	while(resx%4!=0) resx++;
	
	BG_Init3dWindow(resx, resy);


	float w = (float)rc.right;
	float h = (float)rc.bottom;

	if((h==0)||(w==0)) return;
	int view=ViewNum;	
	// new scale variable taking into account the zoom
	float zoomedscale;
	zoomedscale=pDoc->Scale*pDoc->Zoom[view];
	//centers of window, view area must coincide
	float offset[2];
	offset[0]=pDoc->Center[ViewNum][0];
	offset[1]=pDoc->Center[ViewNum][1];
	// figure out direction of axis and correct for it
	int xc,yc;
	xc = rc.right/2;
	yc = rc.bottom/2;

	long v1,v2,x1,x2,y1,y2;


	if(pDoc->cur.frameptr != NULL)
	{
		int i,j,k,l;
		int adir,asign;

		asign = -1;
		if (pDoc->Vflags[view] & R_FB) asign=1;

		adir=0;
		for(i=0; i<3; i++)
		{
			if((pDoc->AxisMap[view][1]!=i)&&(pDoc->AxisMap[view][0]!=i)) {adir=i; break;}
		}
		
		float norm[3];
		for(k=0; k <pDoc->Tris.GetSize(); k++)
		{
			xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[0]].v[adir];
			for(l=1; l < 3; l++)
			{
				if(asign==1) 
				{
					if(pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir] < xlist[k]) 
						xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir];
				}
				else 
				{
					if(pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir] > xlist[k]) 
						xlist[k]=pDoc->cur.frameptr->fv[pDoc->Tris[k].vindex[l]].v[adir];
				}
			}
			xindexlist[k]=k;
		}
			
		// now sort polys by furthest point (or closest?)
		
		sort(xlist,xindexlist,0,pDoc->Tris.GetSize()-1);
		
		int t[8];
		int vi[3];
		int si;
		int min[2], max[2];
		for(i=0; i<pDoc->Tris.GetSize(); i++)
		{	
			if(asign==1) 
				si=xindexlist[i];
			else 
				si=xindexlist[pDoc->Tris.GetSize()-i-1];
			if (!(pDoc->Tris[si].Vflags&O_VHIDDEN)) 
			{
				for(j=0; j<3; j++)
				{
					vi[j]=pDoc->Tris[si].vindex[j];
					t[j*2]=xc+
						(pDoc->cur.frameptr->fv[vi[j]].v[pDoc->AxisMap[view][0]]-offset[0])
						*(zoomedscale*pDoc->AxisDir[view][0]);
					
					t[j*2+1]=yc+
						(pDoc->cur.frameptr->fv[vi[j]].v[pDoc->AxisMap[view][1]]-offset[1])
						*(zoomedscale*pDoc->AxisDir[view][1]);
					if(j==0) {
						min[0]=t[j*2];
						min[1]=t[j*2+1];
						max[0]=t[j*2];
						max[1]=t[j*2+1];
					} else {
						if (t[j*2]<min[0]) min[0]=t[j*2];
						else if (t[j*2]>max[0]) max[0]=t[j*2];
						if (t[j*2+1]<min[1]) min[1]=t[j*2+1];
						else if (t[j*2+1]>max[1]) max[1]=t[j*2+1];
					}
				}
				t[6]=t[0];
				t[7]=t[1];
				if ((point.x>min[0]) && (point.x<max[0]) && (point.y>min[1]) && (point.y<max[1])) {
					if(G_hit_polygon(t,3,point))
					{
//						if(asign==1)
							pDoc->HitIndex.Add(si);
//						else 
//							pDoc->HitIndex.InsterAt(0,xindexlist[i]);
					}
				}
			}
		}
	}
	*/
}

void C2DView::OnAddselbone() 
{
	//m_ViewAction=A_PICKBONE;
	
}

void C2DView::OnEditUndo() 
{
	// TODO: Add your command handler code here
	
}

void C2DView::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	
}

int C2DView::HitPointIndex(CPoint &pt)
{
	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rc;
	GetClientRect(&rc);


	if(!pDoc->m_MedDLeObject.m_curFrame)
	{
		return -1;
	}
	float zoomedscale, offset[2], v[2];
	int xc[2],x[2];
	
	offset[0]=pDoc->Center[ViewNum][0];
	offset[1]=pDoc->Center[ViewNum][1];
	xc[0] = rc.right/2;
	xc[1] = rc.bottom/2;

	zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];

	UINT closest, r;
	const int HIT_TOLERANCE=6;

	closest=4*HIT_TOLERANCE*HIT_TOLERANCE;
// maybe better to do the other way (less multiply, but uses float (convert pt first))
	int VertexIndex=-1;
	for(int i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
	{

		if(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE)
		{
			v[0] = pDoc->m_MedDLeObject.m_curFrame->v[i].x[pDoc->AxisMap[ViewNum][0]];
			v[1] = pDoc->m_MedDLeObject.m_curFrame->v[i].x[pDoc->AxisMap[ViewNum][1]];

			x[0] = xc[0]+(v[0]-offset[0])*(zoomedscale*pDoc->AxisDir[ViewNum][0]);
			x[1] = xc[1]+(v[1]-offset[1])*(zoomedscale*-pDoc->AxisDir[ViewNum][1]);

			// if hit
			if( (pt.x> x[0]-HIT_TOLERANCE ) && (pt.x< x[0]+HIT_TOLERANCE)
			&& (pt.y>x[1]-HIT_TOLERANCE) && (pt.y<x[1]+HIT_TOLERANCE) )
			{
				r=(x[0]-pt.x)*(x[0]-pt.x)+(x[1]-pt.y)*(x[1]-pt.y);
				// get closest in that range
				if(r<=closest)
				{
					closest=r;
					VertexIndex=i;
				}
			}
		}
	}
	
	return VertexIndex;
}

void C2DView::SelectRect(CRect &rc)
{

	CMedDLeDoc* pDoc = (CMedDLeDoc*)GetDocument();
	CRect rcv;
	GetClientRect(&rcv);

	if(!pDoc->m_MedDLeObject.m_curFrame) return;

	float zoomedscale;
	float xmin,xmax,ymin,ymax,vx,vy;
	
	zoomedscale=pDoc->Scale*pDoc->Zoom[ViewNum];

	xmin = ((pDoc->m_ptSelection0.x-(rcv.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
	ymin = ((pDoc->m_ptSelection0.y-(rcv.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
	xmax = ((pDoc->m_ptSelection1.x-(rcv.right/2))/(zoomedscale*pDoc->AxisDir[ViewNum][0]))+pDoc->Center[ViewNum][0];
	ymax = ((pDoc->m_ptSelection1.y-(rcv.bottom/2))/(zoomedscale*-pDoc->AxisDir[ViewNum][1]))+pDoc->Center[ViewNum][1];
	
	float swp;

	if(xmax<xmin)
	{
		swp=xmax;
		xmax=xmin;
		xmin=swp;
	}

	if(ymax<ymin)
	{
		swp=ymax;
		ymax=ymin;
		ymin=swp;
	}

	for(int i=0; i<pDoc->m_MedDLeObject.m_BaseFrame->v.GetSize(); i++)
	{
		if(pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&V_VISIBLE)
		{

			vx = pDoc->m_MedDLeObject.m_curFrame->v[i].x[pDoc->AxisMap[ViewNum][0]];
			vy = pDoc->m_MedDLeObject.m_curFrame->v[i].x[pDoc->AxisMap[ViewNum][1]];
			// if hit
			if( (vx > xmin ) && (vx < xmax) && (vy > ymin) && ( vy < ymax) )
				pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags|=V_TEMP_SELECTED;
			else 
				pDoc->m_MedDLeObject.m_BaseFrame->v[i].flags&=~V_TEMP_SELECTED;

		}
	}
	


}
