function onMouseEvent(event, output) {

  var text = "Mouse Event: ";

  if (event.type == MMouseEvent.MOVE) {
    text += "Move ";
  } else if (event.type == MMouseEvent.LBUTTON_DOWN) {
    text += "Left Down ";
  } else if (event.type == MMouseEvent.LBUTTON_UP) {
    text += "Left Up";
  } else if (event.type == MMouseEvent.LBUTTON_DBLCLK) {
    text += "Left Dbl";
  } else if (event.type == MMouseEvent.MBUTTON_DOWN) {
    text += "Middle Down";
  } else if (event.type == MMouseEvent.MBUTTON_UP) {
    text += "Middle Up";
  } else if (event.type == MMouseEvent.MBUTTON_DBLCLK) {
    text += "Middle dbl";
  } else if (event.type == MMouseEvent.RBUTTON_DOWN) {
    text += "Right down";
  } else if (event.type == MMouseEvent.RBUTTON_UP) {
    text += "Right up";
  } else if (event.type == MMouseEvent.RBUTTON_DBLCLK) {
    text += "Right double";
  }

  text += " (" + event.x + ", " + event.y + ")";
  output.value = text;

}

function mouseEventExample() {

  var mainWindow = new MWindow();
  mainWindow.setLayoutManager(new MBorderLayout());

  var mouseTester = new MContainer();
 
  mainWindow.addComponent(mouseTester, MBorderLayout.CENTRE);

  var output = new MTextField("Output goes here...");
  mainWindow.addComponent(output, MBorderLayout.SOUTH);

  mouseTester.addMouseListener(onMouseEvent, output);

  mainWindow.setSize(mainWindow.getMinimumSize());
  mainWindow.setVisible(true);	

}

mouseEventExample();