/**
 * This groups the current selection of objects together. If there is an 
 * argument present, it uses that argument as the name of the new group.
 */
function groupSelectedObjects() {

  var object;
  
  // if we have an optional argument, assume its our new name.
  if (arguments.length > 0) {
    object = Scene.createObject('group', arguments[0]);
  } else {
    object = Scene.createObject('group');
  }

  // now that we have our object, add it to our selection, and reparent.
  Scene.selectObject(object);

  Scene.reparentSelection();

  return object;
}
