function onAccept(field, caption) {
	field.value = "Accepted! - " + caption;
}

function onCancel(field, caption) {
	field.value = "Cancelled! - " + caption;
}

function createItem(container, caption, width) {
  var label = new MLabel(caption);
  var editBox = new MTextField("", width);

  container.addComponent(label);
  container.addComponent(editBox);

  editBox.addAcceptListener(onAccept, caption);
  editBox.addCancelListener(onCancel, caption);
}

function textFieldsExample() {

  var mainWindow = new MWindow();
  // the flow layout takes three args, the x and y margins, 
  // and then the number of components per row
  mainWindow.setLayoutManager(new MFlowLayout(2,2,2));

  createItem(mainWindow, "Label 1", 15);
  createItem(mainWindow, "Label 2", 10);
  createItem(mainWindow, "Label 3", 12);

  mainWindow.setVisible(true);	

}

textFieldsExample();