#ifndef PICTRANSLATOR_H
#define PICTRANSLATOR_H

#include <translator/MImageTranslator.h>

using namespace Aztec;


class MPICTranslator : public MImageTranslator {
protected:

public:
   MPICTranslator();
   virtual ~MPICTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MPICTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.PIC"; }
   std::string getFilterDescription() { return "PIC Images"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
