#ifndef MD3TRANSLATOR_H
#define MD3TRANSLATOR_H

#include <translator/MSceneTranslator.h>

#include <stdio.h>
#include <vector>

using std::vector;

using namespace Aztec;

class MMD3Translator : public MSceneTranslator {
protected:

public:
  MMD3Translator();
  virtual ~MMD3Translator();
  
  /**
   * This exports the given object, and all its decendants
   * to an the given md3 file. If the object is null,
   * the entire scene heirarchy will be used. An object will
   * not be included in the export if it is a child
   * of an object in the exclude list.
   */
  bool exportObject(MStr filename, MScenePtr scene, MSceneObjectPtr rootObj, const vector<MTreeObjectNodePtr> &exclude);
  
  /**
   * This imports the file, but also passes back the scene object
   * which is the group of all the objects created.
   */
  bool importFile(MStr Filename, MScenePtr Scene, MSceneObjectPtr &groupObj);

  // Class related
  virtual MStr getClassName() {return MStr("MMD3Translator");};
  virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
  virtual MTranslatorPtr createNew() const;
  
  std::string getFilter() { return "*.MD3"; }
  std::string getFilterDescription() { return "Quake3 Models"; }
  virtual bool canImport() {return true;};
  virtual bool canExport() {return false;};
  virtual bool canImportFile(MStr Filename);
  
  virtual bool importFile(MStr Filename, MScenePtr Scene);
  virtual bool exportFile(MStr Filename, MScenePtr Scene);
};


// Quake3 test file format and Header file used from Mental Vortex. Thumbs up lads!
#define MD3_FILEID     (('3'<<24)+('P'<<16)+('D'<<8)+'I')
#define MD3_VERSION    15


// ensure that we have byte aligned structs
#pragma pack( push, md3_include )
#pragma pack(1)

typedef float     MD3Vec3[3];
typedef float     MD3Vec2[2];
typedef MD3Vec3  MD3Mat3x3[3];

#define MAX_QPATH 64

class MD3Header {
public:
  MD3Header();

  int         ID;         //id of file, always "IDP3"
  int         Version;      //i suspect this is a version number, always 15
  char        FileName[MAX_QPATH];  //sometimes left Blank
  int         flags;
  int         numTagFrames;
  int         numTags;
  int         numMeshes;
  int         numSkins;
  int         framesStart;
  int         tagStart;    //starting position of tag-structures
  int         meshStart;      // Start of the meshes
  int         FileSize;    //size of file
};

typedef struct {
  char        Name[MAX_QPATH];  //name of 'tag' as it's usually called in the md3 files
  MD3Vec3     origin;
  MD3Mat3x3   Matrix;        //3x3 rotation matrix
} MD3Tag;

class MD3TagFrame {
public:
  float       Mins[3];
  float       Maxs[3];
  float       localOrigin[3];
  float       radius;
  char        Creator[16];
  
  MD3Tag*     Tags;

};

typedef struct {
  int       ID;
  char      Name[MAX_QPATH];
  int       flags;      
  int       NumFrames;       
  int       numShaders;      
            
  int       NumVerts;      //number of vertices
  int       NumTris;          //number of Triangles
  int       Triangle_Start;   //starting position of Triangle data, relative to start of Mesh_Header
  int       Shader_Start;      //size of header
  int       SkinVerts_Start;  //starting position of texvector data, relative to start of Mesh_Header
  int       Vertex_Start;    //starting position of vertex data, relative to start of Mesh_Header
  int       ChunkSize;      //size of mesh
} MD3MeshHeader;

typedef struct {
  char      name[MAX_QPATH];
  int       shaderIndex;  // for in game use.
} MD3ShaderHeader;

typedef DWORD  MD3Triangle[3];  //vertex 1,2,3 of triangle

typedef MD3Vec2  MD3SkinVertex;      //Texture U/V coordinates of vertex 

typedef struct {
  short     Vec[3];           //vertex X/Y/Z coordinate
  short     normal;
} MD3Vertex;

typedef struct 
{
  MD3Vertex*  Vertices;
} MD3MeshFrame;

class MD3Mesh {
public:
   MD3Mesh();
   ~MD3Mesh();

  MD3MeshHeader        Header;
  MD3ShaderHeader*       SkinNames;
  MD3Triangle*         Triangles;
  MD3SkinVertex*       SkinVerts;
  MD3MeshFrame*        Frames;
};

class MD3Model {
public:
  MD3Model();
  ~MD3Model();

  int readFromFile(FILE *hFile);
  int writeToFile(FILE *hFile);

  MD3Header header;
  MD3TagFrame *tagFrames;
  MD3Mesh *surfaces;
};

#pragma pack( pop, md3_include )

#endif

