#ifndef DotGraphExporter_Header
#define DotGraphExporter_Header

#include <translator/MSceneTranslator.h>
#include "MEditableMesh.h"

#include <stdio.h>

using namespace Aztec;

class DotGraphExporter : public MSceneTranslator {
protected:
   int      m_TabCount;

public:
   DotGraphExporter();
   virtual ~DotGraphExporter();


   // Class related
   virtual MStr getClassName() {return MStr("DotGraphExporter");};
   virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.dot"; }
   std::string getFilterDescription() { return "DOT Graph Files"; }
   virtual bool canImport() {return false;};
   virtual bool canExport() {return true;};
   virtual bool canImportFile(MStr Filename) { return false; }

   virtual bool exportFile(MStr Filename, MScenePtr Scene);

};


#endif
