#ifndef PovrayTranslator_Header
#define PovrayTranslator_Header

#include <translator/MSceneTranslator.h>
#include <MLight.h>

#include <stdio.h>
#include <string>

using namespace Aztec;


class PovrayTranslator : public MSceneTranslator {
protected:
  
public:
  PovrayTranslator();
  ~PovrayTranslator();

  bool exportFile(const MStr &Filename, 
                  const MScenePtr &sceme, 
                  const MParameterObjectListPtr &options);

  // MSceneTranslator methods
  bool importFile(MStr Filename, MScenePtr Scene);
  bool exportFile(MStr Filename, MScenePtr Scene);

  // MTranslator methods
  MTranslatorPtr createNew() const;
  std::string getFilter();
  std::string getFilterDescription();
  bool canImport();
  bool canExport();
  bool canImportFile(MStr Filename);
  MStr getClassName();

private:
  void writeOutObjects(FILE *out, const MScenePtr &scene);
  void writeSceneShape(FILE *out, const MScenePtr &scene, const MSceneObjectPtr &object);
  void writeSceneObject(FILE *out, const MScenePtr &scene, const MSceneObjectPtr &object);
  void writeShapeObject(FILE *out, const MScenePtr &scene, const MShapeObjectPtr &shape);
  void writeLightObject(FILE *out, const MScenePtr &scene, const MLightPtr &light);
  void writeMeshObject(FILE *out, const MScenePtr &scene, const MMeshPtr &mesh);

  std::set<MSceneObjectPtr> objectsWritten;
};

#endif
