// DomainEditDlg.h: interface for the CDomainEditDlg class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DOMAINEDITDLG_H__INCLUDED_)
#define AFX_DOMAINEDITDLG_H__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "dialogs/ParticleActionDlgBase.h"

class CDomainEditDlg : public CParticleActionDlgImpl<CDomainEditDlg>
{
public:
	CDomainEditDlg();
	virtual ~CDomainEditDlg();

	void setEntriesFromParams(int startIndex, particleParamType &entries);
	void getParamsFromEntries(particleParamType &params);

protected:
	PDomainEnum m_Domain;
	float x1, y1, z1;
	float x2, y2, z2;
	float x3, y3, z3;
	float nx, ny, nz;
	float r1, r2;
	float stddev;
	// float friction, resilience, cutoff;
	// float magnitude, epsilon, look_ahead;
	// bool kill_inside;

	virtual void setEditLayout(PDomainEnum domain);
public:
	enum { IDD = IDD_DOMAIN_DIALOG };

	BEGIN_MSG_MAP(CParticleParamDlg)
	   	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)

		COMMAND_HANDLER(IDC_ATTRIBUTE_SOURCE_COMBO, CBN_SELCHANGE, OnComboChange)
	END_MSG_MAP()

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnComboChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
};

#endif // !defined(AFX_DOMAIN_EDITDLG_H__29F26AAA_98B1_4390_ABBD_D648AE8FBC94__INCLUDED_)
