function onAccept(field, caption) {
  field.value = "Accepted! - " + caption;
}

function onCancel(field, caption) {
  field.value = "Cancelled! - " + caption;
}

function createItem(container, caption, width) {
  var label = new MLabel(caption);
  var editBox = new MTextField("", width);

  container.addComponent(label);
  container.addComponent(editBox);

  editBox.addAcceptListener(onAccept, caption);
  editBox.addCancelListener(onCancel, caption);
}

function okclick(window) {
  window.close();
}

function cancelclick(window) {
  window.close();
}

function addBottomStrip(window) {
  var strip = new MContainer();
  strip.setLayoutManager(new MBorderLayout());
  window.addComponent(strip, MBorderLayout.SOUTH);

  var cont = new MContainer();
  cont.setLayoutManager(new MGridLayout(2,1));
  strip.addComponent(cont, MBorderLayout.EAST);

  var ok = new MButton("Ok");
  var cancel = new MButton("Cancel");

  cont.addComponent(ok);
  cont.addComponent(cancel);

  ok.addListener(okclick, window);
  cancel.addListener(cancelclick, window);
}

function tabbedContainerExample() {

  var mainWindow = new MWindow();
  // the flow layout takes three args, the x and y margins, 
  // and then the number of components per row
  mainWindow.setLayoutManager(new MBorderLayout());


  var tabbed = new MTabbedContainer();
  mainWindow.addComponent(tabbed, MBorderLayout.CENTRE);
  var container1 = tabbed.addPane("Test 1");
  var container2 = tabbed.addPane("Test 2");
  var container3 = tabbed.addPane("Test 3");

  container1.setLayoutManager(new MFlowLayout(2,2,2));
  container2.setLayoutManager(new MFlowLayout(2,2,2));
  container3.setLayoutManager(new MFlowLayout(2,2,2));

  createItem(container1, "Label 1", 15);
  createItem(container1, "Label 2", 10);
  createItem(container2, "Label 3", 12);

  addBottomStrip(mainWindow);

  mainWindow.setVisible(true);


}

tabbedContainerExample();