
#include <gui/MApplication.h>

#include <gui/MWindow.h>
#include <gui/MButton.h>
#include <gui/MTextField.h>
#include <gui/MFlowLayout.h>


class HelloWorld : public Aztec::MApp {
public:

  bool initApp() {
    Aztec::MWindowPtr mainWindow = new Aztec::MWindow("Hello World");

    // we have to explicitly create top level windows. All other controls are auto created.
    if (!mainWindow->create()) {
      // if the window creation failed, bail out.
      return false;
    }

    mainWindow->setSize(400,400);

    // The layout manager takes care of the placement of components. See some 
    // other examples to see this in action.
    mainWindow->setLayoutManager(new Aztec::MFlowLayout());

    // make a lot of buttons
    for (int i = 0; i < 20; ++i) {
      if (i % 2) {
        Aztec::MButtonPtr button = new Aztec::MButton();
        mainWindow->addComponent(button);
        button->setCaption("Hello World!");
      }
      else {
        Aztec::MTextFieldPtr textfield = new Aztec::MTextField();
        mainWindow->addComponent(textfield);
        textfield->setValue("AZTEc iS Teh kEwl!!!!!");
      }
    }

    // Now display our main window.
    mainWindow->setVisible(true);

    // return true to indicate that eveything started up okay.
    return true;
  }

  void cleanup() {
  }

};


AZTEC_USE_APP(HelloWorld)

