#ifndef LightShapePlugin_Header
#define LightShapePlugin_Header

#include <AztecGUIMParameterPlugin.h>
#include <LightShapeDlg.h>
#include <MLight.h>

class LightShapePlugin : public AztecGUI::MParameterPlugin {
public:
  LightShapePlugin();
  ~LightShapePlugin();

  // MParameterPlugin methods
  std::string getFriendlyName();
  bool isUIForObject(const Aztec::MBaseObjectPtr &obj);
  void createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object);
  void destroyControls();
  void cancelChanges();
  void updateGUIValues(const Aztec::MBaseObjectPtr &object);

private:
  Aztec::MLightPtr lightShape;
  CLightShapeDlg *dlg;

};



#endif