// SceneViewWnd.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "SceneViewWnd.h"

#include "resource.h"

#include "MDLGlobs.h"
#include "DLgGlobs.h"
#include "MdlMsgs.h"

#include "KeyFuncMain.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TEREVIEW_YDIFF           4
#define TREEVIEW_INDENT          24
#define TREEVIEW_FONTSIZE        12

/////////////////////////////////////////////////////////////////////////////
// CSceneViewWnd

CSceneViewWnd::CSceneViewWnd() {
  m_FilterFlags.setFlag(OBJECTFLAG_TYPE_MESH | OBJECTFLAG_TYPE_LIGHT | OBJECTFLAG_TYPE_CAMERA | OBJECTFLAG_TYPE_MATERIAL | OBJECTFLAG_TYPE_HELPER);
  m_DraggingNode = NULL;
  m_DragTargetNode = NULL;
  m_Dragging = false;
}

CSceneViewWnd::~CSceneViewWnd() {
}

MBaseObjectPtr CSceneViewWnd::createNew() {
  CSceneViewWnd  *Wnd;
  
  Wnd = new CSceneViewWnd;
  Wnd->setName(getName());
  
  return (MBaseObject*)Wnd;
}

BEGIN_MESSAGE_MAP(CSceneViewWnd, CWnd)
//{{AFX_MSG_MAP(CSceneViewWnd)
ON_WM_PAINT()
ON_WM_CREATE()
ON_WM_LBUTTONDOWN()
ON_WM_LBUTTONUP()
ON_WM_MBUTTONDOWN()
ON_WM_MBUTTONUP()
ON_WM_RBUTTONDOWN()
ON_WM_RBUTTONUP()
ON_WM_SIZE()
ON_WM_VSCROLL()
ON_WM_HSCROLL()
ON_WM_KEYDOWN()
ON_WM_CLOSE()
ON_WM_MOUSEMOVE()
ON_WM_MOUSEWHEEL()
ON_WM_ERASEBKGND()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CSceneViewWnd::ViewCreate()
{
  MBaseViewWnd::ViewCreate();
  
}

static HDC global_DC = NULL;

bool CSceneViewWnd::shouldDrawNode(MBaseObjectPtr obj) {
  if (obj == NULL) {
    return false;
  }
  
  if (AZTEC_CAST(MShapeObject, obj) != NULL) {
    return false;
  }
  
  if (AZTEC_CAST(MMesh, obj) != NULL) {
    return false;
  }
  
  if (!obj->isFlagged( m_FilterFlags.getFlags() & OBJECTFLAG_TYPE_ALL ) ) {
    return false;
  }

  return true;
}

void CSceneViewWnd::DrawView()
{
  MBaseViewWnd::DrawView();

  static      DrawCount = 0;
  
  HBRUSH      hBrush;
  HFONT       hFont, hOldFont;
  RECT        ClientRect;
  
  DrawCount++;
  if (DrawCount > 2)
  {
    DrawCount--;
    return;
  }
  
  GetClientRect(&ClientRect);
  
  HDC     hDC;
  HBITMAP hBitmap, hOldBitmap;

  if (NULL != global_DC)
  {
    hBitmap = ::CreateCompatibleBitmap(global_DC, ClientRect.right, ClientRect.bottom);
    hDC     = ::CreateCompatibleDC(global_DC);

    hOldBitmap = (HBITMAP)::SelectObject(hDC, hBitmap);
  } else {
    HDC  hdc = ::GetDC(m_hWnd);

    hBitmap = ::CreateCompatibleBitmap(hdc, ClientRect.right, ClientRect.bottom);
    hDC     = ::CreateCompatibleDC(hdc);

    hOldBitmap = (HBITMAP)::SelectObject(hDC, hBitmap);

    ::ReleaseDC(m_hWnd, hdc);
  }


  hBrush = ::CreateSolidBrush(::GetSysColor(COLOR_WINDOW));
  FillRect(hDC, &ClientRect, hBrush);
  ::DeleteObject(hBrush);
  
  if (g_Scene == NULL) {
    if (global_DC == NULL) {
        ::DeleteDC(hDC);
        ::DeleteObject(hBitmap);
    }
    return;
  }
  
  hFont = ::CreateFont(TREEVIEW_FONTSIZE, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
  hOldFont = (HFONT)SelectObject(hDC, hFont);
  
  SetBkMode(hDC, TRANSPARENT);
  
  
  MBaseObjectTreePtr Tree;
  MBaseObjectPtr BaseObj;
  MNamedObjectPtr Obj;
  MTreeObjectNodePtr Node;
  
  int               YPos, XPos, ScrollOffsetY, ScrollOffsetX, ScrollMaxX;
  
  ScrollMaxX = 0;
  ScrollOffsetY = GetScrollPos(SB_VERT);
  ScrollOffsetX = GetScrollPos(SB_HORZ);
  
  
  YPos = ClientRect.top + 20 - ScrollOffsetY;
  
  Tree = g_Scene->getObjectList();
  
  Tree->beginIteration();
  while (( BaseObj = Tree->getNext() ) != NULL ) {
    Obj = AZTEC_CAST(MNamedObject, BaseObj);
    
    if (!shouldDrawNode(Obj)) {
      continue;
    }
    
    Node = Tree->getCurrentNode();
    
    char     Str[256];
    SIZE     Size;
    
    sprintf(Str, "%s", (LPCTSTR)Obj->getName());
    
    GetTextExtentPoint32(hDC, Str, strlen(Str), &Size);            
    
    XPos = Node->isChildOf(NULL) * TREEVIEW_INDENT + 40 - ScrollOffsetX;
    Node->getObject()->m_Temp = YPos;
    
    // Draw the selection box if necessary
    if (Node->isChildOfFlagged(OBJECTFLAG_SELECTED) || (m_DragTargetNode == Node)) {
      RECT     Rect;
      
      //         hBrush = ::CreateSolidBrush(::GetSysColor(COLOR_HIGHLIGHT));
      if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
        hBrush = ::CreateSolidBrush(0xff5f33);
      } else {
        hBrush = ::CreateSolidBrush(0xff9f88);
      }
      
      if (m_DragTargetNode == Node) {
        ::DeleteObject(hBrush);
        hBrush = ::CreateSolidBrush(0x0fbf28);
      }
      
      
      Rect.left = ClientRect.left;
      Rect.right = ClientRect.right;
      Rect.top = YPos - Size.cy/2 - 3;
      Rect.bottom = YPos + Size.cy/2 + 3;
      FillRect(hDC, &Rect, hBrush);
      ::DeleteObject(hBrush);
    }
    
    Size.cy += TEREVIEW_YDIFF;
    
    
    // Draw the lines of the tree
    {
      HPEN     hPen, hOldPen;
      
      hPen = ::CreatePen(PS_DOT, 0, 0x000000);
      hOldPen = (HPEN)::SelectObject(hDC, hPen);
      
      ::MoveToEx(hDC, XPos, YPos, NULL);
      ::LineTo(hDC, XPos - TREEVIEW_INDENT, YPos);
      
      // Get the YPos of the parent.
      {
        int    YPosParent;
        
        if (Node->getParent() != NULL) {
          YPosParent = Node->getParent()->getObject()->m_Temp;
        } else {
          YPosParent = 0;
        }
        
        ::LineTo(hDC, XPos - TREEVIEW_INDENT, YPosParent);
      }
      
      // Draw the circle indicating that the node has children if required
      if (Node->getFirstChild() != NULL)
      {
        int x, y;
        
        x = XPos;
        y = YPos;
        
        ::Ellipse(hDC, x-4, y-4, x+4, y+4);
      }
      
      ::SelectObject(hDC, hOldPen);
      ::DeleteObject(hPen);
    }
    
    // Draw the actual text
    bool DrawText;
    
    DrawText = true;
    
    if (!m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_LIGHT))
    {
      if (Obj->isFlagged(OBJECTFLAG_TYPE_LIGHT))
        DrawText = false;
    }
    
    if (DrawText)
    {
      // Set the current pen color to the appropriate color
      
      COLORREF Color;
      
      Color = 0x000000;
      if (!Obj->isFlagged(OBJECTFLAG_VISIBLE))
        Color = 0x7f7f7f;
      
      SetTextColor(hDC, Color);
      
      ::TextOut(hDC, XPos+8, YPos-Size.cy/2+4, Str, strlen(Str));
      if (XPos + 8 + Size.cx > ScrollMaxX)
        ScrollMaxX = XPos + 8 +Size.cx;
      YPos += Size.cy;
      
    }
  }
  Tree->endIteration();

  ::SelectObject(hDC, hOldFont);
  ::DeleteObject(hFont);


  // Copy the backbuffer to make the sceneview visible without any flickering
  if (NULL != global_DC)
  {
    ::BitBlt(global_DC, 0, 0, ClientRect.right, ClientRect.bottom, hDC, 0, 0, SRCCOPY);
  } else {
    HDC  hdc = ::GetDC(m_hWnd);
    ::BitBlt(hdc, 0, 0, ClientRect.right, ClientRect.bottom, hDC, 0, 0, SRCCOPY);
    ::ReleaseDC(m_hWnd, hdc);
  }

  ::SelectObject(hDC, hOldBitmap);

  // NOTE: Do NOT ReleaseDC() this backbuffer!
  //       Use DeleteDC() instead..
  //       (ReleaseDC would give us a big resource leak)
  ::DeleteDC(hDC);
  ::DeleteObject(hBitmap);

  Invalidate();
  UpdateWindow();


  {
    int            ScrollMaxY;
    SCROLLINFO     ScrollInfo;
  
    //      ScrollMaxY = YPos + ScrollOffsetY - ClientRect.bottom;
    //      ScrollMaxX += ScrollOffsetX - ClientRect.right;
    ScrollMaxY = YPos + ScrollOffsetY;
    ScrollMaxX += ScrollOffsetX;
  
    ScrollInfo.cbSize = sizeof(SCROLLINFO);
    ScrollInfo.fMask = SIF_PAGE | SIF_RANGE;
  
    ScrollInfo.nMin = 0;
    ScrollInfo.nMax = ScrollMaxX;
    ScrollInfo.nPage = ClientRect.right;
    SetScrollInfo(SB_HORZ, &ScrollInfo);
  
    ScrollInfo.nMax = ScrollMaxY;
    ScrollInfo.nPage = ClientRect.bottom;
    SetScrollInfo(SB_VERT, &ScrollInfo);
  
    if (ScrollMaxY > ClientRect.bottom) {
      ShowScrollBar(SB_VERT);
    } else {
      ShowScrollBar(SB_VERT, FALSE);
    }
  
    if (ScrollMaxX > ClientRect.right) {
      ShowScrollBar(SB_HORZ);
    } else {
      ShowScrollBar(SB_HORZ, FALSE);
    }
  }

  DrawCount--;
}

DWORD CSceneViewWnd::ViewPopupMenu(int x, int y)
{
  CMenu    Menu, AppMenu;
  CMenu    *Popup;
  DWORD    Choice;
  
  Menu.LoadMenu(IDR_SCENEOUTLINE_POPUP);
  Popup = Menu.GetSubMenu(0);
  InitPopupMenu(Popup);
  
  // Check the carious menu items depending on the current flags etc.
  
  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_MESH))
    Popup->CheckMenuItem(ID_POPUP_MESHES, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_MESHES, MF_UNCHECKED);
  
  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_LIGHT))
    Popup->CheckMenuItem(ID_POPUP_LIGHTS, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_LIGHTS, MF_UNCHECKED);
  
  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_CAMERA))
    Popup->CheckMenuItem(ID_POPUP_CAMERAS, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_CAMERAS, MF_UNCHECKED);
  
  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_MATERIAL))
    Popup->CheckMenuItem(ID_POPUP_MATERIALS, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_MATERIALS, MF_UNCHECKED);
  
  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_MODIFIER))
    Popup->CheckMenuItem(ID_POPUP_MODIFIERS, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_MODIFIERS, MF_UNCHECKED);

  if (m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_SHAPE))
    Popup->CheckMenuItem(ID_POPUP_SHAPEOBJECTS, MF_CHECKED);
  else
    Popup->CheckMenuItem(ID_POPUP_SHAPEOBJECTS, MF_UNCHECKED);
  
  Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);
  
  Popup->DestroyMenu();
  
  bool     Update;
  int      Result;
  
  Result = HandlePopupCommand(Choice);
  
  // The command was handled, but the view was changed, so we must return.
  if (Result == -1)
    return 1;
  
  if (Result == 1)
    Update = true;
  else 
    Update = false;
  
  if (Update) {
    DrawView();
  }
  
  return Choice;
}

int CSceneViewWnd::HandlePopupCommand(DWORD Cmd)
{
  int Result;
  
  Result = MBaseViewWnd::HandlePopupCommand(Cmd);
  
  if (Result)
    return Result;
  
  switch (Cmd)
  {
  case ID_POPUP_MESHES:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_MESH);
    return 1;
  case ID_POPUP_LIGHTS:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_LIGHT);
    return 1;
  case ID_POPUP_CAMERAS:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_CAMERA);
    return 1;
  case ID_POPUP_MATERIALS:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_MATERIAL);
    return 1;
  case ID_POPUP_MODIFIERS:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_MODIFIER);
    return 1;
  case ID_POPUP_SHAPEOBJECTS:
    m_FilterFlags.toggleFlag(OBJECTFLAG_TYPE_SHAPE);
    return 1;
  case ID_POPUP_SELECTCHILDREN:
    KEditSelectChildren();
    return 1;
  }
  
  return 0;
}


MTreeObjectNodePtr CSceneViewWnd::GetNodeFromPoint(int x, int y) {
  HFONT  hFont, hOldFont;
  RECT   ClientRect;
  HDC    hDC;
  
  hDC = ::GetDC(m_hWnd);
  GetClientRect(&ClientRect);
  
  hFont = ::CreateFont(TREEVIEW_FONTSIZE, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
  hOldFont = (HFONT)::SelectObject(hDC, hFont);
  
  MBaseObjectTreePtr Tree;
  MBaseObjectPtr BaseObj;
  MNamedObjectPtr Obj;
  MTreeObjectNodePtr Node, FoundNode;
  int               YPos, XPos;
  
  
  FoundNode = NULL;
  // We dont add on the clientrect.top here because the mouse coordinates 
  // given to us are already adjust to the clint rect according to the menu 
  // bar being present.
  YPos = 20 - GetScrollPos(SB_VERT);
  
  Tree = g_Scene->getObjectList();
  
  Tree->beginIteration();
  while (( BaseObj = Tree->getNext() ) != NULL ) {
    Obj = AZTEC_CAST(MNamedObject, BaseObj);

    if (!shouldDrawNode(Obj)) {
      continue;
    }

    Node = Tree->getCurrentNode();
    
    char     Str[256];
    SIZE     Size;
    
    sprintf(Str, "%s", (LPCTSTR)Obj->getName());

    GetTextExtentPoint32(hDC, Str, strlen(Str), &Size);            
    
    XPos = Node->isChildOf(NULL) * TREEVIEW_INDENT + 40;
    Node->getObject()->m_Temp = YPos;
    
    Size.cy += TEREVIEW_YDIFF;
    
    if (y > YPos - Size.cy / 2 && y < YPos + Size.cy/2) {
      FoundNode = Node;
    }
    
    // Draw the actual text
    bool DrawText;
    
    DrawText = true;
    
    if (!m_FilterFlags.isFlagged(OBJECTFLAG_TYPE_LIGHT)) {
      if (Obj->isFlagged(OBJECTFLAG_TYPE_LIGHT))
        DrawText = false;
    }
    
    if (DrawText) {
      YPos += Size.cy;
    }
  }
  Tree->endIteration();
  
  
  ::SelectObject(hDC, hOldFont);
  ::DeleteObject(hFont);
  
  ::ReleaseDC(m_hWnd, hDC);
  
  return FoundNode;
}


/////////////////////////////////////////////////////////////////////////////
// CSceneViewWnd message handlers

void CSceneViewWnd::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  global_DC = dc.m_hDC;
  DrawView();
  global_DC = NULL;
}

int CSceneViewWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CWnd::OnCreate(lpCreateStruct) == -1)
    return -1;
  
  return 0;
}


void CSceneViewWnd::onMouseUp(int X, int Y, MShiftState Shift) {
  bool RequireUpdate;
  
  RequireUpdate = false;
  
  if (m_Dragging && m_DraggingNode != NULL)
  {
    if (!Shift.m_Left && !Shift.m_Right && !Shift.m_Mid)
    {
      MTreeObjectNodePtr ParentNode;
      
      ParentNode = GetNodeFromPoint(X, Y);
      
      MSceneObjectPtr child = AZTEC_CAST(MSceneObject, m_DraggingNode->getObject());
      MSceneObjectPtr parent;
      
      if (ParentNode != NULL) {
        parent = AZTEC_CAST(MSceneObject, ParentNode->getObject());
      }

      child->setParent(parent);
      
      RequireUpdate = true;
      m_Dragging = false;
      m_DraggingNode = NULL;
      
    }
  }
  
  m_DragTargetNode = NULL;
  m_DraggingNode = NULL;
  
  if (RequireUpdate)
  {
    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  }
}

void CSceneViewWnd::onMouseDown(int X, int Y, MShiftState Shift) {
  bool RequireUpdate;
  
  RequireUpdate = false;
  
  SetFocus();
  
  if (Shift.m_Left) {
    
    MTreeObjectNodePtr Node;
    
    Node = GetNodeFromPoint(X,Y);
    m_DraggingNode = Node;
    
    if (!Shift.m_Ctrl)
      g_Scene->selectNone();
    
    if (Node != NULL) {
      bool     TargetSel;
      
      TargetSel = !Node->isChildOfFlagged(OBJECTFLAG_SELECTED);
      g_Scene->selectObject(Node->getObject(), TargetSel);
      
    }
    
    RequireUpdate = true;
  }
  if (RequireUpdate)
  {
    g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    g_MainDlg->SendMessage(MM_UPDATECHANNELBAR, 0, 0);
  }
}

void CSceneViewWnd::OnSize(UINT nType, int cx, int cy) 
{
  CWnd::OnSize(nType, cx, cy);
  
  RECT     ClientRect;
  
  GetClientRect(&ClientRect);
  m_PopupRect = ClientRect;
  
  DrawView();
  
}

void CSceneViewWnd::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int      ScrollPos;
  RECT     ClientRect;
  
  GetClientRect(&ClientRect);
  
  ScrollPos = GetScrollPos(SB_VERT);
  
  if (nSBCode == SB_THUMBTRACK)
    ScrollPos = nPos;
  if (nSBCode == SB_LINEUP)
    ScrollPos -= 16;
  if (nSBCode == SB_LINEDOWN)
    ScrollPos += 16;
  if (nSBCode == SB_PAGEUP)
    ScrollPos -= ClientRect.bottom;
  if (nSBCode == SB_PAGEDOWN)
    ScrollPos += ClientRect.bottom;
  
  SetScrollPos(SB_VERT, ScrollPos);
  DrawView();
  
  CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CSceneViewWnd::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
  int      ScrollPos;
  RECT     ClientRect;
  
  GetClientRect(&ClientRect);
  
  ScrollPos = GetScrollPos(SB_HORZ);
  
  if (nSBCode == SB_THUMBTRACK)
    ScrollPos = nPos;
  if (nSBCode == SB_LINEUP)
    ScrollPos -= 16;
  if (nSBCode == SB_LINEDOWN)
    ScrollPos += 16;
  if (nSBCode == SB_PAGEUP)
    ScrollPos -= ClientRect.right;
  if (nSBCode == SB_PAGEDOWN)
    ScrollPos += ClientRect.right;
  
  SetScrollPos(SB_HORZ, ScrollPos);
  DrawView();
  
  CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CSceneViewWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  {
    bool s,a,c;
    MShiftState state = getShiftState();
    s = state.m_Shift;
    a = state.m_Alt;
    c = state.m_Ctrl;
    
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"General"))
      return;
    if (g_KeyList.ExecuteKey(nChar,c,a,s,"View"))
      return;
  }
  
  CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CSceneViewWnd::OnClose() 
{
  // Remove the Scene window fro the view list.
  
  g_ViewList.DeleteView(this);
  
  // CWnd::OnClose();
}

void CSceneViewWnd::onMouseMove(int x, int y, MShiftState Shift) {

  ::SetCursor(LoadCursor(NULL, IDC_ARROW));
  
  if (abs(x - m_DownX) > 3 || abs(y - m_DownY) > 3 && m_DraggingNode != NULL) {
    m_Dragging = true;
  }
  
  // Check to see if we need to scroll the window
  if (m_Dragging && m_DraggingNode != NULL)
  {
    RECT     ClientRect;
    int      ScrollX, ScrollY;
    
    m_DragTargetNode = GetNodeFromPoint(x, y);
    
    ScrollX = 0;
    ScrollY = 0;
    GetClientRect(&ClientRect);
    
    if (x < 10)
      ::SendMessage(m_hWnd, WM_HSCROLL, SB_LINELEFT, NULL);
    if (x > ClientRect.right - 10)
      ::SendMessage(m_hWnd, WM_HSCROLL, SB_LINERIGHT, NULL);
    if (y < 10)
      ::SendMessage(m_hWnd, WM_VSCROLL, SB_LINELEFT, NULL);
    if (y > ClientRect.bottom - 10)
      ::SendMessage(m_hWnd, WM_VSCROLL, SB_LINERIGHT, NULL);
    
    DrawView();
    
  }
  
}

BOOL CSceneViewWnd::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
    RECT     ClientRect;
    
    GetClientRect(&ClientRect);
    
    if (zDelta < 0) ::SendMessage(m_hWnd, WM_VSCROLL, SB_LINERIGHT, NULL);
    else if (zDelta > 0) ::SendMessage(m_hWnd, WM_VSCROLL, SB_LINELEFT, NULL);
    
    DrawView();

    return CWnd::OnMouseWheel(nFlags, zDelta, pt);
}

BOOL CSceneViewWnd::PreTranslateMessage(MSG* pMsg) 
{
  return MBaseViewWnd::PreTranslateMessage(pMsg);
}

BOOL CSceneViewWnd::OnEraseBkgnd(CDC* pDC) 
{
    return true;
}
