// GraphViewWnd.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include <views/ImageViewerView.h>

#include <tools/MGraphSelectTool.h>
#include <misc/FileTools.h>

#include "MdlGlobs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int toolbarHeight = 33;
static const int borderWidth = 2;

static const int ParamListID = 10002;


ImageViewerView::ImageViewerView() {
  paintDC = NULL;
  imageViewer = NULL;
}

ImageViewerView::~ImageViewerView() {
  if (imageViewer != NULL) {
    delete imageViewer;
  }
}


BEGIN_MESSAGE_MAP(ImageViewerView, CWnd)
	//{{AFX_MSG_MAP(ImageViewerView)
  ON_WM_SIZE()
  ON_WM_PAINT()
	ON_WM_CLOSE()
  ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void ImageViewerView::OnPaint() 
{
  CPaintDC dc(this); // device context for painting

  paintDC = dc.m_hDC;
  DrawView();
  paintDC = NULL;
}

MBaseObjectPtr ImageViewerView::createNew()
{
   ImageViewerView  *Wnd;

   Wnd = new ImageViewerView;
   Wnd->setName(getName());

   return (MBaseObject*)Wnd;
}


void ImageViewerView::ViewCreate() {
  MBaseViewWnd::ViewCreate();
  RECT clientRect;
  GetClientRect(&clientRect);

  getMenuBar()->addMenu("Image", new MMenuBar::PopupMenu(IDR_IMAGEVIEW_MENU), 0);

  if (imageViewer == NULL) {
    imageViewer = new ImageViewer();
    imageViewer->Create(CRect(clientRect.left,clientRect.top,clientRect.right,clientRect.bottom), 
                        this);
//    imageViewer->Create("", WS_VISIBLE | WS_CHILD | WS_BORDER | WS_HSCROLL | WS_VSCROLL | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, clientRect, this);
  }
}

void ImageViewerView::DrawView() {
  MBaseViewWnd::DrawView();

  // Draw the border of the view.
  {
    RECT rect;
    GetClientRect(&rect);

    if (isCurrentView()) {
      drawSelectedBorder(paintDC, rect, borderWidth);
    } else {
      drawSelectedBorder(paintDC, rect, borderWidth, 0x808080);
    }
  }

}

DWORD ImageViewerView::ViewPopupMenu(int x, int y)
{
  CMenu    Menu;
  CMenu    *Popup;
  DWORD    Choice;
  
  Menu.LoadMenu(IDR_GRAPHVIEW_POPUP);
  Popup = Menu.GetSubMenu(0);
  InitPopupMenu(Popup);
  
  // Check the carious menu items depending on the current flags etc.
  
  Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);
  
  Popup->DestroyMenu();
  
  bool     Update;
  int      Result;
  
  Result = HandlePopupCommand(Choice);
  
  // The command was handled, but the view was changed, so we must return.
  if (Result == -1)
    return 1;
  
  if (Result == 1) {
    Update = true;
  } else {
    Update = false;
  }
  
  if (Update) {
    Invalidate();
    UpdateWindow();
  }
  
  return Choice;
}

int ImageViewerView::HandlePopupCommand(DWORD Cmd)
{
  int Result;
  
  Result = MBaseViewWnd::HandlePopupCommand(Cmd);
  
  if (Result) {
    return Result;
  }
  
  switch (Cmd)
  {
  case ID_POPUP_OPENIMAGE:
    return openImage();
    
  case ID_POPUP_SAVEIMAGE:
    return saveImage();
  }
  
  return 0;
}

ImageViewer* ImageViewerView::getImageComponent() {
  return &*imageViewer;
}

int ImageViewerView::openImage() {
  std::vector<MImageTranslatorPtr> translators = MSystemManager::getInstance()->getPluginManager()->getImageTranslators(MPluginManager::MUST, MPluginManager::DONT_CARE);
  std::string filter = FileTools::createFilterString(translators, true, true);

  CFileDialog Dlg(TRUE, "", NULL, OFN_HIDEREADONLY, filter.c_str());

  if (Dlg.DoModal() == IDOK) {
    // if our filterIndex is number 1, or is the last one then we have a wild card file format. We need to guess the translator from the extension. Basically allow the system manager to take acre of that for us.
    if (Dlg.m_ofn.nFilterIndex == 1 || Dlg.m_ofn.nFilterIndex == translators.size() + 2) {
      imageViewer->setImage(MSystemManager::getInstance()->loadImage((LPCTSTR)Dlg.GetPathName()));
      return 1;
    } else {
      return translators[Dlg.m_ofn.nFilterIndex - 1]->importFile((LPCTSTR)Dlg.GetPathName(), imageViewer->getImage());
    }
  }

  return 0;
}

int ImageViewerView::saveImage() {
  std::vector<MImageTranslatorPtr> translators = MSystemManager::getInstance()->getPluginManager()->getImageTranslators(MPluginManager::DONT_CARE, MPluginManager::MUST);
  std::string filter = 
    FileTools::createFilterString(
      translators, 
      false, 
      false);
  CFileDialog Dlg(FALSE, "", NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter.c_str());

  if (Dlg.DoModal() == IDOK) {
    MImageTranslatorPtr translator = translators[Dlg.m_ofn.nFilterIndex - 1];
    return translator->exportFile((LPCTSTR)Dlg.GetPathName(), imageViewer->getImage());
  }

  return 0;
}


void ImageViewerView::OnSize(UINT nType, int cx, int cy) 
{
  MBaseViewWnd::OnSize(nType, cx, cy);

  GetClientRect(&m_PopupRect);

  CRect clientRect;
  GetClientRect(&clientRect);

  if (imageViewer != NULL) {
    if (imageViewer->m_hWnd != NULL) {
      int left = borderWidth;
      imageViewer->SetWindowPos(NULL, 
                            clientRect.left, clientRect.top,
                            clientRect.Width(), clientRect.Height(), 
                            SWP_NOZORDER);
    }
  }
}


void ImageViewerView::OnClose() 
{
   g_ViewList.DeleteView(this);
	
//	CWnd::OnClose();
}

void ImageViewerView::OnDestroy() {
  if (imageViewer != NULL) {
    imageViewer->DestroyWindow();
    delete imageViewer;
    imageViewer = NULL;
  }

  MBaseViewWnd::OnDestroy();
}

BOOL ImageViewerView::OnCommand( WPARAM wParam, LPARAM lParam ) {

  // check to see if we have received a comand from a menu
  if (lParam == 0) {
    int result = HandlePopupCommand(LOWORD(wParam));
    bool update = false;
  
    // The command was handled, but the view was changed, so we must return.
    if (result == -1) {
      return 1;
    }
  
    if (result == 1) {
      update = true;
    } else {
      update = false;
    }
  
    if (update) {
      Invalidate();
      UpdateWindow();
    }
  }
  
  return TRUE;
}

