#include <AztecMainPCH.h>
#include "ToolClasses.h"

#include <MdlGlobs.h>
#include <DlgGlobs.h>
#include <MdlMsgs.h>

#include "KeyFuncGeneral.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------
//  ToolFunctions
//----------------------------------------------------------------------------------------

void InitToolActionList(MActionListType *AL) {
  g_SysMan->logOutput("Initialising General Action List");
  
  // General
  AL->Add("KToolSelect", "Select Tool","General",KToolSelect);
  AL->Add("KToolMove", "Move Tool","General",KToolMove);
  AL->Add("KToolRotate", "Rotate Tool","General",KToolRotate);
  AL->Add("KToolScale", "Scale Tool","General",KToolScale);
  AL->Add("toolEdgeTurn", "Edge Turn Tool","Mesh",KToolEdgeTurn, g_MainDlg, ID_MESH_TURNEDGE_TOOL);
  AL->Add("toolEdgeDivide", "Edge Divide Tool","Mesh",KToolEdgeDivide, g_MainDlg, ID_MESH_DIVIDEEDGE_TOOL);
  
  AL->Add("KToolMovePivot", "Move Pivot Tool","General",KToolMovePivot);
  AL->Add("toolExtrude", "Extrude Face Tool", "Mesh", KToolExtrude, g_MainDlg, ID_MESH_EXTRUDEFACE_TOOL);
}

int KToolSelect() {
  g_ToolMan.PushTool(new MSelectToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KToolMove() {
  g_ToolMan.PushTool(new MGLMoveToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KToolRotate() {
  g_ToolMan.PushTool(new MGLRotateToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KToolScale() {
  g_ToolMan.PushTool(new MGLScaleToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KToolMovePivot() {
  g_ToolMan.PushTool(new MMovePivotToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}


int KToolEdgeTurn() {
  KModeEdge();
  g_ToolMan.PushTool(new MEdgeTurnToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}

int KToolEdgeDivide() {
  KModeEdge();
  g_ToolMan.PushTool(new MEdgeDivideToolType);
  g_MainDlg->PostMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
  return 1;
}


