// TimeScroller.cpp : implementation file
//

#include <AztecMainPCH.h>
#include <controls/MParameterGroup.h>

#include <params/MChoiceParameter.h>

//#include <views/BaseViewWnd.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace AztecGUI {

  static void draw3dRect(HDC dc, const RECT &rect, bool sunken = false);

  MParameterGroup::MParameterGroup(const std::string &groupName) {
    name = groupName;
    lastYPos = 10;
  }

  MParameterGroup::~MParameterGroup() {
  }

  void MParameterGroup::addParameter(const Aztec::MParameterObjectPtr &param) {
    ParameterGUIPtr gui = new ParameterGUI(param, this);
    parameters.push_back(gui);
    gui->moveTo(10, lastYPos);
    lastYPos += gui->getPreferredHeight() + 5;
  }

  BEGIN_MESSAGE_MAP(MParameterGroup, CWnd)
  //{{AFX_MSG_MAP(MParameterGroup)
  ON_WM_PAINT()
  ON_WM_SIZE()
  ON_WM_DESTROY()
  //}}AFX_MSG_MAP
  END_MESSAGE_MAP()

  void MParameterGroup::OnPaint() {
    CPaintDC    Paintdc(this); // device context for painting
  
  }

  void MParameterGroup::OnSize( UINT nType, int cx, int cy ) {
    int ypos = 5;

    for (ParamList::iterator it = parameters.begin(); it != parameters.end(); ++it) {
      (*it)->moveTo(5, ypos);
      ypos += (*it)->getPreferredHeight();
    }

  }

  void MParameterGroup::OnDestroy() {
    parameters.clear();
  }

  int MParameterGroup::getPreferredHeight() {
    int height = 10;

    for (ParamList::iterator it = parameters.begin(); it != parameters.end(); ++it) {
      height += (*it)->getPreferredHeight() + 5;
    }

    return height;
  }

  const std::string& MParameterGroup::getName() {
    return name;
  }

  void MParameterGroup::setParameterValues(int index) {
    if (index == -1) {
      for (index = 0; index < parameters.size(); ++index) {
        parameters[index]->setParameterFromControl();
      }
    } else {
      if (index >= 0 && index < parameters.size()) {
        parameters[index]->setParameterFromControl();
      }
    }
  }


  //------------

  DWORD MParameterGroup::ParameterGUI::uniqueID = 5000;

  MParameterGroup::ParameterGUI::ParameterGUI(const Aztec::MParameterObjectPtr &param, CWnd *wndParent) {
    parent = wndParent;
    parameter = param;

    RECT rect = {0, 0, 30, 30};

    CStatic *l = new CStatic();

    l->Create(param->getFriendlyName().c_str(), SS_RIGHT | WS_VISIBLE, CRect(5,10,100,25), parent);
    ::SendMessage(l->m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

    editor = createControlFor(param, wndParent, getUniqueID());

    label = l;
  }

  MParameterGroup::ParameterGUI::~ParameterGUI() {
    if (label != NULL) {
      label->DestroyWindow();
      delete label;
    }

    if (editor != NULL) {
      editor->DestroyWindow();
      delete editor;
    }
  }

  static int getHeight(CWnd *wnd) {
    RECT rect;
    wnd->GetWindowRect(&rect);
    return rect.bottom - rect.top;
  }

  void MParameterGroup::ParameterGUI::moveTo(int X, int Y) {
    int EDGE_MARGIN = 5;
    int LABEL_MARGIN = 100;
    int labelHeight = 25;
    int editHeight = 25;
    RECT clientRect;
    parent->GetClientRect(&clientRect);

    clientRect.right -= EDGE_MARGIN;
    clientRect.left += EDGE_MARGIN;
    clientRect.top += EDGE_MARGIN;

    if (label != NULL) {

      label->SetWindowPos(NULL, 
                          clientRect.left + X, 
                          clientRect.top + Y + 4, 
                          LABEL_MARGIN - 5, 
                          getHeight(label), 
                          SWP_NOZORDER);
    }
    if (editor != NULL) {
      editor->SetWindowPos(NULL, 
                           clientRect.left + X + LABEL_MARGIN, 
                           clientRect.top + Y, 
                           clientRect.right - (clientRect.left + X + LABEL_MARGIN), 
                           getHeight(editor), 
                           SWP_NOZORDER);
    }
  }

  int MParameterGroup::ParameterGUI::getPreferredHeight() {
    return 25;
  }

  DWORD MParameterGroup::ParameterGUI::getUniqueID() {
    return uniqueID++;
  }

  const Aztec::MParameterObjectPtr& MParameterGroup::ParameterGUI::getParameter() {
    return parameter;
  }

  void MParameterGroup::ParameterGUI::setParameterFromControl() {
    CString str;
    editor->GetWindowText(str);
    parameter->setValueString((LPCTSTR)str);
  }

  CWnd* MParameterGroup::ParameterGUI::createControlFor(const Aztec::MParameterObjectPtr &param, CWnd *parent, DWORD id) {
    if (AZTEC_CAST(MChoiceParameter, param) != NULL) {
      MChoiceParameterPtr choiceParam = AZTEC_CAST(MChoiceParameter, param);

      CComboBox *combo = new CComboBox();
      combo->Create(CBS_DROPDOWNLIST | WS_VISIBLE, CRect(0,0,20,120), parent, id);

      for (int i = 0; i < choiceParam->getNumChoices(); ++i) {
        combo->AddString(choiceParam->getChoice(i).c_str());
      }
      combo->SetCurSel(choiceParam->getCurrentChoice());

      ::SendMessage(combo->m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      return combo;
    } else {

      CEdit *edit = new CEdit();
      edit->CreateEx(WS_EX_CLIENTEDGE,"EDIT","",
                     WS_CHILD | WS_BORDER | WS_VISIBLE | ES_AUTOHSCROLL,
                     10,10,300,25,parent->GetSafeHwnd(),(HMENU)id);

      ::SendMessage(edit->m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      MStr str;
      param->getValueString(str);
      edit->SetWindowText(str.c_str());

      return edit;
    }
  }

  static void draw3dRect(HDC dc, const RECT &rect, bool sunken) {
    HPEN hPen, hOldPen;
    COLORREF lightColour = ::GetSysColor(COLOR_3DHILIGHT);
    COLORREF darkColour = ::GetSysColor(COLOR_3DSHADOW);
    COLORREF topLeftColour = sunken ? darkColour : lightColour;
    COLORREF bottomRightColour = sunken ? lightColour : darkColour;

    hPen = ::CreatePen(PS_SOLID, 1, topLeftColour);
    hOldPen = (HPEN)::SelectObject(dc, hPen);
    ::MoveToEx(dc, rect.right, rect.top, NULL);
    ::LineTo(dc, rect.left, rect.top);
    ::LineTo(dc, rect.left, rect.bottom);
    ::SelectObject(dc, hOldPen);
    ::DeleteObject(hPen);
  
    hPen = ::CreatePen(PS_SOLID, 1, bottomRightColour);
    hOldPen = (HPEN)::SelectObject(dc, hPen);
    ::MoveToEx(dc, rect.right, rect.top, NULL);
    ::LineTo(dc, rect.right, rect.bottom);
    ::LineTo(dc, rect.left, rect.bottom);
    ::SelectObject(dc, hOldPen);
    ::DeleteObject(hPen);
  }



}




