#ifndef ExtrudeTool_Header
#define ExtrudeTool_Header

#include <MXYZToolType.h>

/**
 * This toll is an interactive extrusion tool allowing
 * faces on a polygonal mesh to be selected and extruded.
 * When a set of faces are selected, an handle appears allowing
 * the user to grabe it and extrude fces apropriately.
 */
class MExtrudeToolType : public MToolType
{
public:
   MExtrudeToolType();

   // MToolType methods
   virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int onMouseUp(int X, int Y, const MShiftState &Shift);

   virtual int WrapMouse() {return 1;};
   virtual int GetDefaultManip() {return 3;};

protected:
   /**
    * This gets the selection normal, and returns true if some
    * face were selected, false if nothing was selected.
    */
   bool updateExtrudeNormal();

   /**
    * This is directio that we are extruding in
    */
   MVector3 m_ExtrudeVec;
   /**
    * This is the centre of the extrusion.
    */
   MVector3 m_ExtrudeCentre;
   /**
    * This is the transformation matrix to use when
    * drawing the widgets
    */
   MMatrix4 m_GLTransform;
   /**
    * This indicates if we are acutally extrusing yet, or
    * just looking at stuff.
    */
   bool m_Extruding;
   /**
    * This is the initial distance along the normal vector
    * the user has selected.
    */
   double m_StartDist;
   /**
    * This is the Distance that we have extruded along
    * the extrude vector so far.
    */
   double m_Dist;


   /**
    * This is the starting point for extrusion.
    */
   MVector3 m_StartPos;
   /**
    * This is the current centre of the centre of the
    * faces during extrusion.
    */
   MVector3 m_CurrentPos;

};

int KToolExtrude();

#endif