#if !defined(AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_)
#define AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_


#define TS_TIMESCROLL_BEFORECHANGE     WM_USER+7001
#define TS_TIMESCROLL_AFTERCHANGE      WM_USER+7002

#include "MListsTrees.h"
#include <MKeyableValue.h>

#include "SegmentEditor.h"

//----------------------------------------------------------------------------------------
//  CTimerScroller
//----------------------------------------------------------------------------------------
class CTimeScroller : public CWnd
{
// Construction
protected:
   int               m_ScrollMin, m_ScrollMax, m_ScrollPos;
   bool              m_Tracking;

   typedef std::set<MKeyableValuePtr> KeyValueSet;
   KeyValueSet m_KeyingList;

   CEdit *m_StartEdit, *m_EndEdit;

   void updateEditBoxes();
   static void updateEditBox(CEdit *editBox, int value);

public:
	CTimeScroller();

   BOOL SetScrollRange(int Min, int Max);
   BOOL SetScrollPos(int Pos);
   int GetScrollPos();
   int GetScrollMin() { return m_ScrollMin; }
   int GetScrollMax() { return m_ScrollMax; }

   void ClearAllKeyLists();
   void addKeyableValue(MKeyableValuePtr value);

   /**
    * This sets the companion edit boxes which contain
    * the start and end edit boxes.
    */
   void setEditBoxes(CEdit *startEdit, CEdit *endEdit);

   /**
    * This calculates the distance between each major 
    * mark on teh time scroller, depending on the size
    * of the currntly selected font in the device context,
    * the current size of the time scroller, and the current
    * range.
    */
   static int calcMajorTickSize(int width, int fromNum, int toNum, HDC dc);

public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTimeScroller)
	protected:
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTimeScroller();

	// Generated message map functions
protected:
	//{{AFX_MSG(CTimeScroller)
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_)
