#include "StdAfx.h"

#include <params/MChoiceParameter.h>
#include <MDAGraph.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------------------------
  //  MChoiceParameterImpl
  //---------------------------------------
  MChoiceParameterImpl::MChoiceParameterImpl( const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MStringParameterImpl(shortName, longName, friendlyName)
  {
    m_CurrentChoice = -1;
  }
  
  int MChoiceParameterImpl::getCurrentChoice() {
    return m_CurrentChoice;
  }
  
  int MChoiceParameterImpl::getNumChoices() {
    return m_Choices.size();
  }
  
  
  MStr MChoiceParameterImpl::getChoice(int index) {
    return m_Choices[index];
  }
  
  void MChoiceParameterImpl::addChoice(const MStr &str) {
    m_Choices.push_back(str);
    
  }
  
  bool MChoiceParameterImpl::getValueString(MStr &Value) {
    if (m_CurrentChoice == -1) {
      Value = "";
      return true;
    }
    
    Value = m_Choices[m_CurrentChoice];
    return true;
  }

  bool MChoiceParameterImpl::getValueInteger(int &value) {
    value = m_CurrentChoice;
    return true;
  }

  
  bool MChoiceParameterImpl::setValueString(const MStr &value) {
    for (int i = 0; i < (int)m_Choices.size(); i++) {
      if (m_Choices[i] == value) {
        m_CurrentChoice = i;
        return MStringParameterImpl::setValueString(value);
      }
    }
    m_CurrentChoice = 0;
    MStringParameterImpl::setValueString(value);
    return 0;
  }
  
  bool MChoiceParameterImpl::setValueInteger(int value) {
    m_CurrentChoice = value;

    if (value < 0 || value >= (int)m_Choices.size()) {
      m_CurrentChoice = -1;
    } else {
      m_CurrentChoice = value;
    }

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }


  bool MChoiceParameterImpl::setFromParameter(MParameterObjectPtr src) {
    bool result = MStringParameterImpl::setFromParameter(src);

    MChoiceParameterImpl *choice = AZTEC_CAST(MChoiceParameterImpl, src);

    if (choice != NULL) {
      m_Choices = choice->m_Choices;
      m_CurrentChoice = choice->m_CurrentChoice;

      return true;
    }

    return result;
  }
  
  MParameterObjectPtr MChoiceParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

}
