#include "StdAfx.h"

#include "MVector3KeyList.h"
#include "MVector3Key.h"
#include "MFloatKeyList.h"

namespace Aztec {

  MVector3KeyList::MVector3KeyList() {
    xList = new MFloatKeyList;
    yList = new MFloatKeyList;
    zList = new MFloatKeyList;
    addInput(&*xList);
    addInput(&*yList);
    addInput(&*zList);
  }

  MVector3KeyList::~MVector3KeyList() {
  }

  MFloatKeyableValuePtr MVector3KeyList::getXValue() {
    return xList;
  }

  MFloatKeyableValuePtr MVector3KeyList::getYValue() {
    return yList;
  }

  MFloatKeyableValuePtr MVector3KeyList::getZValue() {
    return zList;
  }

  void MVector3KeyList::setInitialValue(const MVector3 &vec) {
    xList->setInitialValue(vec.x);
    yList->setInitialValue(vec.y);
    zList->setInitialValue(vec.z);
  }
  
  void MVector3KeyList::setKey(const MVector3 &value, long time) {
    xList->setKey(value.x, time);
    yList->setKey(value.y, time);
    zList->setKey(value.z, time);
  }

  void MVector3KeyList::setXKey(float value, long time) {
    xList->setKey(value, time);
  }

  void MVector3KeyList::setYKey(float value, long time) {
    yList->setKey(value, time);
  }

  void MVector3KeyList::setZKey(float value, long time) {
    zList->setKey(value, time);
  }

  // MKeyableValue methods
  bool MVector3KeyList::hasKeySet(long time) {
    return (xList->hasKeySet(time) || yList->hasKeySet(time) || zList->hasKeySet(time));
  }

  void MVector3KeyList::shiftKeys(long onOrAfterTime, long beforeTime, long amount) {
    xList->shiftKeys(onOrAfterTime, beforeTime, amount);
    yList->shiftKeys(onOrAfterTime, beforeTime, amount);
    zList->shiftKeys(onOrAfterTime, beforeTime, amount);
  }

  void MVector3KeyList::shiftSelectedKeys(long amount) {
    xList->shiftSelectedKeys(amount);
    yList->shiftSelectedKeys(amount);
    zList->shiftSelectedKeys(amount);
  }

  void MVector3KeyList::getKeyTimes(std::vector<int> &keyTimes) {
    std::vector<int> times;
    std::set<int> allTimes;

    xList->getKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    yList->getKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    zList->getKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    keyTimes.resize(allTimes.size());

    int index = 0;
    for (std::set<int>::iterator i = allTimes.begin(); i != allTimes.end(); ++i, ++index) {
      keyTimes[index] = *i;
    }
  }

  void MVector3KeyList::getSelectedKeyTimes(std::vector<int> &keyTimes) {
    std::vector<int> times;
    std::set<int> allTimes;

    xList->getSelectedKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    yList->getSelectedKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    zList->getSelectedKeyTimes(times);

    for (unsigned int i = 0; i < times.size(); ++i) {
      allTimes.insert(times[i]);
    }

    keyTimes.resize(allTimes.size());

    int index = 0;
    for (std::set<int>::iterator i = allTimes.begin(); i != allTimes.end(); ++i) {
      keyTimes[index] = *i;
    }
  }

  void MVector3KeyList::deleteKey(long time) {
    xList->deleteKey(time);
    yList->deleteKey(time);
    zList->deleteKey(time);
  }

  void MVector3KeyList::deleteSelectedKeys() {
    xList->deleteSelectedKeys();
    yList->deleteSelectedKeys();
    zList->deleteSelectedKeys();
  }

  bool MVector3KeyList::hasKeys() {
    return (xList->hasKeys() || yList->hasKeys() || zList->hasKeys());
  }

  MVector3 MVector3KeyList::getValueAtTime(long time) {
    return MVector3(xList->getValueAtTime(time), 
                    yList->getValueAtTime(time), 
                    zList->getValueAtTime(time));
  }

  // MValue methods
  bool MVector3KeyList::copyFromValue(MValuePtr source) {
    MVector3KeyListPtr list = AZTEC_CAST(MVector3KeyList, source);

    // we can only copy from our own type.
    if (list == NULL) {
      return false;
    }

    xList->copyFromValue(list->xList);
    yList->copyFromValue(list->yList);
    zList->copyFromValue(list->zList);

    return true;
  }

  void MVector3KeyList::storeValue() {
    xList->storeValue();
    yList->storeValue();
    zList->storeValue();
  }

  void MVector3KeyList::restoreValue() {
    xList->restoreValue();
    yList->restoreValue();
    zList->restoreValue();
  }

  // MBaseObject methods
  MBaseObjectPtr MVector3KeyList::createNew() {
    MVector3KeyListPtr result = new MVector3KeyList;
    result->xList = AZTEC_CAST(MFloatKeyList, xList->createNew());
    result->yList = AZTEC_CAST(MFloatKeyList, yList->createNew());
    result->zList = AZTEC_CAST(MFloatKeyList, zList->createNew());
    return result;
  }

}

