#include "StdAfx.h"

#include "MCamera.h"
#include "MMesh.h"
#include "MEditableMesh.h"

#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include "ModelGLConst.h"

#include <MSystemManager.h>
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {
//------------
//  MCamera
//------------

  MCamera::MCamera() {
    setFlag(OBJECTFLAG_NOCOMPONENTS);
    setObjectType(OBJECTFLAG_TYPE_CAMERA);
    
    addParameter(MParameterFactory::createFloat("fov", "fieldOfView", "Field of View"));
    
    setParamByName("fov", "45.0");
    
  }
  
  MCamera::~MCamera() {
    cameraMesh = NULL;
  }
  
  MBaseObjectPtr MCamera::createNew() {
    MCamera *newObject;
    
    newObject = new MCamera;
    newObject->setFrom(this);
    
    return newObject;
  }
  
  bool MCamera::drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags) {
    generateCameraMesh();

    ViewFlags.m_DrawWire = true;
    ViewFlags.m_ShadingMode = glWireframe;
    ViewFlags.m_TextureMode = glNone;
    ViewFlags.m_LightingMode = glUnlit;

    cameraMesh->drawObject(baseObj, ViewFlags);
    
    return true;
  }

  void MCamera::generateCameraMesh() {
    if (cameraMesh != NULL) {
      return;
    }

    MVector3 Verts[6];
    MInternalTriangle   Tris[8];
    
    Verts[0].set( 0, 8, 0);
    Verts[1].set( 2, 0,-2);
    Verts[2].set(-2, 0,-2);
    Verts[3].set(-2, 0, 2);
    Verts[4].set( 2, 0, 2);
    Verts[5].set( 0,-2, 0);
    
    Tris[0] = MInternalTriangle(0,1,2);
    Tris[1] = MInternalTriangle(0,2,3);
    Tris[2] = MInternalTriangle(0,3,4);
    Tris[3] = MInternalTriangle(0,4,1);
    Tris[4] = MInternalTriangle(5,2,1);
    Tris[5] = MInternalTriangle(5,3,2);
    Tris[6] = MInternalTriangle(5,4,3);
    Tris[7] = MInternalTriangle(5,1,4);
    
    MEditableMeshPtr mesh = new MEditableMesh();

    mesh->addVertexArray(Verts, 6);
    mesh->addTriangleArray(Tris, 8);

    cameraMesh = new MMesh();
    cameraMesh->setFrom(mesh);
  }

}
