#ifndef MSCENEOBJECT_H
#define MSCENEOBJECT_H

#include <ModelGeneric.h>

namespace Aztec {

  class MSceneObject;
  typedef MRefCountedPtr<MSceneObject> MSceneObjectPtr;

}

#include <MNamedObject.h>
#include <MShapeObject.h>
#include <MMaterial.h>
#include <MComponentisedObject.h>
#include <MTransformObject.h>

#include <params/MObjectParameter.h>
#include <mesh/MMeshModifier.h>

namespace Aztec {
  
  //----------------
  //  MSceneObject
  //----------------
  class MGENEXPORT MSceneObject : public MTransformObject {
  public:
    // Construction/Destruction
    MSceneObject(MShapeObjectPtr shape = NULL);
    ~MSceneObject();
    
    // Class related
    virtual MStr getClassName() {return MStr("MSceneObject");};
    virtual MStr getParentClassName() {return MStr("MTransformObject");};
    virtual MBaseObjectPtr createNew();
    virtual void setFrom(MBaseObjectPtr SrcObj);
    
    // Material Functions
    void setTextureMaterial(MMaterialPtr material);
    MMaterialPtr getTextureMaterial();
    MStr getTextureMaterialName();

    /**
     * This gets the Shape object that defines the surface of this scene object.
     */
    MShapeObjectPtr getShapeObject();

    /**
     * This sets the shape object that defines the surface of this scene object.
     */
    void setShapeObject(MShapeObjectPtr shapeObj);

    /**
     * This gets the component object for this scene object.
     * It first attempts to cast this to a MComponent object. If it fails,
     * it attempts the shape object.
     */
    MComponentisedObjectPtr getComponentObject();

    /**
     * This gets the component object for this scene object.
     * It first attempts to cast this to a MComponent object. If it fails,
     * it attempts the shape object.
     */
    MEditableComponentisedObjectPtr getEditableComponentObject();

    /**
     * This gets the parent of this object
     */
    MSceneObjectPtr getParent();

    /**
     * This sets the parent of this object
     */
    void setParent(const MSceneObjectPtr &parent);

    virtual MTransformObjectPtr getTransformObject();

    /**
     * This gets the matrix that transforms object coordinates into world 
     * coordinates. It basically concatenates each object's transform 
     * matrix to produce a single matrix.
     */
    void getWorldTransformMatrix(MMatrix4 &matrix);
    
    /**
     * This gets the matrix that transforms world coordinates into object
     * coordinates. It basically concatenates each object's transform 
     * matrix to produce a single matrix.
     */
    void getWorldInverseTransformMatrix(MMatrix4 &matrix);

    virtual int updateObject();
    virtual const MVector3 getPivotPoint();
    virtual const MVector3 centrePivot();
    
    /**
     * This inserts the given modifier at the top of stack of modifiers. If
     * our shape object is connected to something, then we change that
     * connection to feed into the modifier, and the modifiers output to feed
     * into our shape parameter. If our shape object isn't connected, then we
     * retrieve this object's shape, place it as the input to the modifier, and
     * then connect the modifiers shape output into this objects shape.
     * 
     * @param modifier The modifier to insert.
     * @return true if the insertion was successful.
     */
    bool insertModifier(const MMeshModifierPtr &modifier);

  protected:
    /**
     * This is the parameter that stores the object that is used to
     * define our shape.
     */
    MObjectParameterPtr m_ShapeObjParam;
    
    /**
     * This is the texture that is applied to this object.
     */
    MObjectParameterPtr m_MaterialParam;

    /**
     * This is the parent of this object.
     */
    MObjectParameterPtr m_ParentParam;

  };
  
  
}


#endif
