#ifndef MBasicTypes_Header
#define MBasicTypes_Header

#include "ModelGeneric.h"

// TODO: this must change from just including windows.h to defining 
// important symbols by itself.

#ifdef WIN32 

#include <windows.h>

#else

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef unsigned int    UINT;

typedef const char *    LPCTSTR;

// This one is just here for compatibility until all HWND's 
// are removed from AztecLib.
typedef void *          HWND;

// This one is just here for compatibility until we have
// a more generic way of keeping track of DLLs than using
// HINSTANCEs
typedef void *          HINSTANCE;


typedef struct {
  int x;
  int y;
} POINT;


#define LOWORD(dw) ((WORD)(dw))
#define HIWORD(dw) ((WORD)(((DWORD)(dw) >> 16) & 0xFFFF))


#endif

#endif
