#include <AztecGUICommonPCH.h>

#include <tools/MToolType.h>
#include <params/MParameterFactory.h>

#include <GL/gl.h>

namespace AztecGUI {

  MToolType::MToolType() {
    m_Dragging = false;
    m_PickedManip = 0;
    m_RequiresSel = false;

  }

  MToolType::~MToolType() {
  }

  bool MToolType::Is(MStr Str) {
    if (Str.compareNoCase(getName().c_str()) == 0)
      return true;
  
    return false;
  }

  void MToolType::initialise() {
  }

  bool MToolType::finish() {
    return true;
  }

  bool MToolType::cancel() {
    return true;
  }

  bool MToolType::inProgress() {
    return false;
  }

  int MToolType::drawTool(bool Select, const Aztec::MComponentPtr &View) {
    return 1;
  }

  int MToolType::onMouseDown(const Aztec::MMouseEvent &event) {
    m_DownPos.x = (float)event.getX();
    m_DownPos.y = (float)event.getY();
    m_CurPos.x = (float)event.getX();
    m_CurPos.y = (float)event.getY();

/*    // if we are in a gl canvas window, work out the rays for the mouse cursor.
    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      m_DownRay = canvas->getRay(event.getX(), event.getY());
      m_CurRay = m_DownRay;
    }*/
  
    return TOOLRESULT_DRAWNONE;
  }

  int MToolType::onMouseUp(const Aztec::MMouseEvent &event) {
    m_UpPos.x = (float)event.getX();
    m_UpPos.y = (float)event.getY();
    m_CurPos.x = (float)event.getX();
    m_CurPos.y = (float)event.getY();

    // if we are in a gl canvas window, work out the rays for the mouse cursor.
/*    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      m_UpRay = canvas->getRay(event.getX(), event.getY());
      m_CurRay = m_DownRay;
    }*/

    m_Dragging = false;

    return TOOLRESULT_DRAWNONE;
  }

  int MToolType::onMouseMove(const Aztec::MMouseEvent &event) {
    if (event.isLeftButtonDown() || event.isMiddleButtonDown() || event.isRightButtonDown()) {
      m_Dragging = true;
    } else {
      m_Dragging = false;
    }
  
    m_CurPos.x = (float)event.getX();
    m_CurPos.y = (float)event.getY();
  
    // if we are in a gl canvas window, work out the rays for the mouse cursor.
/*    AztecGLCanvasPtr canvas = AZTEC_CAST(AztecGLCanvas, event.getComponent());
    if (canvas != NULL) {
      m_CurRay = canvas->getRay(event.getX(), event.getY());
    }*/


    return TOOLRESULT_DRAWNONE;
  }

}
