/*

  Copyright (c) Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MImageComponentImpl.h>
#include <gui/MApplication.h>

#include "QImageWidget_.moc"


namespace Aztec {

  MImageComponent::MImageComponent() {
    imageChanged = false;
  }

  MImageComponent::~MImageComponent() {
  }

  bool MImageComponent::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our button
    if (m_Parent != 0l) parentWnd = m_Parent->getHandle();
    app = MApp::getInstance();

    // Create the actual Qt widget
    m_Handle = new CQImageWidget_(parentWnd, this);

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      onCreate();
      return true;
    }

    return false;
  }


  void MImageComponent::setImage(const Aztec::MImagePtr &i) {
    // TODO: Implementation
  }

  MImagePtr MImageComponent::getImage() {
    return image;
  }


  MSize2D MImageComponent::getMinimumSize() {
    if (image != NULL) {
      return MSize2D(image->getWidth(), image->getHeight());
    } else {
      return MComponent::getMinimumSize();
    }
  }

  bool MImageComponent::isMinimumSizeSet() {
    return true;
  }

  bool MImageComponent::onPaint() {
    if (image == NULL) {
      return false;
    }

    return true;
  }


}

