#include <AztecGUICommonPCH.h>
#include <gui/MMouseEvent.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MMouseEvent::MMouseEvent(MMouseEvent::MouseMessageType type, unsigned long time, MPoint2D pos, const MShiftState &state, const MComponentPtr &component) 
    : type(type), time(time), m_Pos(pos), m_State(state), m_Component(component)
  {
  }

  MMouseEvent::MouseMessageType MMouseEvent::getType() const {
    return type;
  }

  int MMouseEvent::getX() const {
    return m_Pos.x;
  }

  int MMouseEvent::getY() const {
    return m_Pos.y;
  }

  MPoint2D MMouseEvent::getPos() const {
    return m_Pos;
  }
  
  bool MMouseEvent::isLeftButtonDown() const {
    return m_State.leftMouseDown;
  }

  bool MMouseEvent::isMiddleButtonDown() const {
    return m_State.middleMouseDown;
  }

  bool MMouseEvent::isRightButtonDown() const {
    return m_State.rightMouseDown;
  }

  MShiftState MMouseEvent::getShiftState() const {
    return m_State;
  }

  bool MMouseEvent::isShiftDown() const {
    return m_State.shiftPressed;
  }

  bool MMouseEvent::isControlDown() const {
    return m_State.ctrlPressed;
  }

  bool MMouseEvent::isAltDown() const {
    return m_State.altPressed;
  }

  MComponentPtr MMouseEvent::getComponent() const {
    return m_Component;
  }

}
