#include <AztecGUICommonPCH.h>
#include <gui/MFlowLayout.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MFlowLayout::MFlowLayout(int horizGap, int vertGap, int maxComponentsPerRow)
    : m_HGap(horizGap), m_VGap(vertGap), m_maxComponentsPerRow(maxComponentsPerRow) { 
  }

  MFlowLayout::~MFlowLayout() { 
  }

  // Layoutmanager methods
  void MFlowLayout::addComponent(MComponentPtr component) {
  }

  void MFlowLayout::addComponent(MComponentPtr component, MConstraint constraints) {
  }

  void MFlowLayout::removeComponent(MComponentPtr component) {
  }

  MSize2D preferredSize(const MComponentPtr &comp) {
    return comp->getPreferredSize();
  }

  void setComponentPos(const MComponentPtr &comp, const MPoint2D &curPos, const MSize2D &size) {
    comp->setPosition(curPos.x, curPos.y, size.getWidth(), size.getHeight());
  }

  template <class SIZE_FUNC, class APPLY_FUNC> 
  static void iterateOverComponents(const MContainerPtr &container, int maxPerRow, int hGap, int vGap, SIZE_FUNC sizeFunc, APPLY_FUNC &applyFunc) {
    // all we do is go along the container, and
    // organise the child components horizontally across the screen.
    // if we run out of room, we go to the next line

    MSize2D maxSize, size;
    int largestHeightInRow = 0;
    MPoint2D curPos;

    maxSize = container->getClientSize();
    curPos.x = hGap;
    curPos.y = vGap;

    int compCount = 0;
    for (int index = 0; index < container->getComponentCount(); ++index) {
      MComponentPtr comp = container->getComponent(index);
      
      if (size.getHeight() > largestHeightInRow) {
        largestHeightInRow = size.getHeight();
      }

      size = sizeFunc(comp);



      // if the component goes beyond the size of the 
      // container, then we move down one line, but only
      // if we already have on component on this line
      if ((maxPerRow != -1 && compCount >= maxPerRow) ||
          (curPos.x + size.getWidth() > maxSize.getWidth() && curPos.x != hGap)) {
        curPos.x = hGap;
        curPos.y += largestHeightInRow + vGap;
        compCount = 0;
        largestHeightInRow = size.getHeight();
      }

      applyFunc(comp, curPos, size);

      curPos.x += size.getWidth() + hGap;
      compCount++;
    }
  }

  void MFlowLayout::layoutContainer(MContainerPtr container) {
    iterateOverComponents(container, m_maxComponentsPerRow, m_HGap, m_VGap, preferredSize, setComponentPos);
  }

  class SizeTracker {
  public:
    MSize2D totalSize;

    SizeTracker() : totalSize(0,0,0,0)
    {
    }
    void operator()(const MComponentPtr &comp, const MPoint2D &curPos, const MSize2D &size) {
      if (totalSize.getWidth() < curPos.x + size.getWidth()) {
        totalSize.x2 = curPos.x + size.getWidth();
      }
      if (totalSize.getHeight() < curPos.y + size.getHeight()) {
        totalSize.y2 = curPos.y + size.getHeight();
      }
    }
  };

  MSize2D MFlowLayout::getMinimumSize(MContainerPtr container) {
    // The minimum size of the container is the largest minimum size for
    // each of the child components.
    MSize2D maxSize;

    if (m_maxComponentsPerRow != -1) {
      SizeTracker tracker;
      iterateOverComponents(container, m_maxComponentsPerRow, m_HGap, m_VGap, preferredSize, tracker);
      maxSize = tracker.totalSize;

    } else {
      MSize2D size;
      for (int index = 0; index < container->getComponentCount(); ++index) {
        MComponentPtr comp = container->getComponent(index);

        size = comp->getMinimumSize();
        if (size.getWidth() > maxSize.getWidth()) {
          maxSize.setWidth(size.getWidth());
        }
      
        if (size.getHeight() > maxSize.getHeight()) {
          maxSize.setHeight(size.getHeight());
        }
      }
    }

    maxSize.adjustWidth(m_HGap * 2);
    maxSize.adjustHeight(m_VGap * 2);

    return maxSize;
  }

  MSize2D MFlowLayout::getPreferredSize(MContainerPtr container) {
    // The preferred size is the one that lays out all components across the way.
    SizeTracker tracker;
    iterateOverComponents(container, m_maxComponentsPerRow, m_HGap, m_VGap, preferredSize, tracker);
    MSize2D size = tracker.totalSize;

//    size.adjustHeight(rowSize.getHeight());

    // add on the final gap on the end
    size.adjustWidth(m_HGap);

    // add in the vertical gaps on the top and bottom
    size.adjustHeight(m_VGap * 2);

    return size;
  }

  MConstraint MFlowLayout::getConstraint(const MComponentPtr &component) {
    // flow layouts don't use constraints, so just return an empty on.
    return MConstraint();

  }

}
