
#ifndef MGLCanvasImpl_Header
#define MGLCanvasImpl_Header

#include <gui/MGLCanvas.h>

#include <qgl.h>


// Extern
class CQGLCanvas_;


namespace Aztec {

  class AZTECGUI_EXPORT MGLCanvas : public virtual Aztec::IMGLCanvas, public MComponent {
    friend class CQGLCanvas_;

  public:
    
    MGLCanvas();
    ~MGLCanvas();

    GLErrorEnum initOpenGL();
    GLErrorEnum killOpenGL();

    // IMGLCanvas methods
    GLErrorEnum makeCurrent();
    bool swapBuffers();

    // MComponent methods
    bool createImpl();

    // IMComponent methods
    bool onResize(int newWidth, int newHeight);
    bool onPaint();

  protected:
    int m_newx, m_newy;
/*    HGLRC glContext;

    GLErrorEnum makeCurrent(HDC dc);
    bool swapBuffers(HDC dc);*/
  };

}


#include <gui/qt3/MGLCanvasImpl.h>


#endif

