#ifndef MMenuBar_Header
#define MMenuBar_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MMenuBar;
  typedef MRefCountedPtr<MMenuBar> MMenuBarPtr;

}

#include <gui/MComponent.h>
#include <gui/MMenu.h>

#include <string>


namespace Aztec {

  /**
   * A Menu Bar is a component on the screen which displays the contents of a 
   * menu on the screen in one or more rows or columns.
   */
  class AZTECGUI_EXPORT IMMenuBar : public virtual IMComponent, public virtual IMMenuShell {
  protected:
    IMMenuBar() { }
    ~IMMenuBar() { }

  public:
    typedef IMMenuPtr Ptr;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MMenuBarImpl.h>


#endif

