#ifndef MComboBox_Header
#define MComboBox_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMComboBox;
  class MComboBox;

  typedef MRefCountedPtr<IMComboBox> IMComboBoxPtr;
  typedef MRefCountedPtr<MComboBox> MComboBoxPtr;

}

#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>

#include <string>


namespace Aztec {

  using std::string;

  class AZTECGUI_EXPORT IMComboBox : public virtual IMComponent {
  protected:
    IMComboBox() { }
    ~IMComboBox() { }

  public:
    class ComboBoxListener : public MRefCountedObject {
    public:
      virtual void onListen(const MComboBoxPtr &field) = 0;
    };
    typedef MRefCountedPtr<ComboBoxListener> ComboBoxListenerPtr;


    virtual void setValue(const string &value) = 0;
    virtual string getValue() = 0;

    virtual void addItem(const string &item) = 0;
    virtual void insertItem(const string &item, int index) = 0;
    virtual void removeItem(const string &item) = 0;
    virtual void removeItem(int index) = 0;
    virtual void removeAllItems() = 0;

    virtual int getItemCount() = 0;

    virtual int getSelectedIndex() = 0;
    virtual string getSelectedItem() = 0;
    virtual void setSelectedIndex(int index) = 0;
    virtual void setSelectedItem(const string &item) = 0;

    virtual void showDropDown() = 0;
    virtual void hideDropDown() = 0;
    virtual bool isDropDownVisible() = 0;

    /**
     * This is called after the value in the box has been changed.
     */
    virtual bool onChanged() = 0;

    virtual void addListener(const ComboBoxListenerPtr &listener) = 0;

  };


}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MComboBoxImpl.h>


#endif

