#ifndef MBorderLayout_Header
#define MBorderLayout_Header

#include <gui/MLayoutManager.h>
#include <gui/MPoint2D.h>
#include <gui/MComponent.h>
#include <gui/MContainer.h>

#include <string>
#include <vector>

namespace Aztec {

  class AZTECGUI_EXPORT MBorderLayout : public virtual MLayoutManager {

  public:
    static MConstraint NORTH;
    static MConstraint SOUTH;
    static MConstraint NORTH_INNER;
    static MConstraint SOUTH_INNER;
    static MConstraint EAST;
    static MConstraint WEST;
    static MConstraint CENTRE;

    MBorderLayout(int horizBorder = 0, int vertBorder = 0, int horizGap = 0, int vertGap = 0);

    ~MBorderLayout();

    // Layoutmanager methods
    void addComponent(MComponentPtr component);
    void addComponent(MComponentPtr component, MConstraint constraints);
    void removeComponent(MComponentPtr component);
    void layoutContainer(MContainerPtr container);
    MSize2D getMinimumSize(MContainerPtr container);
    MSize2D getPreferredSize(MContainerPtr container);
    MConstraint getConstraint(const MComponentPtr &component);

  protected:
    int m_VBorder, m_HBorder;
    int m_VGap, m_HGap;

    MComponentPtr m_North, m_South, m_East, m_West, m_InnerSouth, m_InnerNorth, m_Centre;

    void doHorizExtent(MSize2D &size, const MComponentPtr &comp, bool minimum = false);

    void doVerticalExtent(MSize2D &size, const MComponentPtr &comp, bool minimum = false);
  
  };

}


#endif

