#include <Aztec3DPCH.h>
#include <functions/AllFunctions.h>

#include <functions/edit/AnimationFunctions.h>
#include <functions/edit/GraphFunctions.h>
#include <functions/edit/ParentingFunctions.h>
#include <functions/edit/SelectionFunctions.h>
#include <functions/edit/TimeFunctions.h>
#include <functions/edit/VisibilityFunctions.h>
#include <functions/edit/ObjectFunctions.h>
#include <functions/edit/MaterialFunctions.h>
#include <functions/file/FileFunctions.h>
#include <functions/mesh/MeshFunctions.h>
#include <functions/tools/ToolFunctions.h>
#include <functions/view/ViewFunctions.h>
#include <functions/view/View3DFunctions.h>

namespace AztecGUI {

  void registerAllFunctions(FunctionManager &man) {

    registerFileFunctions(man);
    registerTimeFunctions(man);
    registerVisibilityFunctions(man);
    registerSelectionFunctions(man);
    registerToolFunctions(man);
    registerViewFunctions(man);
    registerObjectFunctions(man);
    registerGraphFunctions(man);
    registerAnimationFunctions(man);
    registerParentingFunctions(man);
    registerMeshFunctions(man);
    registerView3DFunctions(man);
    registerMaterialFunctions(man);

  }

}

