#ifndef Aztec2_MIKBoneTool_Header
#define Aztec2_MIKBoneTool_Header

#include <tools/M3DToolType.h>

// AztecLib includes
#include <MSceneObject.h>

namespace AztecGUI {

  class MIKBoneTool : public M3DToolType {
  public:
    MIKBoneTool();

    // MToolType methods
    std::string getName();

    void initialise();
    bool finish();
    bool cancel();

    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);

  private:
    typedef enum { PickingFirstBone, PickingSecondBone, DonePicking } CurrentState;
    Aztec::MSceneObjectPtr pickedBone;
    Aztec::MSceneObjectPtr firstBone;
    Aztec::MSceneObjectPtr secondBone;
    CurrentState currentState;

    void createIKObject();
  };

}

#endif