#ifndef MCreatePolyTool_Header
#define MCreatePolyTool_Header

#include <tools/MXYZToolType.h>

// AztecLib includes
#include <MMeshShape.h>
#include <MEditableMesh.h>

namespace AztecGUI {
  class MCreatePolyTool : public MXYZToolType {
  public:
    MCreatePolyTool();

    // MToolType methods
    std::string getName();
    void initialise();
    bool finish();
    bool cancel();
    bool inProgress();

    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int getDefaultManip();

  private:
    bool dragging;

    Aztec::MSceneObjectPtr sceneObj;
    Aztec::MMeshShapePtr shapeObj;
    Aztec::MEditableMeshPtr meshObj;

    // This is the vertex we started adding points at
    int startingVertex;
    
    // This is the first triangle that we've added in to create our polygon
    int startingTriangle;

    void getMeshObject();
    Aztec::MVector3 getPositionFromMouse(const Aztec::MMouseEvent &event);
  };
}
#endif