#ifndef Aztec2_Tool_Button_Header
#define Aztec2_Tool_Button_Header

#include <controls/CommandButton.h>

// AztecGUI includes
#include <tools/MToolManager.h>


namespace AztecGUI {

  class ToolButton : public CommandButton {
  public:
    ToolButton(const std::string &caption, const std::string &group, const std::string &toolname);

    void setTool(const std::string &caption, const std::string &group, const std::string &toolname);

    std::string name;
    std::string group;

  };

  typedef Aztec::MRefCountedPtr<ToolButton> ToolButtonPtr;

  class ToolButtonListener : public AztecGUI::MToolChangeListener {
  public:
    ToolButtonListener(ToolButton *but);
    void onToolChange(const std::string &group, MToolTypePtr oldTool);

  private:
    ToolButton *b;
  };

}

#endif
