#ifndef Aztec2_ChannelBar_Header
#define Aztec2_ChannelBar_Header

#include <gui/MContainer.h>
#include <gui/MMenuBar.h>
#include <MNamedObject.h>
#include <gui/MTextField.h>
#include <gui/MScrolledContainer.h>


namespace AztecGUI {

  class ChannelParameter : public Aztec::MRefCountedObject {
  public:
    ChannelParameter();

    ChannelParameter(const Aztec::MParameterObjectPtr &param);

    virtual Aztec::MComponentPtr createEditor(const Aztec::MContainerPtr &container);
    virtual void updateEditorValue();

    std::string getParameterName();
    Aztec::MParameterObjectPtr getParameter();
    Aztec::MComponentPtr getEditor();
  private:
    std::string paramName;
    Aztec::MParameterObjectPtr parameter;
//    Aztec::MComponentPtr editor;
    Aztec::MTextFieldPtr editor;
  };

  typedef Aztec::MRefCountedPtr<ChannelParameter> ChannelParameterPtr;

  class ChannelBar : public Aztec::MContainer {
  public:
    ChannelBar();
    ~ChannelBar();

    static ChannelBar* getInstance();

    void showParametersFor(const Aztec::MNamedObjectPtr &object);

    // MComponent methods
    Aztec::MSize2D getMinimumSize();
    void onCreate();

  protected:
    Aztec::MMenuBarPtr menu;
    Aztec::MContainerPtr scrolledContainer;
    Aztec::MScrolledContainerPtr scroller;
    Aztec::MNamedObjectPtr curObject;
    std::set<Aztec::MDAGNode*> curObjectInputs;

    typedef std::vector<ChannelParameterPtr> ParameterVector;
    ParameterVector parameters;

    typedef std::set<Aztec::MNamedObjectPtr> Objects;
    Objects objects;


    void addParameters(const Aztec::MNamedObjectPtr &object);
    void doAddParameters(const Aztec::MNamedObjectPtr &object);
    
  };

}

#endif

