#ifndef MD2TRANSLATOR_H
#define MD2TRANSLATOR_H

#include <translator/MSceneTranslator.h>

using namespace Aztec;

class MMD2Translator : public MSceneTranslator {
protected:
  
public:
  MMD2Translator();
  virtual ~MMD2Translator();
  
  // Class related
  virtual MStr getClassName() {return MStr("MMD2Translator");};
  virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
  virtual MTranslatorPtr createNew() const;
  
  std::string getFilter() { return "*.MD2"; }
  std::string getFilterDescription() { return "Quake2 Models"; }
  virtual bool canImport() {return true;};
  virtual bool canExport() {return false;};
  virtual bool canImportFile(MStr Filename);
  
  virtual bool importFile(MStr Filename, MScenePtr Scene);
  virtual bool exportFile(MStr Filename, MScenePtr Scene);
};


#define MD2_IDALIASHEADER     (('2'<<24)+('P'<<16)+('D'<<8)+'I')
#define MD2_ALIAS_VERSION     8
#define MD2_MAX_TRIANGLES	   4096
#define MD2_MAX_VERTS			2048
#define MD2_MAX_FRAMES		   2048
#define MD2_MAX_IDFRAMES      512
#define MD2_MAX_MD2SKINS		32
#define MD2_MAX_SKINNAME		64

// Misc structs/classes to help importing of various files.
struct MMD2Header
{
public:
  int id;		 // equals IDALIASHEADER
  int version;    // equals ALIAS_VERSION
  
  int skinwidth;
  int skinheight;
  int framesize; // byte size of each frame
  
  int num_skins;
  int num_xyz;
  int num_st; // greater than num_xyz for seams
  int num_tris;
  int num_glcmds; // dwords in strip/fan command list
  int num_frames;
  
  int ofs_skins; // each skin is a MAX_SKINNAME string
  int ofs_st; // byte offset from start for stverts
  int ofs_tris; // offset for dtriangles
  int ofs_frames; // offset for first frame
  int ofs_glcmds;
  int ofs_end; // end of file
};

struct MMD2SkinVertex {
  short s,t;
};

struct MMD2Triangle {
  short Vertices[3];
  short SkinVerts[3];
};

struct MMD2Vertex {
  BYTE v[3];    // X,Y,Z coordinate, packed on 0-255
  BYTE lightnormalindex;     // index of the vertex normal
};

struct MMD2FrameInfo {
  float	scale[3];
  float translate[3];
  char	name[16];
} ;


#endif
