#ifndef _ASETRANSLATOR_H
#define _ASETRANSLATOR_H

#include <translator/MSceneTranslator.h>
#include "MEditableMesh.h"

#include <stdio.h>

#define ASETAG_3DSMAX_ASCIIEXPORT      "*3DSMAX_ASCIIEXPORT"
#define ASETAG_COMMENT                 "*COMMENT"
#define ASETAG_SCENE                   "*SCENE"
#define ASETAG_MATERIAL_LIST           "*MATERIAL_LIST"
#define ASETAG_GEOMOBJECT              "*GEOMOBJECT"

using namespace Aztec;

class MASETranslator : public MSceneTranslator {
protected:
   int      m_TabCount;

public:
   MASETranslator();
   virtual ~MASETranslator();


   // Class related
   virtual MStr getClassName() {return MStr("MASETranslator");};
   virtual MStr getParentClassName() {return MStr("MSceneTranslator");};
   MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.ASE"; }
   std::string getFilterDescription() { return "Ascii Scene Files"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MScenePtr Scene);
   virtual bool exportFile(MStr Filename, MScenePtr Scene);

   // Import Functions

   void AdvanceLine(char *&Buf);
   int SeparateLine(char *&Buffer, MStr &TagName, MStr &Parameter);

   bool ParseFile(char *Buffer, int Length, MScenePtr Scene);
   // Scans the buffer until a closing brace is found. Also handles nested { }
   bool ParseSkipBlock(char *&Buffer, char *End);
   bool ParseSceneTag(char *&Buffer, char *End, MScenePtr Scene);
   bool ParseGeomObjectTag(char *&Buffer, char *End, MScenePtr Scene);
   bool ParseNodeTMTag(char *&Buffer, char *End, MScenePtr Scene, MSceneObjectPtr Obj);
   bool ParseMeshTag(char *&Buffer, char *End, MScenePtr Scene, MEditableMeshPtr Mesh);
   bool ParseVertexListTag(char *&Buffer, char *End, MScenePtr Scene, MVector3 *Verts);
   bool ParseTriangleListTag(char *&Buffer, char *End, MScenePtr Scene, MTriangle *Tris);
   bool ParseTextureVertexListTag(char *&Buffer, char *End, MScenePtr Scene, MVector3 *Verts);
   bool ParseTextureTriangleListTag(char *&Buffer, char *End, MScenePtr Scene, MTriangle *Tris);
	bool ParseMaterialListTag(char *&Buffer, char *End, MScenePtr Scene);


   // Export Functions
   int ASEWrite(FILE *hFile, const MStr &Str);
   int ASEWrite(FILE *hFile, const char *Str);

//   bool ParseTextureVertexListTag(char *&Buffer, char *End, MScenePtr Scene, MVertex *Verts);
//   bool ParseTextureTriangleListTag(char *&Buffer, char *End, MScenePtr Scene, MTriangle *Tris);
};


#endif
