/**
 * StdPrimitives.cpp
 *
 * Defines the entry point for the DLL / shared object.
 */

#include "Stdafx.h"

#include "ModelGeneric.h"
#include "MParameterObject.h"
#include "MSystemManager.h"

#include "StdPrimitives.h"

#include "PrimCube.h"
#include "PrimSphere.h"
#include "PrimSubdiv.h"
#include "PrimCSG.h"
#include "PrimTri.h"
#include "PrimCylinder.h"
#include "PrimPolyhedra.h"
#include "Plane.h"


#if defined( _DEBUG ) && defined( _MSC_VER )
  // Memory leak detection for MS compiler
  #define new DEBUG_NEW
  #undef THIS_FILE
  static char THIS_FILE[] = __FILE__;
#endif


MSystemManager *primSysMan = NULL;


#ifdef _WIN32

BOOL APIENTRY DllMain(HANDLE hModule,
                      DWORD ul_reason_for_call,
                      LPVOID lpReserved)
{
  switch (ul_reason_for_call) {
    case DLL_PROCESS_ATTACH:
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
      break;
  }

  return TRUE;
}

#else

/**
 * If someone would ever like to make use of DllMain on Windows
 * to initialize some stuff: go ahead, we can use _init and _fini
 * on Linux (not sure about xBSD though).
 */

#endif


PRIMITIVES_API int ModQueryVersion(long *Dest) {
  memcpy(Dest, MODEL_API_VERSION, 4);
  return 1;
}

PRIMITIVES_API int ModQueryDesc(char *Dest) {
  strcpy(Dest, "Contains the basic primitive Objects.");
  return 1;
}

PRIMITIVES_API int ModQueryCount() {
  return 8;
}

PRIMITIVES_API int ModRegister(MSystemManager *SysMan, int IDNo) {

  // Cache the system manager for later use
  primSysMan = SysMan;

  // Register the primitive types we know about
  switch (IDNo) {
  case 0:
    return SysMan->getPluginManager()->registerPrimitive(new MPrimitiveCube, "Cube");
    break;
  case 1:
    return SysMan->getPluginManager()->registerPrimitive(new MPrimitiveSphere, "GeoSphere");
    break;
  case 2:
    return SysMan->getPluginManager()->registerPrimitive(new MPrimitiveSubdiv, "Subdiv");
    break;
  case 3:
    return SysMan->getPluginManager()->registerPrimitive(new MPrimitiveCSG, "CSG");
    break;
  case 4:
    return SysMan->getPluginManager()->registerPrimitive(new MPrimitiveTri, "Triangle");
    break;
  case 5:
    return SysMan->getPluginManager()->registerPrimitive(new MCylinder, "Cylinder");
  case 6:
    return SysMan->getPluginManager()->registerPrimitive(new MPolyhedra, "Polyhedra");
  case 7:
    return SysMan->getPluginManager()->registerPrimitive(new Plane(), "Plane");
  }

  return 0;
}

